/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.internal;

import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;

public class AllureThreadContext {
    private final Context context = new Context();

    public Optional<String> getCurrent() {
        LinkedList uuids = (LinkedList)this.context.get();
        return uuids.isEmpty() ? Optional.empty() : Optional.of(uuids.getFirst());
    }

    public Optional<String> getRoot() {
        LinkedList uuids = (LinkedList)this.context.get();
        return uuids.isEmpty() ? Optional.empty() : Optional.of(uuids.getLast());
    }

    public void start(String uuid) {
        Objects.requireNonNull(uuid, "step uuid");
        ((LinkedList)this.context.get()).push(uuid);
    }

    public Optional<String> stop() {
        LinkedList uuids = (LinkedList)this.context.get();
        if (!uuids.isEmpty()) {
            return Optional.of(uuids.pop());
        }
        return Optional.empty();
    }

    public void clear() {
        this.context.remove();
    }

    private static class Context
    extends InheritableThreadLocal<LinkedList<String>> {
        private Context() {
        }

        @Override
        public LinkedList<String> initialValue() {
            return new LinkedList<String>();
        }

        @Override
        protected LinkedList<String> childValue(LinkedList<String> parentStepContext) {
            return new LinkedList<String>(parentStepContext);
        }
    }
}

