/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.internal;

import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;

public class AllureThreadContext {
    private final Context context = new Context();

    public Optional<String> getCurrent() {
        Deque uuids = (Deque)this.context.get();
        return uuids.isEmpty() ? Optional.empty() : Optional.of((String)uuids.getFirst());
    }

    public Optional<String> getRoot() {
        Deque uuids = (Deque)this.context.get();
        return uuids.isEmpty() ? Optional.empty() : Optional.of((String)uuids.getLast());
    }

    public void start(String uuid) {
        Objects.requireNonNull(uuid, "step uuid");
        ((Deque)this.context.get()).push(uuid);
    }

    public Optional<String> stop() {
        Deque uuids = (Deque)this.context.get();
        if (!uuids.isEmpty()) {
            return Optional.of((String)uuids.pop());
        }
        return Optional.empty();
    }

    public void clear() {
        this.context.remove();
    }

    private static final class Context
    extends InheritableThreadLocal<Deque<String>> {
        private Context() {
        }

        @Override
        public Deque<String> initialValue() {
            return new LinkedList<String>();
        }

        @Override
        protected Deque<String> childValue(Deque<String> parentStepContext) {
            return new LinkedList<String>(parentStepContext);
        }
    }
}

