/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.junitplatform;

import java.lang.reflect.Method;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AllureJunitPlatformUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllureJunitPlatformUtils.class);

    private AllureJunitPlatformUtils() {
        throw new IllegalStateException("do not instance");
    }

    public static Optional<String> getFullName(TestSource source) {
        if (source instanceof MethodSource) {
            MethodSource ms = (MethodSource)source;
            return Optional.of(String.format("%s.%s", ms.getClassName(), ms.getMethodName()));
        }
        if (source instanceof ClassSource) {
            ClassSource cs = (ClassSource)source;
            return Optional.ofNullable(cs.getClassName());
        }
        return Optional.empty();
    }

    public static Optional<Class<?>> getTestClass(TestSource source) {
        if (source instanceof MethodSource) {
            return AllureJunitPlatformUtils.getTestClass(((MethodSource)source).getClassName());
        }
        if (source instanceof ClassSource) {
            return Optional.of(((ClassSource)source).getJavaClass());
        }
        return Optional.empty();
    }

    public static Optional<Class<?>> getTestClass(String className) {
        try {
            return Optional.of(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            LOGGER.trace("Could not get test class from test source {}", (Object)className, (Object)e);
            return Optional.empty();
        }
    }

    public static Optional<Method> getTestMethod(TestSource source) {
        if (source instanceof MethodSource) {
            return AllureJunitPlatformUtils.getTestMethod((MethodSource)source);
        }
        return Optional.empty();
    }

    public static Optional<Method> getTestMethod(MethodSource source) {
        try {
            Class<?> aClass = Class.forName(source.getClassName());
            return Stream.of(aClass.getDeclaredMethods()).filter(method -> MethodSource.from((Method)method).equals((Object)source)).findAny();
        }
        catch (ClassNotFoundException e) {
            LOGGER.trace("Could not get test method from method source {}", (Object)source, (Object)e);
            return Optional.empty();
        }
    }
}

