/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.maven;

import io.qameta.allure.maven.AllureGenerateMojo;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="report", defaultPhase=LifecyclePhase.SITE)
public class AllureReportMojo
extends AllureGenerateMojo {
    @Override
    protected List<Path> getInputDirectories() {
        Path path = this.getInputDirectoryAbsolutePath();
        if (this.isDirectoryExists(path)) {
            this.getLog().info((CharSequence)("Found results directory " + path));
            return Collections.singletonList(path);
        }
        this.getLog().error((CharSequence)("Directory " + path + " not found."));
        return Collections.emptyList();
    }

    @Override
    protected String getMojoName() {
        return "report";
    }

    private Path getInputDirectoryAbsolutePath() {
        Path path = Paths.get(this.resultsDirectory, new String[0]);
        return path.isAbsolute() ? path : Paths.get(this.buildDirectory, new String[0]).resolve(path);
    }
}

