/*
 * Decompiled with CFR 0.152.
 */
package io.qase.api.services.impl;

import com.google.inject.Inject;
import io.qase.api.CasesStorage;
import io.qase.api.QaseClient;
import io.qase.api.exceptions.QaseException;
import io.qase.api.services.QaseTestCaseListener;
import io.qase.api.services.ReportersResultOperations;
import io.qase.client.api.RunsApi;
import io.qase.client.model.ResultCreate;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QaseTestCaseListenerImpl
implements QaseTestCaseListener {
    private static final Logger log = LoggerFactory.getLogger(QaseTestCaseListenerImpl.class);
    private final ThreadLocal<Long> startTime = new ThreadLocal();
    private final RunsApi runsApi;
    private final ReportersResultOperations resultOperations;

    @Override
    public void onTestCasesSetFinished() {
        if (!QaseClient.isEnabled()) {
            return;
        }
        if (QaseClient.getConfig().useBulk()) {
            this.resultOperations.sendBulkResult();
        }
        if (QaseClient.getConfig().runAutocomplete()) {
            try {
                this.runsApi.completeRun(QaseClient.getConfig().projectCode(), QaseClient.getConfig().runId());
            }
            catch (QaseException e) {
                log.error(e.getMessage());
            }
        }
    }

    @Override
    public void onTestCaseStarted() {
        if (!QaseClient.isEnabled()) {
            return;
        }
        CasesStorage.startCase(new ResultCreate());
        this.startTestCaseTimer();
    }

    @Override
    public void onTestCaseFinished(Consumer<ResultCreate> resultCreateConfigurer) {
        if (!QaseClient.isEnabled()) {
            return;
        }
        ResultCreate resultCreate = CasesStorage.getCurrentCase();
        if (resultCreate == null) {
            return;
        }
        resultCreate.timeMs(this.stopTestCaseTimer());
        resultCreateConfigurer.accept(resultCreate);
        CasesStorage.stopCase();
        if (resultCreate.getCaseId() == null && (resultCreate.getCase() == null || resultCreate.getCase().getTitle() == null)) {
            return;
        }
        if (QaseClient.getConfig().useBulk()) {
            this.resultOperations.addBulkResult(resultCreate);
        } else {
            this.resultOperations.send(resultCreate);
        }
    }

    private void startTestCaseTimer() {
        this.startTime.set(System.currentTimeMillis());
    }

    private long stopTestCaseTimer() {
        long testCaseStartTime = this.startTime.get();
        this.startTime.remove();
        return System.currentTimeMillis() - testCaseStartTime;
    }

    @Inject
    public QaseTestCaseListenerImpl(RunsApi runsApi, ReportersResultOperations resultOperations) {
        this.runsApi = runsApi;
        this.resultOperations = resultOperations;
    }
}

