/*
 * Decompiled with CFR 0.152.
 */
package io.qase.client.api;

import com.google.gson.reflect.TypeToken;
import io.qase.api.exceptions.QaseException;
import io.qase.client.ApiCallback;
import io.qase.client.ApiClient;
import io.qase.client.ApiResponse;
import io.qase.client.Configuration;
import io.qase.client.Pair;
import io.qase.client.model.EnvironmentCreate;
import io.qase.client.model.EnvironmentListResponse;
import io.qase.client.model.EnvironmentResponse;
import io.qase.client.model.EnvironmentUpdate;
import io.qase.client.model.IdResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class EnvironmentsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public EnvironmentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EnvironmentsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createEnvironmentCall(String code, EnvironmentCreate environmentCreate, ApiCallback _callback) throws QaseException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        EnvironmentCreate localVarPostBody = environmentCreate;
        String localVarPath = "/environment/{code}".replace("{code}", this.localVarApiClient.escapeString(code.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createEnvironmentValidateBeforeCall(String code, EnvironmentCreate environmentCreate, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling createEnvironment(Async)");
        }
        if (environmentCreate == null) {
            throw new QaseException("Missing the required parameter 'environmentCreate' when calling createEnvironment(Async)");
        }
        return this.createEnvironmentCall(code, environmentCreate, _callback);
    }

    public IdResponse createEnvironment(String code, EnvironmentCreate environmentCreate) throws QaseException {
        ApiResponse<IdResponse> localVarResp = this.createEnvironmentWithHttpInfo(code, environmentCreate);
        return localVarResp.getData();
    }

    public ApiResponse<IdResponse> createEnvironmentWithHttpInfo(String code, EnvironmentCreate environmentCreate) throws QaseException {
        Call localVarCall = this.createEnvironmentValidateBeforeCall(code, environmentCreate, null);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createEnvironmentAsync(String code, EnvironmentCreate environmentCreate, ApiCallback<IdResponse> _callback) throws QaseException {
        Call localVarCall = this.createEnvironmentValidateBeforeCall(code, environmentCreate, _callback);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteEnvironmentCall(String code, Integer id, ApiCallback _callback) throws QaseException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/environment/{code}/{id}".replace("{code}", this.localVarApiClient.escapeString(code.toString())).replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteEnvironmentValidateBeforeCall(String code, Integer id, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling deleteEnvironment(Async)");
        }
        if (id == null) {
            throw new QaseException("Missing the required parameter 'id' when calling deleteEnvironment(Async)");
        }
        return this.deleteEnvironmentCall(code, id, _callback);
    }

    public IdResponse deleteEnvironment(String code, Integer id) throws QaseException {
        ApiResponse<IdResponse> localVarResp = this.deleteEnvironmentWithHttpInfo(code, id);
        return localVarResp.getData();
    }

    public ApiResponse<IdResponse> deleteEnvironmentWithHttpInfo(String code, Integer id) throws QaseException {
        Call localVarCall = this.deleteEnvironmentValidateBeforeCall(code, id, null);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteEnvironmentAsync(String code, Integer id, ApiCallback<IdResponse> _callback) throws QaseException {
        Call localVarCall = this.deleteEnvironmentValidateBeforeCall(code, id, _callback);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getEnvironmentCall(String code, Integer id, ApiCallback _callback) throws QaseException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/environment/{code}/{id}".replace("{code}", this.localVarApiClient.escapeString(code.toString())).replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getEnvironmentValidateBeforeCall(String code, Integer id, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling getEnvironment(Async)");
        }
        if (id == null) {
            throw new QaseException("Missing the required parameter 'id' when calling getEnvironment(Async)");
        }
        return this.getEnvironmentCall(code, id, _callback);
    }

    public EnvironmentResponse getEnvironment(String code, Integer id) throws QaseException {
        ApiResponse<EnvironmentResponse> localVarResp = this.getEnvironmentWithHttpInfo(code, id);
        return localVarResp.getData();
    }

    public ApiResponse<EnvironmentResponse> getEnvironmentWithHttpInfo(String code, Integer id) throws QaseException {
        Call localVarCall = this.getEnvironmentValidateBeforeCall(code, id, null);
        Type localVarReturnType = new TypeToken<EnvironmentResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getEnvironmentAsync(String code, Integer id, ApiCallback<EnvironmentResponse> _callback) throws QaseException {
        Call localVarCall = this.getEnvironmentValidateBeforeCall(code, id, _callback);
        Type localVarReturnType = new TypeToken<EnvironmentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getEnvironmentsCall(String code, Integer limit, Integer offset, ApiCallback _callback) throws QaseException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/environment/{code}".replace("{code}", this.localVarApiClient.escapeString(code.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getEnvironmentsValidateBeforeCall(String code, Integer limit, Integer offset, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling getEnvironments(Async)");
        }
        return this.getEnvironmentsCall(code, limit, offset, _callback);
    }

    public EnvironmentListResponse getEnvironments(String code, Integer limit, Integer offset) throws QaseException {
        ApiResponse<EnvironmentListResponse> localVarResp = this.getEnvironmentsWithHttpInfo(code, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<EnvironmentListResponse> getEnvironmentsWithHttpInfo(String code, Integer limit, Integer offset) throws QaseException {
        Call localVarCall = this.getEnvironmentsValidateBeforeCall(code, limit, offset, null);
        Type localVarReturnType = new TypeToken<EnvironmentListResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getEnvironmentsAsync(String code, Integer limit, Integer offset, ApiCallback<EnvironmentListResponse> _callback) throws QaseException {
        Call localVarCall = this.getEnvironmentsValidateBeforeCall(code, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<EnvironmentListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateEnvironmentCall(String code, Integer id, EnvironmentUpdate environmentUpdate, ApiCallback _callback) throws QaseException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        EnvironmentUpdate localVarPostBody = environmentUpdate;
        String localVarPath = "/environment/{code}/{id}".replace("{code}", this.localVarApiClient.escapeString(code.toString())).replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateEnvironmentValidateBeforeCall(String code, Integer id, EnvironmentUpdate environmentUpdate, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling updateEnvironment(Async)");
        }
        if (id == null) {
            throw new QaseException("Missing the required parameter 'id' when calling updateEnvironment(Async)");
        }
        if (environmentUpdate == null) {
            throw new QaseException("Missing the required parameter 'environmentUpdate' when calling updateEnvironment(Async)");
        }
        return this.updateEnvironmentCall(code, id, environmentUpdate, _callback);
    }

    public IdResponse updateEnvironment(String code, Integer id, EnvironmentUpdate environmentUpdate) throws QaseException {
        ApiResponse<IdResponse> localVarResp = this.updateEnvironmentWithHttpInfo(code, id, environmentUpdate);
        return localVarResp.getData();
    }

    public ApiResponse<IdResponse> updateEnvironmentWithHttpInfo(String code, Integer id, EnvironmentUpdate environmentUpdate) throws QaseException {
        Call localVarCall = this.updateEnvironmentValidateBeforeCall(code, id, environmentUpdate, null);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateEnvironmentAsync(String code, Integer id, EnvironmentUpdate environmentUpdate, ApiCallback<IdResponse> _callback) throws QaseException {
        Call localVarCall = this.updateEnvironmentValidateBeforeCall(code, id, environmentUpdate, _callback);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

