/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.artemis.jms.runtime.health;

import io.quarkus.artemis.core.runtime.ArtemisBuildTimeConfigs;
import io.quarkus.artemis.core.runtime.ArtemisRuntimeConfig;
import io.quarkus.artemis.core.runtime.ArtemisRuntimeConfigs;
import io.quarkus.artemis.core.runtime.ArtemisUtil;
import io.quarkus.artemis.core.runtime.health.ArtemisHealthSupport;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
public class ConnectionFactoryHealthCheck
implements HealthCheck {
    private final Instance<ConnectionFactory> connectionFactories;
    private final Set<String> connectionFactoryNames;

    public ConnectionFactoryHealthCheck(ArtemisRuntimeConfigs runtimeConfigs, ArtemisBuildTimeConfigs buildTimeConfigs, ArtemisHealthSupport support, @Any Instance<ConnectionFactory> connectionFactories) {
        this.connectionFactories = connectionFactories;
        this.connectionFactoryNames = support.getConfiguredNames().stream().filter(name -> ((ArtemisRuntimeConfig)runtimeConfigs.configs().get(name)).isHealthInclude()).collect(Collectors.toCollection(HashSet::new));
        this.connectionFactoryNames.addAll(ArtemisUtil.getExternalNames(ConnectionFactory.class, (ArtemisRuntimeConfigs)runtimeConfigs, (ArtemisBuildTimeConfigs)buildTimeConfigs));
    }

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"Artemis JMS health check").up();
        for (String name : this.connectionFactoryNames) {
            Annotation identifier = ArtemisUtil.toIdentifier((String)name);
            try {
                Connection ignored = ((ConnectionFactory)this.connectionFactories.select(new Annotation[]{identifier}).get()).createConnection();
                try {
                    builder.withData(name, "UP");
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                }
            }
            catch (Exception e) {
                builder.withData(name, "DOWN").down();
            }
        }
        return builder.build();
    }
}

