/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.googlecloudservices.common;

import com.google.cloud.PlatformInformation;
import com.google.cloud.ServiceDefaults;
import com.google.cloud.ServiceOptions;
import com.google.common.annotations.VisibleForTesting;
import io.smallrye.config.ConfigSourceContext;
import io.smallrye.config.ConfigSourceFactory;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.Converters;
import io.smallrye.config.PropertiesConfigSource;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class GcpDefaultsConfigSourceFactory
implements ConfigSourceFactory {
    private final Supplier<String> defaultProjectIdSupplier;

    public GcpDefaultsConfigSourceFactory() {
        this(ServiceOptionsHelper::getDefaultProjectId);
    }

    @VisibleForTesting
    GcpDefaultsConfigSourceFactory(Supplier<String> defaultProjectIdSupplier) {
        this.defaultProjectIdSupplier = defaultProjectIdSupplier;
    }

    public Iterable<ConfigSource> getConfigSources(ConfigSourceContext context) {
        String defaultProjectId;
        ConfigValue enableMetadataServer = context.getValue("quarkus.google.cloud.enable-metadata-server");
        if (enableMetadataServer.getValue() != null && ((Boolean)Converters.getImplicitConverter(Boolean.class).convert(enableMetadataServer.getValue())).booleanValue() && (defaultProjectId = this.defaultProjectIdSupplier.get()) != null) {
            return Collections.singletonList(new PropertiesConfigSource(Map.of("quarkus.google.cloud.project-id", defaultProjectId), "GcpDefaultsConfigSource", -2147483647));
        }
        return Collections.emptyList();
    }

    static class ServiceOptionsHelper
    extends ServiceOptions {
        protected ServiceOptionsHelper(Class serviceFactoryClass, Class rpcFactoryClass, ServiceOptions.Builder builder, ServiceDefaults serviceDefaults) {
            super(serviceFactoryClass, rpcFactoryClass, builder, serviceDefaults);
            throw new UnsupportedOperationException();
        }

        protected Set<String> getScopes() {
            throw new UnsupportedOperationException();
        }

        public ServiceOptions.Builder toBuilder() {
            throw new UnsupportedOperationException();
        }

        public static String getDefaultProjectId() {
            String projectId = System.getProperty("GOOGLE_CLOUD_PROJECT", System.getenv("GOOGLE_CLOUD_PROJECT"));
            if (projectId == null) {
                projectId = System.getProperty("GCLOUD_PROJECT", System.getenv("GCLOUD_PROJECT"));
            }
            if (projectId == null) {
                projectId = ServiceOptionsHelper.getAppEngineProjectId();
            }
            if (projectId == null) {
                projectId = ServiceOptionsHelper.getServiceAccountProjectId();
            }
            return projectId != null ? projectId : ServiceOptionsHelper.getGoogleCloudProjectId();
        }

        protected static String getAppEngineProjectId() {
            String projectId;
            if (PlatformInformation.isOnGAEStandard7()) {
                projectId = ServiceOptionsHelper.getAppEngineProjectIdFromAppId();
            } else {
                projectId = System.getenv("GOOGLE_CLOUD_PROJECT");
                if (projectId == null) {
                    projectId = System.getenv("GCLOUD_PROJECT");
                }
                if (projectId == null) {
                    projectId = ServiceOptionsHelper.getAppEngineProjectIdFromAppId();
                }
                if (projectId == null) {
                    try {
                        projectId = ServiceOptionsHelper.getAppEngineProjectIdFromMetadataServer();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            return projectId;
        }

        private static String getAppEngineProjectIdFromMetadataServer() throws IOException {
            String metadata = "http://metadata.google.internal";
            String projectIdURL = "/computeMetadata/v1/project/project-id";
            try {
                URI uri = new URI(metadata + projectIdURL);
                HttpClient client = HttpClient.newBuilder().connectTimeout(Duration.ofMillis(500L)).build();
                HttpRequest request = HttpRequest.newBuilder().timeout(Duration.ofMillis(500L)).GET().uri(uri).header("Metadata-Flavor", "Google").build();
                HttpResponse.BodyHandler<String> bodyHandler = HttpResponse.BodyHandlers.ofString();
                HttpResponse<String> response = client.send(request, bodyHandler);
                return ServiceOptionsHelper.headerContainsMetadataFlavor(response) ? response.body() : null;
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(e);
            }
        }

        private static boolean headerContainsMetadataFlavor(HttpResponse<?> response) {
            String metadataFlavorValue = response.headers().firstValue("Metadata-Flavor").orElse("");
            return "Google".equals(metadataFlavorValue);
        }
    }
}

