/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.googlecloudservices.logging.runtime;

import com.google.cloud.logging.LoggingHandler;
import com.google.cloud.logging.Severity;
import com.google.cloud.logging.Synchronicity;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import java.util.Map;
import java.util.Optional;

@ConfigMapping(prefix="quarkus.google.cloud.logging")
@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public interface LoggingConfiguration {
    public String defaultLog();

    @WithDefault(value="true")
    public boolean enabled();

    @WithDefault(value="TEXT")
    public LogFormat format();

    public Optional<Synchronicity> synchronicity();

    public Optional<ConfigLevel> flushLevel();

    public Map<String, String> defaultLabel();

    public ResourceConfig resource();

    public GcpTracingConfig gcpTracing();

    public StructuredConfig structured();

    @WithDefault(value="CLOUD_LOGGING")
    public LoggingHandler.LogTarget logTarget();

    public static enum LogFormat {
        TEXT,
        JSON;

    }

    public static enum ConfigLevel {
        DEBUG(Severity.DEBUG),
        INFO(Severity.INFO),
        WARN(Severity.WARNING),
        ERROR(Severity.ERROR),
        FATAL(Severity.CRITICAL);

        private Severity severity;

        private ConfigLevel(Severity severity) {
            this.severity = severity;
        }

        public Severity getSeverity() {
            return this.severity;
        }
    }

    public static interface ParametersConfig {
        @WithDefault(value="true")
        public boolean included();

        @WithDefault(value="parameters")
        public String fieldName();
    }

    public static interface StackTraceConfig {
        @WithDefault(value="true")
        public boolean included();
    }

    public static interface MDCConfig {
        @WithDefault(value="true")
        public boolean included();

        @WithDefault(value="mdc")
        public String fieldName();
    }

    public static interface ResourceConfig {
        @WithDefault(value="global")
        public String type();

        public Map<String, String> label();
    }

    public static interface GcpTracingConfig {
        @WithDefault(value="true")
        public boolean enabled();

        public Optional<String> projectId();
    }

    public static interface StructuredConfig {
        public StackTraceConfig stackTrace();

        public MDCConfig mdc();

        public ParametersConfig parameters();
    }
}

