/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.googlecloudservices.logging.runtime.ecs;

import com.google.common.base.Strings;
import io.quarkiverse.googlecloudservices.logging.runtime.LoggingConfiguration;
import io.quarkiverse.googlecloudservices.logging.runtime.TraceInfo;
import io.quarkiverse.googlecloudservices.logging.runtime.util.SimpleFormatter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.ErrorManager;
import java.util.logging.Level;
import org.jboss.logmanager.ExtLogRecord;

public class EscJsonFormat {
    private static final SimpleFormatter MSG_FORMAT = new SimpleFormatter();
    protected LoggingConfiguration config;
    protected ErrorManager errorManager;

    public Map<String, ?> format(ExtLogRecord record, TraceInfo tracing) {
        return this.toEsc(record, tracing);
    }

    public void init(LoggingConfiguration config, ErrorManager errorManager) {
        this.setLoggingConfiguration(config);
        this.setErrorManager(errorManager);
    }

    public void setLoggingConfiguration(LoggingConfiguration config) {
        this.config = config;
    }

    public void setErrorManager(ErrorManager errorManager) {
        this.errorManager = errorManager;
    }

    public Map<String, ?> toEsc(ExtLogRecord record, TraceInfo tracing) {
        if (this.config == null) {
            return null;
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        this.putEcsVersion(m);
        this.putTimestamp(m, record.getInstant());
        this.putLoggerName(m, record.getLoggerName(), record.getLoggerClassName());
        this.putThreadName(m, record.getThreadName());
        this.putThreadId(m, record.getThreadID());
        this.putFormattedMessage(m, record);
        this.putLogLevel(m, record.getLevel());
        this.putSource(m, record.getSourceClassName(), record.getSourceLineNumber(), record.getSourceMethodName());
        this.putThrown(m, record.getThrown());
        this.putHost(m, record.getHostName());
        this.putMdcIfEnabled(m, record.getMdcCopy());
        this.putParametersIfEnabled(m, record.getParameters());
        if (tracing != null) {
            this.putTracing(m, tracing);
        }
        return m;
    }

    protected void putTracing(Map<String, Object> m, TraceInfo tracing) {
        if (!Strings.isNullOrEmpty((String)tracing.getTraceId())) {
            this.getOrCreateObject(m, "trace").put("id", tracing.getTraceId());
        }
        if (!Strings.isNullOrEmpty((String)tracing.getSpanId())) {
            this.getOrCreateObject(m, "span").put("id", tracing.getSpanId());
        }
    }

    protected void putParametersIfEnabled(Map<String, Object> m, Object[] parameters) {
        if (parameters != null && parameters.length > 0 && this.config.structured().parameters().included()) {
            List list = (List)m.computeIfAbsent(this.config.structured().parameters().fieldName(), k -> new ArrayList(parameters.length));
            for (Object o : parameters) {
                if (!this.shouldIncludeParameter(o)) continue;
                list.add(String.valueOf(o));
            }
        }
    }

    protected boolean shouldIncludeParameter(Object p) {
        return true;
    }

    protected void putHost(Map<String, Object> m, String hostName) {
        if (!Strings.isNullOrEmpty((String)hostName)) {
            this.getOrCreateObject(m, "host").put("name", hostName);
        }
    }

    protected void putThrown(Map<String, Object> m, Throwable thrown) {
        if (thrown != null) {
            Map<String, Object> error = this.getOrCreateObject(m, "error");
            error.put("type", thrown.getClass().getName());
            String msg = thrown.getMessage();
            if (!Strings.isNullOrEmpty((String)msg)) {
                error.put("message", msg);
            }
            if (this.config.structured().stackTrace().included()) {
                StringWriter sw = new StringWriter(1024);
                PrintWriter pw = new PrintWriter(sw);
                thrown.printStackTrace(pw);
                pw.flush();
                error.put("stack_trace", sw.toString());
            }
        }
    }

    protected void putMdcIfEnabled(Map<String, Object> m, Map<String, String> mdcCopy) {
        if (mdcCopy != null && !mdcCopy.isEmpty() && this.config.structured().mdc().included()) {
            Map<String, Object> mdc = this.getOrCreateObject(m, this.config.structured().mdc().fieldName());
            mdcCopy.forEach((k, v) -> mdc.put((String)k, v));
        }
    }

    protected void putSource(Map<String, Object> m, String sourceClassName, int sourceLineNumber, String sourceMethodName) {
        if (!Strings.isNullOrEmpty((String)sourceClassName)) {
            Map<String, Object> log = this.getOrCreateObject(m, "log");
            Map<String, Object> origin = this.getOrCreateObject(log, "origin");
            Map<String, Object> clazz = this.getOrCreateObject(origin, "class");
            clazz.put("name", sourceClassName);
            clazz.put("line", sourceLineNumber);
            if (!Strings.isNullOrEmpty((String)sourceMethodName)) {
                origin.put("function", sourceMethodName);
            }
        }
    }

    protected void putLogLevel(Map<String, Object> m, Level level) {
        this.getOrCreateObject(m, "log").put("level", level.getName());
    }

    protected void putFormattedMessage(Map<String, Object> m, ExtLogRecord record) {
        m.put("message", MSG_FORMAT.format(record));
    }

    protected void putThreadId(Map<String, Object> m, long longThreadID) {
        if (longThreadID != 0L) {
            this.getOrCreateObject(this.getOrCreateObject(m, "process"), "thread").put("id", longThreadID);
        }
    }

    protected void putThreadName(Map<String, Object> m, String threadName) {
        if (!Strings.isNullOrEmpty((String)threadName)) {
            this.getOrCreateObject(this.getOrCreateObject(m, "process"), "thread").put("name", threadName);
        }
    }

    protected void putLoggerName(Map<String, Object> m, String loggerName, String loggerClassName) {
        if (!Strings.isNullOrEmpty((String)loggerClassName)) {
            this.getOrCreateObject(m, "log").put("logger", loggerClassName);
        } else if (!Strings.isNullOrEmpty((String)loggerName)) {
            this.getOrCreateObject(m, "log").put("logger", loggerName);
        }
    }

    protected Map<String, Object> getOrCreateObject(Map<String, Object> m, String name) {
        return (Map)m.computeIfAbsent(name, k -> new HashMap(3));
    }

    protected void putEcsVersion(Map<String, Object> m) {
        this.getOrCreateObject(m, "ecs").put("version", "1.2.0");
    }

    protected void putTimestamp(Map<String, Object> m, Instant instant) {
        m.put("@timestamp", instant.atOffset(ZoneOffset.UTC).toString());
    }
}

