/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.googlecloudservices.logging.runtime.cdi;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.logging.Logging;
import com.google.cloud.logging.LoggingOptions;
import io.quarkiverse.googlecloudservices.common.GcpBootstrapConfiguration;
import io.quarkiverse.googlecloudservices.common.GcpConfigHolder;
import io.quarkiverse.googlecloudservices.logging.runtime.LoggingConfiguration;
import io.quarkus.arc.Unremovable;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;

@Singleton
public class LoggingProducer {
    @Inject
    GoogleCredentials googleCredentials;
    @Inject
    GcpConfigHolder gcpConfigHolder;
    @Inject
    LoggingConfiguration loggingConfig;

    @Default
    @Produces
    @Singleton
    @Unremovable
    public Logging create() {
        GcpBootstrapConfiguration gcpConfiguration = this.gcpConfigHolder.getBootstrapConfig();
        String projectId = gcpConfiguration.projectId().orElse(null);
        Logging log = (Logging)((LoggingOptions.Builder)((LoggingOptions.Builder)LoggingOptions.getDefaultInstance().toBuilder().setCredentials((Credentials)this.googleCredentials)).setProjectId(projectId)).build().getService();
        this.loggingConfig.flushLevel.ifPresent(level -> log.setFlushSeverity(level.getSeverity()));
        this.loggingConfig.synchronicity.ifPresent(sync -> log.setWriteSynchronicity(sync));
        return log;
    }
}

