/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.opentelemetry.exporter.common.runtime;

import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.ReadWriteSpan;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

public class LateBoundSpanProcessor
implements SpanProcessor {
    private static final Logger log = Logger.getLogger(LateBoundSpanProcessor.class);
    private boolean warningLogged = false;
    private SpanProcessor delegate;

    public void setSpanProcessorDelegate(SpanProcessor delegate) {
        this.delegate = delegate;
    }

    private <T> T handleDelegate(Function<SpanProcessor, T> fn, Supplier<T> defaultResult) {
        if (this.delegate == null) {
            if (!this.warningLogged) {
                log.warn((Object)"No SpanProcessor delegate specified, no action taken.");
                this.warningLogged = true;
            }
            return defaultResult.get();
        }
        return fn.apply(this.delegate);
    }

    public void onStart(Context parentContext, ReadWriteSpan span) {
        this.handleDelegate(d -> {
            d.onStart(parentContext, span);
            return null;
        }, () -> null);
    }

    public boolean isStartRequired() {
        return this.handleDelegate(SpanProcessor::isStartRequired, () -> false);
    }

    public void onEnd(ReadableSpan span) {
        this.handleDelegate(d -> {
            this.delegate.onEnd(span);
            return null;
        }, () -> null);
    }

    public boolean isEndRequired() {
        return this.handleDelegate(SpanProcessor::isEndRequired, () -> true);
    }

    public CompletableResultCode shutdown() {
        return this.handleDelegate(SpanProcessor::shutdown, CompletableResultCode::ofSuccess);
    }

    public CompletableResultCode forceFlush() {
        return this.handleDelegate(SpanProcessor::forceFlush, CompletableResultCode::ofSuccess);
    }

    public void close() {
        if (this.delegate != null) {
            this.delegate.close();
        }
        this.resetDelegate();
    }

    private void resetDelegate() {
        this.delegate = null;
        this.warningLogged = false;
    }
}

