/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.opentelemetry.exporter.gcp.runtime;

import com.google.cloud.opentelemetry.trace.TestTraceConfigurationBuilder;
import com.google.cloud.opentelemetry.trace.TraceConfiguration;
import com.google.cloud.opentelemetry.trace.TraceExporter;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.quarkiverse.opentelemetry.exporter.common.runtime.LateBoundSpanProcessor;
import io.quarkiverse.opentelemetry.exporter.gcp.runtime.GcpExporterConfig;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.CDI;
import java.io.IOException;
import java.lang.annotation.Annotation;

@Recorder
public class GcpRecorder {
    public void installSpanProcessorForGcp(GcpExporterConfig.GcpExporterRuntimeConfig runtimeConfig, LaunchMode launchMode) {
        if (launchMode != LaunchMode.TEST && runtimeConfig.endpoint.isEmpty()) {
            try {
                this.configureTraceExporter(runtimeConfig);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to initialize GCP TraceExporter.", e);
            }
        }
        TraceConfiguration.Builder builder = TestTraceConfigurationBuilder.buildTestTraceConfiguration();
        if (runtimeConfig.endpoint.isPresent() && runtimeConfig.endpoint.get().trim().length() > 0) {
            builder.setTraceServiceEndpoint(runtimeConfig.endpoint.get());
        }
        TraceConfiguration config = builder.build();
        try {
            if (runtimeConfig.cloudrun.booleanValue()) {
                this.configureSimpleSpanExporter(config);
            } else {
                this.configureBatchSpanExporter(config);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to initialize GCP TraceExporter.", e);
        }
    }

    private void configureTraceExporter(GcpExporterConfig.GcpExporterRuntimeConfig runtimeConfig) throws IOException {
        TraceConfiguration.Builder builder = TraceConfiguration.builder();
        if (runtimeConfig.projectid.isPresent() && runtimeConfig.projectid.get().trim().length() > 0) {
            builder.setProjectId(runtimeConfig.projectid.get());
        }
        TraceConfiguration traceConfig = builder.build();
        if (runtimeConfig.cloudrun.booleanValue()) {
            this.configureSimpleSpanExporter(traceConfig);
        } else {
            this.configureBatchSpanExporter(traceConfig);
        }
    }

    private void configureBatchSpanExporter(TraceConfiguration config) throws IOException {
        BatchSpanProcessor batchSpanProcessor = BatchSpanProcessor.builder((SpanExporter)TraceExporter.createWithConfiguration((TraceConfiguration)config)).build();
        LateBoundSpanProcessor delayedProcessor = (LateBoundSpanProcessor)CDI.current().select(LateBoundSpanProcessor.class, new Annotation[]{Any.Literal.INSTANCE}).get();
        delayedProcessor.setSpanProcessorDelegate((SpanProcessor)batchSpanProcessor);
    }

    private void configureSimpleSpanExporter(TraceConfiguration config) throws IOException {
        TraceExporter traceExporter = TraceExporter.createWithConfiguration((TraceConfiguration)config);
        SpanProcessor spanProcessor = SimpleSpanProcessor.create((SpanExporter)traceExporter);
        LateBoundSpanProcessor delayedProcessor = (LateBoundSpanProcessor)CDI.current().select(LateBoundSpanProcessor.class, new Annotation[]{Any.Literal.INSTANCE}).get();
        delayedProcessor.setSpanProcessorDelegate(spanProcessor);
    }
}

