/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBinding;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingBuilder;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingFluent;
import io.fabric8.kubernetes.api.model.rbac.RoleBinding;
import io.fabric8.kubernetes.api.model.rbac.RoleBindingBuilder;
import io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent;
import io.fabric8.kubernetes.api.model.rbac.RoleRef;
import io.fabric8.kubernetes.api.model.rbac.RoleRefBuilder;
import io.quarkiverse.operatorsdk.deployment.AddClusterRolesDecorator;
import io.quarkiverse.operatorsdk.runtime.BuildTimeOperatorConfiguration;
import io.quarkiverse.operatorsdk.runtime.QuarkusControllerConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public class AddRoleBindingsDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    private static final Logger log = Logger.getLogger(AddRoleBindingsDecorator.class);
    protected static final String RBAC_AUTHORIZATION_GROUP = "rbac.authorization.k8s.io";
    public static final String CLUSTER_ROLE = "ClusterRole";
    protected static final String SERVICE_ACCOUNT = "ServiceAccount";
    private final Collection<QuarkusControllerConfiguration<?>> configs;
    private final BuildTimeOperatorConfiguration operatorConfiguration;
    private static final ConcurrentMap<QuarkusControllerConfiguration, List<HasMetadata>> cachedBindings = new ConcurrentHashMap<QuarkusControllerConfiguration, List<HasMetadata>>();
    private static final Optional<String> deployNamespace = ConfigProvider.getConfig().getOptionalValue("quarkus.kubernetes.namespace", String.class);
    public static final RoleRef CRD_VALIDATING_ROLE_REF = new RoleRef("rbac.authorization.k8s.io", "ClusterRole", "josdk-crd-validating-cluster-role");

    public AddRoleBindingsDecorator(Collection<QuarkusControllerConfiguration<?>> configs, BuildTimeOperatorConfiguration operatorConfiguration) {
        this.configs = configs;
        this.operatorConfiguration = operatorConfiguration;
    }

    public void visit(KubernetesListBuilder list) {
        String serviceAccountName = this.getMandatoryDeploymentMetadata(list).getName();
        this.configs.forEach(config -> {
            List toAdd = cachedBindings.computeIfAbsent((QuarkusControllerConfiguration)config, c -> this.bindingsFor((QuarkusControllerConfiguration<?>)c, serviceAccountName));
            list.addAllToItems((Collection)toAdd);
        });
    }

    private List<HasMetadata> bindingsFor(QuarkusControllerConfiguration<?> controllerConfiguration, String serviceAccountName) {
        ArrayList<HasMetadata> itemsToAdd;
        String controllerName = controllerConfiguration.getName();
        Set desiredWatchedNamespaces = controllerConfiguration.getNamespaces();
        if (this.operatorConfiguration.crd.validate.booleanValue()) {
            String crBindingName = AddRoleBindingsDecorator.getCRDValidatingBindingName(controllerName);
            ClusterRoleBinding crdValidatorRoleBinding = AddRoleBindingsDecorator.createClusterRoleBinding(serviceAccountName, controllerName, crBindingName, "validate CRDs", CRD_VALIDATING_ROLE_REF);
            itemsToAdd = new ArrayList(desiredWatchedNamespaces.size() + 1);
            itemsToAdd.add((HasMetadata)crdValidatorRoleBinding);
        } else {
            itemsToAdd = new ArrayList<HasMetadata>(desiredWatchedNamespaces.size());
        }
        String roleBindingName = AddRoleBindingsDecorator.getRoleBindingName(controllerName);
        if (controllerConfiguration.watchCurrentNamespace()) {
            itemsToAdd.add((HasMetadata)AddRoleBindingsDecorator.createRoleBinding(roleBindingName, serviceAccountName, null, AddRoleBindingsDecorator.createDefaultRoleRef(AddClusterRolesDecorator.getClusterRoleName(controllerName))));
            controllerConfiguration.getAdditionalRBACRoleRefs().forEach(roleRef -> {
                String specificRoleBindingName = AddRoleBindingsDecorator.getSpecificRoleBindingName(controllerName, roleRef);
                itemsToAdd.add((HasMetadata)AddRoleBindingsDecorator.createRoleBinding(specificRoleBindingName, serviceAccountName, null, roleRef));
            });
        } else if (controllerConfiguration.watchAllNamespaces()) {
            itemsToAdd.add((HasMetadata)AddRoleBindingsDecorator.createClusterRoleBinding(serviceAccountName, controllerName, AddRoleBindingsDecorator.getClusterRoleBindingName(controllerName), "watch all namespaces", null));
            controllerConfiguration.getAdditionalRBACRoleRefs().forEach(roleRef -> {
                if (!CLUSTER_ROLE.equals(roleRef.getKind())) {
                    log.warnv("Cannot create a ClusterRoleBinding for RoleRef ''{0}'' because it's not a ClusterRole", roleRef);
                } else {
                    itemsToAdd.add((HasMetadata)AddRoleBindingsDecorator.createClusterRoleBinding(serviceAccountName, controllerName, roleRef.getName() + "-" + AddRoleBindingsDecorator.getClusterRoleBindingName(controllerName), "watch all namespaces", roleRef));
                }
            });
        } else {
            desiredWatchedNamespaces.forEach(ns -> {
                itemsToAdd.add((HasMetadata)AddRoleBindingsDecorator.createRoleBinding(roleBindingName, serviceAccountName, ns, AddRoleBindingsDecorator.createDefaultRoleRef(AddClusterRolesDecorator.getClusterRoleName(controllerName))));
                controllerConfiguration.getAdditionalRBACRoleRefs().forEach(roleRef -> {
                    String specificRoleBindingName = AddRoleBindingsDecorator.getSpecificRoleBindingName(controllerName, roleRef);
                    itemsToAdd.add((HasMetadata)AddRoleBindingsDecorator.createRoleBinding(specificRoleBindingName, serviceAccountName, ns, roleRef));
                });
            });
        }
        return itemsToAdd;
    }

    public static String getCRDValidatingBindingName(String controllerName) {
        return controllerName + "-crd-validating-role-binding";
    }

    private static String getClusterRoleBindingName(String controllerName) {
        return controllerName + "-cluster-role-binding";
    }

    public static String getRoleBindingName(String controllerName) {
        return controllerName + "-role-binding";
    }

    public static String getSpecificRoleBindingName(String controllerName, String roleRefName) {
        return roleRefName + "-" + AddRoleBindingsDecorator.getRoleBindingName(controllerName);
    }

    public static String getSpecificRoleBindingName(String controllerName, RoleRef roleRef) {
        return AddRoleBindingsDecorator.getSpecificRoleBindingName(controllerName, roleRef.getName());
    }

    private static RoleRef createDefaultRoleRef(String controllerName) {
        return ((RoleRefBuilder)((RoleRefBuilder)((RoleRefBuilder)new RoleRefBuilder().withApiGroup(RBAC_AUTHORIZATION_GROUP)).withKind(CLUSTER_ROLE)).withName(controllerName)).build();
    }

    private static RoleBinding createRoleBinding(String roleBindingName, String serviceAccountName, String targetNamespace, RoleRef roleRef) {
        String nsMsg = (String)(targetNamespace == null ? "current" : "'" + targetNamespace + "'") + " namespace";
        log.infov("Creating ''{0}'' RoleBinding to be applied to {1}", (Object)roleBindingName, (Object)nsMsg);
        return ((RoleBindingBuilder)((RoleBindingBuilder)((RoleBindingBuilder)((RoleBindingFluent.MetadataNested)((RoleBindingFluent.MetadataNested)new RoleBindingBuilder().withNewMetadata().withName(roleBindingName)).withNamespace(targetNamespace)).endMetadata()).withRoleRef(roleRef)).addNewSubject(null, SERVICE_ACCOUNT, serviceAccountName, (String)deployNamespace.orElse(null))).build();
    }

    private static ClusterRoleBinding createClusterRoleBinding(String serviceAccountName, String controllerName, String bindingName, String controllerConfMessage, RoleRef roleRef) {
        AddRoleBindingsDecorator.outputWarningIfNeeded(controllerName, bindingName, controllerConfMessage);
        roleRef = roleRef == null ? AddRoleBindingsDecorator.createDefaultRoleRef(serviceAccountName) : roleRef;
        String ns = deployNamespace.orElse(null);
        log.infov("Creating ''{0}'' ClusterRoleBinding to be applied to ''{1}'' namespace", (Object)bindingName, (Object)ns);
        return ((ClusterRoleBindingBuilder)((ClusterRoleBindingFluent.SubjectsNested)((ClusterRoleBindingFluent.SubjectsNested)((ClusterRoleBindingFluent.SubjectsNested)((ClusterRoleBindingBuilder)((ClusterRoleBindingBuilder)((ClusterRoleBindingFluent.MetadataNested)new ClusterRoleBindingBuilder().withNewMetadata().withName(bindingName)).endMetadata()).withRoleRef(roleRef)).addNewSubject().withKind(SERVICE_ACCOUNT)).withName(serviceAccountName)).withNamespace(ns)).endSubject()).build();
    }

    private static void outputWarningIfNeeded(String controllerName, String crBindingName, String controllerConfMessage) {
        if (deployNamespace.isEmpty()) {
            log.warnv("''{0}'' controller is configured to " + controllerConfMessage + ", this requires a ClusterRoleBinding for which we MUST specify the namespace of the operator ServiceAccount. This can be specified by setting the ''quarkus.kubernetes.namespace'' property. However, as this property is not set, we are leaving the namespace blank to be provided by the user by editing the ''{1}'' ClusterRoleBinding to provide the namespace in which the operator will be deployed.", (Object)controllerName, (Object)crBindingName);
        }
    }
}

