/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.LeaderElectionConfiguration;
import io.javaoperatorsdk.operator.api.monitoring.Metrics;
import io.quarkiverse.operatorsdk.common.AnnotationConfigurableAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.ClassUtils;
import io.quarkiverse.operatorsdk.common.Constants;
import io.quarkiverse.operatorsdk.common.ReconcilerAugmentedClassInfo;
import io.quarkiverse.operatorsdk.common.ResourceAssociatedAugmentedClassInfo;
import io.quarkiverse.operatorsdk.deployment.AnnotationConfigurablesBuildItem;
import io.quarkiverse.operatorsdk.deployment.ControllerConfigurationsBuildItem;
import io.quarkiverse.operatorsdk.deployment.GeneratedCRDInfoBuildItem;
import io.quarkiverse.operatorsdk.deployment.QOSDKReflectiveClassBuildItem;
import io.quarkiverse.operatorsdk.deployment.ReconcilerInfosBuildItem;
import io.quarkiverse.operatorsdk.deployment.VersionBuildItem;
import io.quarkiverse.operatorsdk.deployment.devui.commands.ConsoleCommands;
import io.quarkiverse.operatorsdk.runtime.AppEventListener;
import io.quarkiverse.operatorsdk.runtime.BuildTimeOperatorConfiguration;
import io.quarkiverse.operatorsdk.runtime.ConfigurationServiceRecorder;
import io.quarkiverse.operatorsdk.runtime.KubernetesClientObjectMapperCustomizer;
import io.quarkiverse.operatorsdk.runtime.KubernetesClientSerializationCustomizer;
import io.quarkiverse.operatorsdk.runtime.NoOpMetricsProvider;
import io.quarkiverse.operatorsdk.runtime.OperatorHealthCheck;
import io.quarkiverse.operatorsdk.runtime.OperatorProducer;
import io.quarkiverse.operatorsdk.runtime.QuarkusConfigurationService;
import io.quarkiverse.operatorsdk.runtime.QuarkusControllerConfiguration;
import io.quarkiverse.operatorsdk.runtime.RunTimeOperatorConfiguration;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ConsoleCommandBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ForceNonWeakReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.QuarkusApplication;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.aesh.command.Command;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

class OperatorSDKProcessor {
    private static final Logger log = Logger.getLogger((String)OperatorSDKProcessor.class.getName());
    private static final String FEATURE = "operator-sdk";
    private static final String DEFAULT_METRIC_BINDER_CLASS_NAME = "io.quarkiverse.operatorsdk.runtime.MicrometerMetricsProvider";
    private BuildTimeOperatorConfiguration buildTimeConfiguration;

    OperatorSDKProcessor() {
    }

    @BuildStep
    void setup(BuildProducer<IndexDependencyBuildItem> indexDependency, BuildProducer<FeatureBuildItem> features, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, Optional<MetricsCapabilityBuildItem> metricsCapability, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<AdditionalIndexedClassesBuildItem> additionalIndexedClasses) {
        features.produce((BuildItem)new FeatureBuildItem(FEATURE));
        indexDependency.produce((BuildItem)new IndexDependencyBuildItem("io.javaoperatorsdk", "operator-framework-core"));
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{Metrics.class}));
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{LeaderElectionConfiguration.class}));
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(KubernetesClientObjectMapperCustomizer.class));
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(KubernetesClientSerializationCustomizer.class));
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(OperatorProducer.class));
        if (metricsCapability.map(m -> m.metricsSupported("micrometer")).orElse(false).booleanValue()) {
            additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf((String)DEFAULT_METRIC_BINDER_CLASS_NAME));
        } else {
            additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(NoOpMetricsProvider.class));
        }
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(OperatorHealthCheck.class));
        additionalIndexedClasses.produce((BuildItem)new AdditionalIndexedClassesBuildItem(QuarkusControllerConfiguration.DefaultRateLimiter.class.getName()));
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void addConsoleCommands(VersionBuildItem versionBuildItem, BuildProducer<ConsoleCommandBuildItem> commands) {
        commands.produce((BuildItem)new ConsoleCommandBuildItem((Command)new ConsoleCommands(versionBuildItem.getVersion())));
    }

    @BuildStep
    void addOperatorBoostrapIfNoApplicationClassExists(BuildProducer<AdditionalBeanBuildItem> additionalBeans, CombinedIndexBuildItem combinedIndex) {
        if (combinedIndex.getIndex().getAllKnownImplementors(DotName.createSimple((String)QuarkusApplication.class.getName())).isEmpty()) {
            additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(AppEventListener.class).setDefaultScope(DotName.createSimple((String)Singleton.class.getName())).setUnremovable().build());
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void updateControllerConfigurations(ConfigurationServiceRecorder recorder, RunTimeOperatorConfiguration runTimeConfiguration, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer, GeneratedCRDInfoBuildItem generatedCRDs, ControllerConfigurationsBuildItem serviceBuildItem, VersionBuildItem versionBuildItem) {
        Supplier supplier = recorder.configurationServiceSupplier(versionBuildItem.getVersion(), serviceBuildItem.getControllerConfigs(), generatedCRDs.getCRDGenerationInfo(), runTimeConfiguration, this.buildTimeConfiguration);
        syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(QuarkusConfigurationService.class).scope(Singleton.class)).addType(ConfigurationService.class)).defaultBean()).setRuntimeInit().supplier(supplier).done());
    }

    @BuildStep
    ReconcilerInfosBuildItem buildReconcilerInfos(CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        Map<String, ReconcilerAugmentedClassInfo> reconcilers = ClassUtils.getKnownReconcilers((IndexView)combinedIndexBuildItem.getIndex(), (Logger)log).peek(reconcilerInfo -> additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(reconcilerInfo.classInfo().toString()).setUnremovable().setDefaultScope(DotNames.APPLICATION_SCOPED).build())).collect(Collectors.toMap(ResourceAssociatedAugmentedClassInfo::nameOrFailIfUnset, Function.identity()));
        return new ReconcilerInfosBuildItem(reconcilers);
    }

    @BuildStep
    AnnotationConfigurablesBuildItem gatherAnnotationConfigurables(CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<QOSDKReflectiveClassBuildItem> reflectiveClassProducer) {
        IndexView index = combinedIndexBuildItem.getIndex();
        Map<String, AnnotationConfigurableAugmentedClassInfo> configurableInfos = ClassUtils.getProcessableImplementationsOf((DotName)Constants.ANNOTATION_CONFIGURABLE, (IndexView)index, (Logger)log, Collections.emptyMap()).map(AnnotationConfigurableAugmentedClassInfo.class::cast).peek(ci -> reflectiveClassProducer.produce((BuildItem)new QOSDKReflectiveClassBuildItem(ci.getClassNamesToRegisterForReflection()))).collect(Collectors.toMap(ac -> ac.classInfo().name().toString(), Function.identity()));
        index.getAnnotations(Constants.CONFIGURED).stream().map(ai -> ai.value("with").asClass().name().toString()).forEach(className -> reflectiveClassProducer.produce((BuildItem)new QOSDKReflectiveClassBuildItem((String)className)));
        return new AnnotationConfigurablesBuildItem(configurableInfos);
    }

    @BuildStep
    void gatherOutOfAppCustomResourceImplementations(CombinedIndexBuildItem combinedIndexBuildItem, ApplicationIndexBuildItem applicationIndexBuildItem, BuildProducer<QOSDKReflectiveClassBuildItem> reflectiveClassProducer) {
        IndexView combinedIndex = combinedIndexBuildItem.getIndex();
        Index appIndex = applicationIndexBuildItem.getIndex();
        Collection crsFromCombined = combinedIndex.getAllKnownSubclasses(Constants.CUSTOM_RESOURCE);
        crsFromCombined.removeAll(appIndex.getAllKnownSubclasses(Constants.CUSTOM_RESOURCE));
        crsFromCombined.forEach(ci -> reflectiveClassProducer.produce((BuildItem)new QOSDKReflectiveClassBuildItem(ci.name().toString())));
    }

    @BuildStep
    void registerClassesForReflection(List<QOSDKReflectiveClassBuildItem> toRegister, BuildProducer<ReflectiveHierarchyBuildItem> reflectionClasses, BuildProducer<ForceNonWeakReflectiveClassBuildItem> forcedReflectionClasses) {
        Set<String> toRegisterSet = toRegister.stream().flatMap(QOSDKReflectiveClassBuildItem::classNamesToRegisterForReflectionStream).collect(Collectors.toSet());
        this.registerAssociatedClassesForReflection(reflectionClasses, forcedReflectionClasses, toRegisterSet);
    }

    @BuildStep
    void registerDependentBeans(ReconcilerInfosBuildItem reconcilers, ControllerConfigurationsBuildItem configurations, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        configurations.getControllerConfigs().values().stream().filter(QuarkusControllerConfiguration::needsDependentBeansCreation).forEach(config -> {
            ReconcilerAugmentedClassInfo raci = reconcilers.getReconcilers().get(config.getName());
            ClassInfo info = raci.classInfo();
            String reconcilerClassName = info.toString();
            log.debugv("Created dependent beans for ''{0}'' reconciler", (Object)reconcilerClassName);
            raci.getDependentResourceInfos().forEach(dependent -> additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(dependent.classInfo().name().toString()).setUnremovable().setDefaultScope(DotNames.APPLICATION_SCOPED).build()));
        });
    }

    @BuildStep
    void initializeRuntimeNamespacesFromBuildTimeValues(ControllerConfigurationsBuildItem configurations, BuildProducer<RunTimeConfigurationDefaultBuildItem> runtimeConfig) {
        configurations.getControllerConfigs().forEach((name, configuration) -> {
            String namespaces = String.join((CharSequence)",", configuration.getNamespaces());
            runtimeConfig.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem("quarkus.operator-sdk.controllers." + configuration.getName() + ".namespaces", namespaces));
        });
    }

    private void registerAssociatedClassesForReflection(BuildProducer<ReflectiveHierarchyBuildItem> reflectionClasses, BuildProducer<ForceNonWeakReflectiveClassBuildItem> forcedReflectionClasses, Set<String> classNamesToRegister) {
        classNamesToRegister.forEach(cn -> {
            reflectionClasses.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(Type.create((DotName)DotName.createSimple((String)cn), (Type.Kind)Type.Kind.CLASS)).build());
            forcedReflectionClasses.produce((BuildItem)new ForceNonWeakReflectiveClassBuildItem(cn));
            log.infov("Registered ''{0}'' for reflection", cn);
        });
    }

    private ResultHandle getHandleFromCDI(MethodCreator mc, MethodDescriptor selectMethod, MethodDescriptor getMethod, AssignableResultHandle cdiVar, Class<?> handleClass, String optionalImplClass) {
        ResultHandle operatorInstance = mc.invokeVirtualMethod(selectMethod, (ResultHandle)cdiVar, new ResultHandle[]{optionalImplClass != null ? mc.loadClass(optionalImplClass) : mc.loadClass(handleClass), mc.newArray(Annotation.class, 0)});
        return mc.checkCast(mc.invokeInterfaceMethod(getMethod, operatorInstance, new ResultHandle[0]), handleClass);
    }
}

