/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import io.quarkiverse.operatorsdk.deployment.AddClusterRolesDecorator;
import io.quarkiverse.operatorsdk.deployment.AddRoleBindingsDecorator;
import io.quarkiverse.operatorsdk.deployment.ControllerConfigurationsBuildItem;
import io.quarkiverse.operatorsdk.runtime.BuildTimeOperatorConfiguration;
import io.quarkiverse.operatorsdk.runtime.QuarkusControllerConfiguration;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.kubernetes.spi.DecoratorBuildItem;
import java.util.Collection;
import java.util.function.BooleanSupplier;

public class RBACAugmentationStep {
    @BuildStep(onlyIf={IsRBACEnabled.class})
    void augmentRBACForResources(BuildTimeOperatorConfiguration buildTimeConfiguration, BuildProducer<DecoratorBuildItem> decorators, ControllerConfigurationsBuildItem configurations) {
        Collection<QuarkusControllerConfiguration<?>> configs = configurations.getControllerConfigs().values();
        decorators.produce((BuildItem)new DecoratorBuildItem((Object)new AddClusterRolesDecorator(configs, buildTimeConfiguration.crd.validate)));
        decorators.produce((BuildItem)new DecoratorBuildItem((Object)new AddRoleBindingsDecorator(configs, buildTimeConfiguration)));
    }

    private static class IsRBACEnabled
    implements BooleanSupplier {
        private BuildTimeOperatorConfiguration config;

        private IsRBACEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return this.config.disableRbacGeneration == false;
        }
    }
}

