/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment.devui.commands;

import io.quarkiverse.operatorsdk.common.Files;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.option.Option;

@CommandDefinition(name="api", description="Creates a Kubernetes API represented by a CustomResource and associated reconciler")
public class APICommand
implements Command {
    @Option(name="kind", shortName=107, description="Your API's kind, used to generate a CustomResource class with associated spec, status and Reconciler classes", required=true)
    private String kind;
    @Option(name="group", shortName=103, description="Your API's group, e.g. halkyon.io, this will also be used, reversed, as package name for the generated classes", required=true)
    private String group;
    @Option(name="version", shortName=118, description="Your API's version, e.g. v1beta1", required=true)
    private String version;
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    public boolean help;

    public CommandResult execute(final CommandInvocation commandInvocation) throws CommandException, InterruptedException {
        if (this.help) {
            commandInvocation.getShell().write(commandInvocation.getHelpInfo());
            return CommandResult.SUCCESS;
        }
        return Files.generateAPIFiles((String)this.group, (String)this.version, (String)this.kind, (Files.MessageWriter)new Files.MessageWriter(){

            public void write(String message, Exception e, boolean forError) {
                commandInvocation.println(this.formatMessageWithException(message, e));
            }
        }) ? CommandResult.SUCCESS : CommandResult.FAILURE;
    }
}

