/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime.devconsole;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.api.config.dependent.DependentResourceSpec;
import io.javaoperatorsdk.operator.api.reconciler.dependent.DependentResource;
import io.javaoperatorsdk.operator.processing.dependent.workflow.Condition;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import java.lang.annotation.Annotation;
import java.util.Set;

public class DependentInfo<R, P extends HasMetadata>
implements Comparable<DependentInfo> {
    private final DependentResourceSpec<R, P> spec;

    public DependentInfo(DependentResourceSpec<R, P> spec) {
        this.spec = spec;
    }

    public String getResourceClass() {
        try (InstanceHandle dependent = Arc.container().instance(this.spec.getDependentResourceClass(), new Annotation[0]);){
            String string = ((DependentResource)dependent.get()).resourceType().getName();
            return string;
        }
    }

    public String getName() {
        return this.spec.getName();
    }

    public Set<String> getDependsOn() {
        return this.spec.getDependsOn();
    }

    public boolean getHasConditions() {
        return this.getReadyCondition() != null || this.getReconcileCondition() != null || this.getDeletePostCondition() != null;
    }

    public String getReadyCondition() {
        return this.getConditionClassName(this.spec.getReadyCondition());
    }

    public String getReconcileCondition() {
        return this.getConditionClassName(this.spec.getReconcileCondition());
    }

    public String getDeletePostCondition() {
        return this.getConditionClassName(this.spec.getDeletePostCondition());
    }

    private String getConditionClassName(Condition condition) {
        return condition != null ? condition.getClass().getName() : null;
    }

    public String getUseEventSourceWithName() {
        return this.spec.getUseEventSourceWithName().orElse(null);
    }

    public String getType() {
        return this.spec.getDependentResourceClass().getName();
    }

    @Override
    public int compareTo(DependentInfo other) {
        return this.getName().compareTo(other.getName());
    }
}

