/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.tika.runtime;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.tika.TikaParseException;
import io.quarkus.tika.TikaParser;
import io.quarkus.tika.runtime.TikaConfiguration;
import io.quarkus.tika.runtime.TikaParserProducer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.RecursiveParserWrapper;

@Recorder
public class TikaRecorder {
    public void initTikaParser(BeanContainer container, TikaConfiguration config, String tikaXmlConfiguration) {
        TikaParser parser = this.initializeParser(config, tikaXmlConfiguration);
        TikaParserProducer producer = (TikaParserProducer)container.beanInstance(TikaParserProducer.class, new Annotation[0]);
        producer.initialize(parser);
    }

    private TikaParser initializeParser(TikaConfiguration config, String tikaXmlConfiguration) {
        TikaConfig tikaConfig;
        try (InputStream stream = TikaRecorder.getTikaConfigStream(config, tikaXmlConfiguration);){
            tikaConfig = new TikaConfig(stream);
        }
        catch (Exception ex) {
            String errorMessage = "Invalid tika-config.xml";
            throw new TikaParseException("Invalid tika-config.xml", ex);
        }
        AutoDetectParser nativeParser = new AutoDetectParser(tikaConfig);
        if (!config.appendEmbeddedContent) {
            nativeParser = new RecursiveParserWrapper((Parser)nativeParser, true);
        }
        return new TikaParser((Parser)nativeParser, config.appendEmbeddedContent);
    }

    private static InputStream getTikaConfigStream(TikaConfiguration config, String tikaXmlConfiguration) {
        InputStream is;
        if (config.tikaConfigPath.isPresent()) {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(config.tikaConfigPath.get());
            if (is == null) {
                String errorMessage = "tika-config.xml can not be found at " + config.tikaConfigPath.get();
                throw new TikaParseException(errorMessage);
            }
        } else {
            is = new ByteArrayInputStream(tikaXmlConfiguration.getBytes(StandardCharsets.UTF_8));
        }
        return is;
    }
}

