/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.InjectableDecorator;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.BeanGenerator;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanProcessor;
import io.quarkus.arc.processor.DecoratorInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.arc.processor.Methods;
import io.quarkus.arc.processor.ReflectionRegistration;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.arc.processor.Types;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;

public class DecoratorGenerator
extends BeanGenerator {
    protected static final String FIELD_NAME_DECORATED_TYPES = "decoratedTypes";
    protected static final String FIELD_NAME_DELEGATE_TYPE = "delegateType";
    static final String ABSTRACT_IMPL_SUFFIX = "_Impl";

    public DecoratorGenerator(AnnotationLiteralProcessor annotationLiterals, Predicate<DotName> applicationClassPredicate, BeanProcessor.PrivateMembersCollector privateMembers, boolean generateSources, ReflectionRegistration reflectionRegistration, Set<String> existingClasses, Map<BeanInfo, String> beanToGeneratedName, Predicate<DotName> injectionPointAnnotationsPredicate) {
        super(annotationLiterals, applicationClassPredicate, privateMembers, generateSources, reflectionRegistration, existingClasses, beanToGeneratedName, injectionPointAnnotationsPredicate, Collections.emptyList());
    }

    void precomputeGeneratedName(DecoratorInfo decorator) {
        BeanGenerator.ProviderType providerType = new BeanGenerator.ProviderType(decorator.getProviderType());
        ClassInfo decoratorClass = decorator.getTarget().get().asClass();
        String baseName = DecoratorGenerator.createBaseName(decoratorClass);
        String targetPackage = DotNames.packageName(providerType.name());
        String generatedName = DecoratorGenerator.generatedNameFromTarget(targetPackage, baseName, "_Bean");
        this.beanToGeneratedName.put(decorator, generatedName);
        this.beanToGeneratedBaseName.put(decorator, baseName);
    }

    Collection<ResourceOutput.Resource> generate(DecoratorInfo decorator) {
        String baseName = (String)this.beanToGeneratedBaseName.get(decorator);
        String generatedName = (String)this.beanToGeneratedName.get(decorator);
        BeanGenerator.ProviderType providerType = new BeanGenerator.ProviderType(decorator.getProviderType());
        String targetPackage = DotNames.packageName(providerType.name());
        ClassInfo decoratorClass = decorator.getTarget().get().asClass();
        if (this.existingClasses.contains(generatedName)) {
            return Collections.emptyList();
        }
        boolean isApplicationClass = this.applicationClassPredicate.test(decorator.getBeanClass());
        ResourceClassOutput classOutput = new ResourceClassOutput(isApplicationClass, name -> name.equals(generatedName) ? ResourceOutput.Resource.SpecialType.DECORATOR_BEAN : null, this.generateSources);
        ClassCreator decoratorCreator = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(generatedName).interfaces(new Class[]{InjectableDecorator.class, Supplier.class}).build();
        if (decorator.isAbstract()) {
            String generatedImplName = this.generateDecoratorImplementation(baseName, targetPackage, decorator, decoratorClass, classOutput);
            providerType = new BeanGenerator.ProviderType(org.jboss.jandex.Type.create((DotName)DotName.createSimple((String)generatedImplName), (Type.Kind)Type.Kind.CLASS));
        }
        FieldCreator beanTypes = (FieldCreator)decoratorCreator.getFieldCreator("types", Set.class).setModifiers(18);
        FieldCreator decoratedTypes = (FieldCreator)decoratorCreator.getFieldCreator(FIELD_NAME_DECORATED_TYPES, Set.class).setModifiers(18);
        InjectionPointInfo delegateInjectionPoint = decorator.getDelegateInjectionPoint();
        FieldCreator delegateType = (FieldCreator)decoratorCreator.getFieldCreator(FIELD_NAME_DELEGATE_TYPE, Type.class).setModifiers(18);
        FieldCreator delegateQualifiers = null;
        if (!delegateInjectionPoint.hasDefaultedQualifier()) {
            delegateQualifiers = (FieldCreator)decoratorCreator.getFieldCreator("qualifiers", Set.class).setModifiers(18);
        }
        HashMap<InjectionPointInfo, String> injectionPointToProviderField = new HashMap<InjectionPointInfo, String>();
        this.initMaps(decorator, injectionPointToProviderField, Collections.emptyMap(), Collections.emptyMap());
        this.createProviderFields(decoratorCreator, decorator, injectionPointToProviderField, Collections.emptyMap(), Collections.emptyMap());
        this.createConstructor((ClassOutput)classOutput, decoratorCreator, decorator, injectionPointToProviderField, delegateType, delegateQualifiers, decoratedTypes, this.reflectionRegistration);
        this.implementGetIdentifier(decorator, decoratorCreator);
        this.implementSupplierGet(decoratorCreator);
        this.implementCreate(classOutput, decoratorCreator, decorator, providerType, baseName, injectionPointToProviderField, Collections.emptyMap(), Collections.emptyMap(), targetPackage, isApplicationClass);
        this.implementGet(decorator, decoratorCreator, providerType, baseName);
        this.implementGetTypes(decoratorCreator, beanTypes.getFieldDescriptor());
        this.implementGetBeanClass(decorator, decoratorCreator);
        this.implementGetDecoratedTypes(decoratorCreator, decoratedTypes.getFieldDescriptor());
        this.implementGetDelegateType(decoratorCreator, delegateType.getFieldDescriptor());
        this.implementGetDelegateQualifiers(decoratorCreator, delegateQualifiers);
        this.implementGetPriority(decoratorCreator, decorator);
        decoratorCreator.close();
        return classOutput.getResources();
    }

    static String createBaseName(ClassInfo decoratorClass) {
        Object baseName = decoratorClass.enclosingClass() != null ? DotNames.simpleName(decoratorClass.enclosingClass()) + "_" + DotNames.simpleName(decoratorClass) : DotNames.simpleName(decoratorClass);
        return baseName;
    }

    private String generateDecoratorImplementation(String baseName, String targetPackage, DecoratorInfo decorator, ClassInfo decoratorClass, ClassOutput classOutput) {
        MethodCreator delegate;
        String generatedImplName = DecoratorGenerator.generatedNameFromTarget(targetPackage, baseName, ABSTRACT_IMPL_SUFFIX);
        ClassCreator decoratorImplCreator = ClassCreator.builder().classOutput(classOutput).className(generatedImplName).superClass(decoratorClass.name().toString()).build();
        IndexView index = decorator.getDeployment().getBeanArchiveIndex();
        FieldCreator delegateField = decoratorImplCreator.getFieldCreator("impl$delegate", Object.class.getName());
        MethodInfo decoratorConstructor = decoratorClass.firstMethod("<init>");
        MethodCreator constructor = decoratorImplCreator.getMethodCreator("<init>", (Object)"V", decoratorConstructor.parameterTypes().toArray());
        constructor.invokeSpecialMethod(decoratorConstructor, constructor.getThis(), new ResultHandle[0]);
        constructor.writeInstanceField(delegateField.getFieldDescriptor(), constructor.getThis(), constructor.invokeStaticMethod(MethodDescriptors.DECORATOR_DELEGATE_PROVIDER_GET, new ResultHandle[0]));
        constructor.returnValue(null);
        HashSet<MethodDescriptor> abstractMethods = new HashSet<MethodDescriptor>();
        HashMap<MethodDescriptor, MethodDescriptor> bridgeMethods = new HashMap<MethodDescriptor, MethodDescriptor>();
        for (org.jboss.jandex.Type type : decorator.getDecoratedTypes()) {
            ClassInfo decoratedTypeClass = index.getClassByName(type.name());
            if (decoratedTypeClass == null) {
                throw new IllegalStateException("TODO");
            }
            List typeParameters = decoratedTypeClass.typeParameters();
            Map<String, org.jboss.jandex.Type> resolvedTypeParameters = Collections.emptyMap();
            if (!typeParameters.isEmpty()) {
                resolvedTypeParameters = new HashMap();
                org.jboss.jandex.Type type2 = decorator.getDelegateType();
                if (type2.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                    List typeArguments = type2.asParameterizedType().arguments();
                    for (int i = 0; i < typeParameters.size(); ++i) {
                        resolvedTypeParameters.put(((TypeVariable)typeParameters.get(i)).identifier(), (org.jboss.jandex.Type)typeArguments.get(i));
                    }
                }
            }
            for (MethodInfo method : decoratedTypeClass.methods()) {
                MethodDescriptor resolvedMethodDescriptor;
                if (Methods.skipForDelegateSubclass(method)) continue;
                MethodDescriptor methodDescriptor = MethodDescriptor.of((MethodInfo)method);
                if (!typeParameters.isEmpty() && (Methods.containsTypeVariableParameter(method) || Types.containsTypeVariable(method.returnType()))) {
                    List<org.jboss.jandex.Type> paramTypes = Types.getResolvedParameters(decoratedTypeClass, resolvedTypeParameters, method, index);
                    org.jboss.jandex.Type returnType = Types.resolveTypeParam(method.returnType(), resolvedTypeParameters, index);
                    String[] paramTypesArray = new String[paramTypes.size()];
                    for (int i = 0; i < paramTypesArray.length; ++i) {
                        paramTypesArray[i] = DescriptorUtils.typeToString((org.jboss.jandex.Type)paramTypes.get(i));
                    }
                    resolvedMethodDescriptor = MethodDescriptor.ofMethod((String)method.declaringClass().toString(), (String)method.name(), (String)DescriptorUtils.typeToString((org.jboss.jandex.Type)returnType), (String[])paramTypesArray);
                } else {
                    resolvedMethodDescriptor = null;
                }
                MethodDescriptor abstractDescriptor = methodDescriptor;
                for (MethodInfo decoratorMethod : decoratorClass.methods()) {
                    MethodDescriptor descriptor = MethodDescriptor.of((MethodInfo)decoratorMethod);
                    if (!Methods.descriptorMatches(descriptor, methodDescriptor)) continue;
                    abstractDescriptor = null;
                    break;
                }
                if (abstractDescriptor == null) continue;
                abstractMethods.add(methodDescriptor);
                if (resolvedMethodDescriptor == null) continue;
                bridgeMethods.put(resolvedMethodDescriptor, abstractDescriptor);
            }
        }
        for (MethodDescriptor methodDescriptor : abstractMethods) {
            delegate = (MethodCreator)decoratorImplCreator.getMethodCreator(methodDescriptor).setModifiers(1);
            ResultHandle delegateHandle = delegate.readInstanceField(delegateField.getFieldDescriptor(), delegate.getThis());
            ResultHandle[] args = new ResultHandle[methodDescriptor.getParameterTypes().length];
            for (int i = 0; i < args.length; ++i) {
                args[i] = delegate.getMethodParam(i);
            }
            delegate.returnValue(delegate.invokeInterfaceMethod(methodDescriptor, delegateHandle, args));
        }
        for (Map.Entry entry : bridgeMethods.entrySet()) {
            delegate = (MethodCreator)decoratorImplCreator.getMethodCreator((MethodDescriptor)entry.getKey()).setModifiers(1);
            ResultHandle[] args = new ResultHandle[((MethodDescriptor)entry.getKey()).getParameterTypes().length];
            for (int i = 0; i < args.length; ++i) {
                args[i] = delegate.getMethodParam(i);
            }
            delegate.returnValue(delegate.invokeVirtualMethod(MethodDescriptor.ofMethod((String)decoratorImplCreator.getClassName(), (String)((MethodDescriptor)entry.getValue()).getName(), (String)((MethodDescriptor)entry.getValue()).getReturnType(), (String[])((MethodDescriptor)entry.getValue()).getParameterTypes()), delegate.getThis(), args));
        }
        decoratorImplCreator.close();
        return generatedImplName;
    }

    protected void createConstructor(ClassOutput classOutput, ClassCreator creator, DecoratorInfo decorator, Map<InjectionPointInfo, String> injectionPointToProviderField, FieldCreator delegateType, FieldCreator delegateQualifiers, FieldCreator decoratedTypes, ReflectionRegistration reflectionRegistration) {
        ResultHandle delegateTypeHandle;
        MethodCreator constructor = this.initConstructor(classOutput, creator, decorator, injectionPointToProviderField, Collections.emptyMap(), Collections.emptyMap(), this.annotationLiterals, reflectionRegistration);
        if (delegateQualifiers != null) {
            ResultHandle delegateQualifiersHandle = constructor.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
            for (AnnotationInstance delegateQualifier : decorator.getDelegateQualifiers()) {
                ClassInfo delegateQualifierClass = decorator.getDeployment().getQualifier(delegateQualifier.name());
                constructor.invokeInterfaceMethod(MethodDescriptors.SET_ADD, delegateQualifiersHandle, new ResultHandle[]{this.annotationLiterals.create((BytecodeCreator)constructor, delegateQualifierClass, delegateQualifier)});
            }
            constructor.writeInstanceField(delegateQualifiers.getFieldDescriptor(), constructor.getThis(), delegateQualifiersHandle);
        }
        ResultHandle decoratedTypesHandle = constructor.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle currentThread = constructor.invokeStaticMethod(MethodDescriptors.THREAD_CURRENT_THREAD, new ResultHandle[0]);
        ResultHandle tccl = constructor.invokeVirtualMethod(MethodDescriptors.THREAD_GET_TCCL, currentThread, new ResultHandle[0]);
        for (org.jboss.jandex.Type decoratedType : decorator.getDecoratedTypes()) {
            ResultHandle typeHandle;
            try {
                typeHandle = Types.getTypeHandle((BytecodeCreator)constructor, decoratedType, tccl);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Unable to construct the type handle for " + decorator + ": " + e.getMessage());
            }
            constructor.invokeInterfaceMethod(MethodDescriptors.SET_ADD, decoratedTypesHandle, new ResultHandle[]{typeHandle});
        }
        constructor.writeInstanceField(decoratedTypes.getFieldDescriptor(), constructor.getThis(), decoratedTypesHandle);
        try {
            delegateTypeHandle = Types.getTypeHandle((BytecodeCreator)constructor, decorator.getDelegateType(), tccl);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Unable to construct the type handle for " + decorator + ": " + e.getMessage());
        }
        constructor.writeInstanceField(delegateType.getFieldDescriptor(), constructor.getThis(), delegateTypeHandle);
        constructor.returnValue(null);
    }

    protected void implementGetDecoratedTypes(ClassCreator creator, FieldDescriptor decoratedTypes) {
        MethodCreator getDecoratedTypes = (MethodCreator)creator.getMethodCreator("getDecoratedTypes", Set.class, new Class[0]).setModifiers(1);
        getDecoratedTypes.returnValue(getDecoratedTypes.readInstanceField(decoratedTypes, getDecoratedTypes.getThis()));
    }

    protected void implementGetDelegateType(ClassCreator creator, FieldDescriptor delegateType) {
        MethodCreator getDelegateType = (MethodCreator)creator.getMethodCreator("getDelegateType", Type.class, new Class[0]).setModifiers(1);
        getDelegateType.returnValue(getDelegateType.readInstanceField(delegateType, getDelegateType.getThis()));
    }

    protected void implementGetDelegateQualifiers(ClassCreator creator, FieldCreator qualifiersField) {
        if (qualifiersField != null) {
            MethodCreator getDelegateQualifiers = (MethodCreator)creator.getMethodCreator("getDelegateQualifiers", Set.class, new Class[0]).setModifiers(1);
            getDelegateQualifiers.returnValue(getDelegateQualifiers.readInstanceField(qualifiersField.getFieldDescriptor(), getDelegateQualifiers.getThis()));
        }
    }

    protected void implementGetPriority(ClassCreator creator, DecoratorInfo decorator) {
        MethodCreator getPriority = (MethodCreator)creator.getMethodCreator("getPriority", Integer.TYPE, new Class[0]).setModifiers(1);
        getPriority.returnValue(getPriority.load(decorator.getPriority().intValue()));
    }
}

