/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.processor.bcextensions.AnnotationMemberImpl;
import io.quarkus.arc.processor.bcextensions.ClassInfoImpl;
import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.enterprise.lang.model.AnnotationMember;
import jakarta.enterprise.lang.model.declarations.ClassInfo;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MutableAnnotationOverlay;

class AnnotationInfoImpl
implements AnnotationInfo {
    final IndexView jandexIndex;
    final MutableAnnotationOverlay annotationOverlay;
    final AnnotationInstance jandexAnnotation;

    AnnotationInfoImpl(IndexView jandexIndex, MutableAnnotationOverlay annotationOverlay, AnnotationInstance jandexAnnotation) {
        this.jandexIndex = jandexIndex;
        this.annotationOverlay = annotationOverlay;
        this.jandexAnnotation = jandexAnnotation;
    }

    public ClassInfo declaration() {
        DotName annotationClassName = this.jandexAnnotation.name();
        org.jboss.jandex.ClassInfo annotationClass = this.jandexIndex.getClassByName(annotationClassName);
        if (annotationClass == null) {
            throw new IllegalStateException("Class " + annotationClassName + " not found in Jandex");
        }
        return new ClassInfoImpl(this.jandexIndex, this.annotationOverlay, annotationClass);
    }

    public boolean hasMember(String name) {
        return this.jandexAnnotation.valueWithDefault(this.jandexIndex, name) != null;
    }

    public AnnotationMember member(String name) {
        return new AnnotationMemberImpl(this.jandexIndex, this.annotationOverlay, this.jandexAnnotation.valueWithDefault(this.jandexIndex, name));
    }

    public Map<String, AnnotationMember> members() {
        HashMap<String, AnnotationMemberImpl> result = new HashMap<String, AnnotationMemberImpl>();
        for (AnnotationValue jandexAnnotationMember : this.jandexAnnotation.valuesWithDefaults(this.jandexIndex)) {
            result.put(jandexAnnotationMember.name(), new AnnotationMemberImpl(this.jandexIndex, this.annotationOverlay, jandexAnnotationMember));
        }
        return Collections.unmodifiableMap(result);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationInfoImpl that = (AnnotationInfoImpl)o;
        return Objects.equals(this.jandexAnnotation.name(), that.jandexAnnotation.name()) && Objects.equals(this.members(), that.members());
    }

    public int hashCode() {
        return Objects.hash(this.jandexAnnotation.name(), this.members());
    }

    public String toString() {
        return this.jandexAnnotation.toString(false);
    }
}

