/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.processor.bcextensions.AnnotationInfoImpl;
import io.quarkus.arc.processor.bcextensions.ClassInfoImpl;
import io.quarkus.arc.processor.bcextensions.TypeImpl;
import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.enterprise.lang.model.AnnotationMember;
import jakarta.enterprise.lang.model.declarations.ClassInfo;
import jakarta.enterprise.lang.model.types.Type;
import java.util.List;
import java.util.Objects;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MutableAnnotationOverlay;

class AnnotationMemberImpl
implements AnnotationMember {
    final IndexView jandexIndex;
    final MutableAnnotationOverlay annotationOverlay;
    final AnnotationMember.Kind kind;
    final AnnotationValue jandexAnnotationMember;

    AnnotationMemberImpl(IndexView jandexIndex, MutableAnnotationOverlay annotationOverlay, AnnotationValue jandexAnnotationMember) {
        this.jandexIndex = jandexIndex;
        this.annotationOverlay = annotationOverlay;
        this.kind = AnnotationMemberImpl.determineKind(jandexAnnotationMember);
        this.jandexAnnotationMember = jandexAnnotationMember;
    }

    private static AnnotationMember.Kind determineKind(AnnotationValue value) {
        return switch (value.kind()) {
            case AnnotationValue.Kind.BOOLEAN -> AnnotationMember.Kind.BOOLEAN;
            case AnnotationValue.Kind.BYTE -> AnnotationMember.Kind.BYTE;
            case AnnotationValue.Kind.SHORT -> AnnotationMember.Kind.SHORT;
            case AnnotationValue.Kind.INTEGER -> AnnotationMember.Kind.INT;
            case AnnotationValue.Kind.LONG -> AnnotationMember.Kind.LONG;
            case AnnotationValue.Kind.FLOAT -> AnnotationMember.Kind.FLOAT;
            case AnnotationValue.Kind.DOUBLE -> AnnotationMember.Kind.DOUBLE;
            case AnnotationValue.Kind.CHARACTER -> AnnotationMember.Kind.CHAR;
            case AnnotationValue.Kind.STRING -> AnnotationMember.Kind.STRING;
            case AnnotationValue.Kind.ENUM -> AnnotationMember.Kind.ENUM;
            case AnnotationValue.Kind.CLASS -> AnnotationMember.Kind.CLASS;
            case AnnotationValue.Kind.NESTED -> AnnotationMember.Kind.NESTED_ANNOTATION;
            case AnnotationValue.Kind.ARRAY -> AnnotationMember.Kind.ARRAY;
            default -> throw new IllegalArgumentException("Unknown annotation member " + value);
        };
    }

    private void checkKind(AnnotationMember.Kind kind) {
        if (this.kind != kind) {
            throw new IllegalStateException("Not " + kind + ": " + this.jandexAnnotationMember);
        }
    }

    public AnnotationMember.Kind kind() {
        return this.kind;
    }

    public boolean asBoolean() {
        this.checkKind(AnnotationMember.Kind.BOOLEAN);
        return this.jandexAnnotationMember.asBoolean();
    }

    public byte asByte() {
        this.checkKind(AnnotationMember.Kind.BYTE);
        return this.jandexAnnotationMember.asByte();
    }

    public short asShort() {
        this.checkKind(AnnotationMember.Kind.SHORT);
        return this.jandexAnnotationMember.asShort();
    }

    public int asInt() {
        this.checkKind(AnnotationMember.Kind.INT);
        return this.jandexAnnotationMember.asInt();
    }

    public long asLong() {
        this.checkKind(AnnotationMember.Kind.LONG);
        return this.jandexAnnotationMember.asLong();
    }

    public float asFloat() {
        this.checkKind(AnnotationMember.Kind.FLOAT);
        return this.jandexAnnotationMember.asFloat();
    }

    public double asDouble() {
        this.checkKind(AnnotationMember.Kind.DOUBLE);
        return this.jandexAnnotationMember.asDouble();
    }

    public char asChar() {
        this.checkKind(AnnotationMember.Kind.CHAR);
        return this.jandexAnnotationMember.asChar();
    }

    public String asString() {
        this.checkKind(AnnotationMember.Kind.STRING);
        return this.jandexAnnotationMember.asString();
    }

    public <E extends Enum<E>> E asEnum(Class<E> enumType) {
        this.checkKind(AnnotationMember.Kind.ENUM);
        return Enum.valueOf(enumType, this.jandexAnnotationMember.asEnum());
    }

    public String asEnumConstant() {
        this.checkKind(AnnotationMember.Kind.ENUM);
        return this.jandexAnnotationMember.asEnum();
    }

    public ClassInfo asEnumClass() {
        this.checkKind(AnnotationMember.Kind.ENUM);
        return new ClassInfoImpl(this.jandexIndex, this.annotationOverlay, this.jandexIndex.getClassByName(this.jandexAnnotationMember.asEnumType()));
    }

    public Type asType() {
        this.checkKind(AnnotationMember.Kind.CLASS);
        return TypeImpl.fromJandexType(this.jandexIndex, this.annotationOverlay, this.jandexAnnotationMember.asClass());
    }

    public AnnotationInfo asNestedAnnotation() {
        this.checkKind(AnnotationMember.Kind.NESTED_ANNOTATION);
        return new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlay, this.jandexAnnotationMember.asNested());
    }

    public List<AnnotationMember> asArray() {
        this.checkKind(AnnotationMember.Kind.ARRAY);
        return this.jandexAnnotationMember.asArrayList().stream().map(it -> new AnnotationMemberImpl(this.jandexIndex, this.annotationOverlay, (AnnotationValue)it)).toList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationMemberImpl that = (AnnotationMemberImpl)o;
        return Objects.equals(this.jandexAnnotationMember.value(), that.jandexAnnotationMember.value());
    }

    public int hashCode() {
        return Objects.hash(this.jandexAnnotationMember.value());
    }

    public String toString() {
        return "" + this.jandexAnnotationMember.value();
    }
}

