/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointModifier;
import io.quarkus.arc.processor.InvokerBuilder;
import jakarta.enterprise.inject.spi.DeploymentException;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.Objects;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;

public class InvokerFactory {
    private final BeanDeployment beanDeployment;
    private final InjectionPointModifier injectionPointTransformer;

    InvokerFactory(BeanDeployment beanDeployment, InjectionPointModifier injectionPointTransformer) {
        this.beanDeployment = beanDeployment;
        this.injectionPointTransformer = injectionPointTransformer;
    }

    public InvokerBuilder createInvoker(BeanInfo targetBean, MethodInfo targetMethod) {
        Objects.requireNonNull(targetBean);
        Objects.requireNonNull(targetMethod);
        if (!targetBean.isClassBean()) {
            throw new DeploymentException("Cannot build invoker for target bean: " + targetBean);
        }
        if (targetBean.isInterceptor() || targetBean.isDecorator()) {
            throw new DeploymentException("Cannot build invoker for target bean: " + targetBean);
        }
        if (targetMethod.isSynthetic() || targetMethod.isConstructor() || targetMethod.isStaticInitializer() || Modifier.isPrivate(targetMethod.flags())) {
            throw new DeploymentException("Cannot build invoker for target method: " + targetMethod);
        }
        if (DotNames.OBJECT.equals((Object)targetMethod.declaringClass().name()) && !"toString".equals(targetMethod.name())) {
            throw new DeploymentException("Cannot build invoker for target method: " + targetMethod);
        }
        boolean isOwnMethod = false;
        IndexView index = this.beanDeployment.getBeanArchiveIndex();
        ArrayDeque<ClassInfo> worklist = new ArrayDeque<ClassInfo>();
        worklist.add(targetBean.getImplClazz());
        while (!worklist.isEmpty()) {
            ClassInfo clazz = (ClassInfo)worklist.poll();
            if (clazz.methods().contains(targetMethod)) {
                isOwnMethod = true;
                break;
            }
            DotName superClassName = clazz.superName();
            if (!DotNames.OBJECT.equals((Object)superClassName)) {
                ClassInfo superClass = index.getClassByName(superClassName);
                worklist.add(superClass);
            }
            for (DotName superInterfaceName : clazz.interfaceNames()) {
                ClassInfo superInterface = index.getClassByName(superInterfaceName);
                worklist.add(superInterface);
            }
        }
        if (!isOwnMethod) {
            throw new DeploymentException("Method does not belong to target bean " + targetBean + ": " + targetMethod);
        }
        return new InvokerBuilder(targetBean, targetMethod, this.beanDeployment, this.injectionPointTransformer);
    }
}

