/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.ArcInvocationContext;
import io.quarkus.arc.InjectableInterceptor;
import io.quarkus.arc.InterceptorCreator;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.BeanGenerator;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanProcessor;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.arc.processor.ReflectionRegistration;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.arc.processor.SyntheticComponentsUtil;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.FunctionCreator;
import io.quarkus.gizmo.Gizmo;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import jakarta.enterprise.inject.spi.InterceptionType;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class InterceptorGenerator
extends BeanGenerator {
    protected static final String FIELD_NAME_BINDINGS = "bindings";

    public InterceptorGenerator(AnnotationLiteralProcessor annotationLiterals, Predicate<DotName> applicationClassPredicate, BeanProcessor.PrivateMembersCollector privateMembers, boolean generateSources, ReflectionRegistration reflectionRegistration, Set<String> existingClasses, Map<BeanInfo, String> beanToGeneratedName, Predicate<DotName> injectionPointAnnotationsPredicate) {
        super(annotationLiterals, applicationClassPredicate, privateMembers, generateSources, reflectionRegistration, existingClasses, beanToGeneratedName, injectionPointAnnotationsPredicate, Collections.emptyList());
    }

    void precomputeGeneratedName(InterceptorInfo interceptor) {
        String targetPackage;
        Object baseName;
        BeanGenerator.ProviderType providerType = new BeanGenerator.ProviderType(interceptor.getProviderType());
        if (interceptor.isSynthetic()) {
            DotName creatorClassName = DotName.createSimple(interceptor.getCreatorClass());
            baseName = InterceptorCreator.InterceptFunction.class.getSimpleName() + "_" + interceptor.getIdentifier();
            targetPackage = DotNames.packageName(creatorClassName);
        } else {
            ClassInfo interceptorClass = interceptor.getTarget().get().asClass();
            baseName = interceptorClass.enclosingClass() != null ? DotNames.simpleName(interceptorClass.enclosingClass()) + "_" + DotNames.simpleName(interceptorClass) : DotNames.simpleName(interceptorClass);
            targetPackage = DotNames.packageName(providerType.name());
        }
        this.beanToGeneratedBaseName.put(interceptor, baseName);
        String generatedName = InterceptorGenerator.generatedNameFromTarget(targetPackage, (String)baseName, "_Bean");
        this.beanToGeneratedName.put(interceptor, generatedName);
    }

    Collection<ResourceOutput.Resource> generate(InterceptorInfo interceptor) {
        return interceptor.isSynthetic() ? this.generateSyntheticInterceptor(interceptor) : this.generateClassInterceptor(interceptor);
    }

    private Collection<ResourceOutput.Resource> generateSyntheticInterceptor(InterceptorInfo interceptor) {
        BeanGenerator.ProviderType providerType = new BeanGenerator.ProviderType(interceptor.getProviderType());
        DotName creatorClassName = DotName.createSimple(interceptor.getCreatorClass());
        String baseName = (String)this.beanToGeneratedBaseName.get(interceptor);
        String targetPackage = DotNames.packageName(creatorClassName);
        String generatedName = (String)this.beanToGeneratedName.get(interceptor);
        if (this.existingClasses.contains(generatedName)) {
            return Collections.emptyList();
        }
        boolean isApplicationClass = this.applicationClassPredicate.test(creatorClassName);
        ResourceClassOutput classOutput = new ResourceClassOutput(isApplicationClass, name -> name.equals(generatedName) ? ResourceOutput.Resource.SpecialType.INTERCEPTOR_BEAN : null, this.generateSources);
        ClassCreator interceptorBean = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(generatedName).interfaces(new Class[]{InjectableInterceptor.class, Supplier.class}).build();
        FieldCreator beanTypes = (FieldCreator)interceptorBean.getFieldCreator("types", Set.class).setModifiers(18);
        FieldCreator bindings = (FieldCreator)interceptorBean.getFieldCreator(FIELD_NAME_BINDINGS, Set.class).setModifiers(18);
        HashMap<InjectionPointInfo, String> injectionPointToProviderField = new HashMap<InjectionPointInfo, String>();
        this.initMaps(interceptor, injectionPointToProviderField, Collections.emptyMap(), Collections.emptyMap());
        this.createProviderFields(interceptorBean, interceptor, injectionPointToProviderField, Collections.emptyMap(), Collections.emptyMap());
        MethodCreator constructor = this.createConstructor((ClassOutput)classOutput, interceptorBean, interceptor, injectionPointToProviderField, bindings.getFieldDescriptor(), this.reflectionRegistration, isApplicationClass, providerType);
        SyntheticComponentsUtil.addParamsFieldAndInit(interceptorBean, constructor, interceptor.getParams(), this.annotationLiterals, interceptor.getDeployment().getBeanArchiveIndex());
        constructor.returnValue(null);
        this.implementGetIdentifier(interceptor, interceptorBean);
        this.implementSupplierGet(interceptorBean);
        this.implementCreate(classOutput, interceptorBean, interceptor, providerType, baseName, injectionPointToProviderField, Collections.emptyMap(), Collections.emptyMap(), targetPackage, isApplicationClass);
        this.implementGet(interceptor, interceptorBean, providerType, baseName);
        this.implementGetTypes(interceptorBean, beanTypes.getFieldDescriptor());
        this.implementGetBeanClass(interceptor, interceptorBean);
        this.implementGetInterceptorBindings(interceptorBean, bindings.getFieldDescriptor());
        this.implementIntercepts(interceptorBean, interceptor);
        this.implementIntercept(interceptorBean, interceptor, providerType, this.reflectionRegistration, isApplicationClass);
        this.implementGetPriority(interceptorBean, interceptor);
        this.implementEquals(interceptor, interceptorBean);
        this.implementHashCode(interceptor, interceptorBean);
        interceptorBean.close();
        return classOutput.getResources();
    }

    private Collection<ResourceOutput.Resource> generateClassInterceptor(InterceptorInfo interceptor) {
        BeanGenerator.ProviderType providerType = new BeanGenerator.ProviderType(interceptor.getProviderType());
        String baseName = (String)this.beanToGeneratedBaseName.get(interceptor);
        String targetPackage = DotNames.packageName(providerType.name());
        String generatedName = (String)this.beanToGeneratedName.get(interceptor);
        if (this.existingClasses.contains(generatedName)) {
            return Collections.emptyList();
        }
        boolean isApplicationClass = this.applicationClassPredicate.test(interceptor.getBeanClass());
        ResourceClassOutput classOutput = new ResourceClassOutput(isApplicationClass, name -> name.equals(generatedName) ? ResourceOutput.Resource.SpecialType.INTERCEPTOR_BEAN : null, this.generateSources);
        ClassCreator interceptorCreator = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(generatedName).interfaces(new Class[]{InjectableInterceptor.class, Supplier.class}).build();
        FieldCreator beanTypes = (FieldCreator)interceptorCreator.getFieldCreator("types", Set.class).setModifiers(18);
        FieldCreator bindings = (FieldCreator)interceptorCreator.getFieldCreator(FIELD_NAME_BINDINGS, Set.class).setModifiers(18);
        HashMap<InjectionPointInfo, String> injectionPointToProviderField = new HashMap<InjectionPointInfo, String>();
        this.initMaps(interceptor, injectionPointToProviderField, Collections.emptyMap(), Collections.emptyMap());
        this.createProviderFields(interceptorCreator, interceptor, injectionPointToProviderField, Collections.emptyMap(), Collections.emptyMap());
        this.createConstructor((ClassOutput)classOutput, interceptorCreator, interceptor, injectionPointToProviderField, bindings.getFieldDescriptor(), this.reflectionRegistration, isApplicationClass, providerType).returnValue(null);
        this.implementGetIdentifier(interceptor, interceptorCreator);
        this.implementSupplierGet(interceptorCreator);
        this.implementCreate(classOutput, interceptorCreator, interceptor, providerType, baseName, injectionPointToProviderField, Collections.emptyMap(), Collections.emptyMap(), targetPackage, isApplicationClass);
        this.implementGet(interceptor, interceptorCreator, providerType, baseName);
        this.implementGetTypes(interceptorCreator, beanTypes.getFieldDescriptor());
        this.implementGetBeanClass(interceptor, interceptorCreator);
        this.implementGetInterceptorBindings(interceptorCreator, bindings.getFieldDescriptor());
        this.implementIntercepts(interceptorCreator, interceptor);
        this.implementIntercept(interceptorCreator, interceptor, providerType, this.reflectionRegistration, isApplicationClass);
        this.implementGetPriority(interceptorCreator, interceptor);
        this.implementEquals(interceptor, interceptorCreator);
        this.implementHashCode(interceptor, interceptorCreator);
        interceptorCreator.close();
        return classOutput.getResources();
    }

    protected MethodCreator createConstructor(ClassOutput classOutput, ClassCreator creator, InterceptorInfo interceptor, Map<InjectionPointInfo, String> injectionPointToProviderField, FieldDescriptor bindings, ReflectionRegistration reflectionRegistration, boolean isApplicationClass, BeanGenerator.ProviderType providerType) {
        MethodCreator constructor = this.initConstructor(classOutput, creator, interceptor, injectionPointToProviderField, Collections.emptyMap(), Collections.emptyMap(), this.annotationLiterals, reflectionRegistration);
        ResultHandle bindingsHandle = constructor.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
        for (AnnotationInstance bindingAnnotation : interceptor.getBindings()) {
            ClassInfo bindingClass = interceptor.getDeployment().getInterceptorBinding(bindingAnnotation.name());
            constructor.invokeInterfaceMethod(MethodDescriptors.SET_ADD, bindingsHandle, new ResultHandle[]{this.annotationLiterals.create((BytecodeCreator)constructor, bindingClass, bindingAnnotation)});
        }
        constructor.writeInstanceField(bindings, constructor.getThis(), bindingsHandle);
        this.initInterceptorMethodsField(creator, constructor, InterceptionType.AROUND_INVOKE, interceptor.getAroundInvokes(), providerType.className(), isApplicationClass);
        this.initInterceptorMethodsField(creator, constructor, InterceptionType.AROUND_CONSTRUCT, interceptor.getAroundConstructs(), providerType.className(), isApplicationClass);
        this.initInterceptorMethodsField(creator, constructor, InterceptionType.POST_CONSTRUCT, interceptor.getPostConstructs(), providerType.className(), isApplicationClass);
        this.initInterceptorMethodsField(creator, constructor, InterceptionType.PRE_DESTROY, interceptor.getPreDestroys(), providerType.className(), isApplicationClass);
        return constructor;
    }

    private void initInterceptorMethodsField(ClassCreator creator, MethodCreator constructor, InterceptionType interceptionType, List<MethodInfo> methods, String interceptorClass, boolean isApplicationClass) {
        if (methods.size() < 2) {
            return;
        }
        FieldCreator field = (FieldCreator)creator.getFieldCreator(this.interceptorMethodsField(interceptionType), List.class).setModifiers(2);
        ResultHandle methodsList = constructor.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]);
        for (MethodInfo method : methods) {
            FunctionCreator fun = constructor.createFunction(BiFunction.class);
            BytecodeCreator funBytecode = fun.getBytecode();
            ResultHandle ret = this.invokeInterceptorMethod(funBytecode, interceptorClass, method, interceptionType, isApplicationClass, funBytecode.getMethodParam(1), funBytecode.getMethodParam(0));
            funBytecode.returnValue(interceptionType == InterceptionType.AROUND_INVOKE ? ret : funBytecode.loadNull());
            constructor.invokeInterfaceMethod(MethodDescriptors.LIST_ADD, methodsList, new ResultHandle[]{fun.getInstance()});
        }
        constructor.writeInstanceField(field.getFieldDescriptor(), constructor.getThis(), methodsList);
    }

    protected void implementGetBeanClass(InterceptorInfo interceptor, ClassCreator beanCreator) {
        MethodCreator getBeanClass = (MethodCreator)beanCreator.getMethodCreator("getBeanClass", Class.class, new Class[0]).setModifiers(1);
        getBeanClass.returnValue(getBeanClass.loadClass(interceptor.isSynthetic() ? interceptor.getCreatorClass().getName() : interceptor.getBeanClass().toString()));
    }

    protected void implementGetInterceptorBindings(ClassCreator creator, FieldDescriptor bindingsField) {
        MethodCreator getBindings = (MethodCreator)creator.getMethodCreator("getInterceptorBindings", Set.class, new Class[0]).setModifiers(1);
        getBindings.returnValue(getBindings.readInstanceField(bindingsField, getBindings.getThis()));
    }

    protected void implementGetPriority(ClassCreator creator, InterceptorInfo interceptor) {
        MethodCreator getPriority = (MethodCreator)creator.getMethodCreator("getPriority", Integer.TYPE, new Class[0]).setModifiers(1);
        getPriority.returnValue(getPriority.load(interceptor.getPriority().intValue()));
    }

    protected void implementIntercepts(ClassCreator creator, InterceptorInfo interceptor) {
        MethodCreator intercepts = (MethodCreator)creator.getMethodCreator("intercepts", Boolean.TYPE, new Class[]{InterceptionType.class}).setModifiers(1);
        if (interceptor.isSynthetic()) {
            ResultHandle enumValue = intercepts.readStaticField(FieldDescriptor.of((String)InterceptionType.class.getName(), (String)interceptor.getInterceptionType().name(), (String)InterceptionType.class.getName()));
            BranchResult result = intercepts.ifTrue(Gizmo.equals((BytecodeCreator)intercepts, (ResultHandle)enumValue, (ResultHandle)intercepts.getMethodParam(0)));
            result.trueBranch().returnValue(result.trueBranch().load(true));
        } else {
            this.addIntercepts(interceptor, InterceptionType.AROUND_INVOKE, intercepts);
            this.addIntercepts(interceptor, InterceptionType.POST_CONSTRUCT, intercepts);
            this.addIntercepts(interceptor, InterceptionType.PRE_DESTROY, intercepts);
            this.addIntercepts(interceptor, InterceptionType.AROUND_CONSTRUCT, intercepts);
        }
        intercepts.returnValue(intercepts.load(false));
    }

    private void addIntercepts(InterceptorInfo interceptor, InterceptionType interceptionType, MethodCreator intercepts) {
        if (interceptor.intercepts(interceptionType)) {
            ResultHandle enumValue = intercepts.readStaticField(FieldDescriptor.of((String)InterceptionType.class.getName(), (String)interceptionType.name(), (String)InterceptionType.class.getName()));
            BranchResult result = intercepts.ifTrue(Gizmo.equals((BytecodeCreator)intercepts, (ResultHandle)enumValue, (ResultHandle)intercepts.getMethodParam(0)));
            result.trueBranch().returnBoolean(true);
        }
    }

    protected void implementIntercept(ClassCreator creator, InterceptorInfo interceptor, BeanGenerator.ProviderType providerType, ReflectionRegistration reflectionRegistration, boolean isApplicationClass) {
        MethodCreator intercept = ((MethodCreator)creator.getMethodCreator("intercept", Object.class, new Class[]{InterceptionType.class, Object.class, InvocationContext.class}).setModifiers(1)).addException(Exception.class);
        if (interceptor.isSynthetic()) {
            BranchResult result = intercept.ifTrue(Gizmo.equals((BytecodeCreator)intercept, (ResultHandle)intercept.load((Enum)interceptor.getInterceptionType()), (ResultHandle)intercept.getMethodParam(0)));
            BytecodeCreator trueBranch = result.trueBranch();
            ResultHandle interceptFunction = trueBranch.checkCast(trueBranch.getMethodParam(1), InterceptorCreator.InterceptFunction.class);
            trueBranch.returnValue(trueBranch.invokeInterfaceMethod(MethodDescriptors.INTERCEPT_FUNCTION_INTERCEPT, interceptFunction, new ResultHandle[]{trueBranch.getMethodParam(2)}));
        } else {
            this.addIntercept(creator, intercept, interceptor.getAroundInvokes(), InterceptionType.AROUND_INVOKE, providerType, reflectionRegistration, isApplicationClass);
            this.addIntercept(creator, intercept, interceptor.getPostConstructs(), InterceptionType.POST_CONSTRUCT, providerType, reflectionRegistration, isApplicationClass);
            this.addIntercept(creator, intercept, interceptor.getPreDestroys(), InterceptionType.PRE_DESTROY, providerType, reflectionRegistration, isApplicationClass);
            this.addIntercept(creator, intercept, interceptor.getAroundConstructs(), InterceptionType.AROUND_CONSTRUCT, providerType, reflectionRegistration, isApplicationClass);
        }
        intercept.returnValue(intercept.loadNull());
    }

    private void addIntercept(ClassCreator creator, MethodCreator intercept, List<MethodInfo> interceptorMethods, InterceptionType interceptionType, BeanGenerator.ProviderType providerType, ReflectionRegistration reflectionRegistration, boolean isApplicationClass) {
        ResultHandle ret;
        if (interceptorMethods.isEmpty()) {
            return;
        }
        BranchResult result = intercept.ifTrue(Gizmo.equals((BytecodeCreator)intercept, (ResultHandle)intercept.load((Enum)interceptionType), (ResultHandle)intercept.getMethodParam(0)));
        BytecodeCreator trueBranch = result.trueBranch();
        if (interceptorMethods.size() == 1) {
            MethodInfo interceptorMethod = interceptorMethods.get(0);
            ret = this.invokeInterceptorMethod(trueBranch, providerType.className(), interceptorMethod, interceptionType, isApplicationClass, trueBranch.getMethodParam(2), trueBranch.getMethodParam(1));
        } else {
            ResultHandle methodList = trueBranch.readInstanceField(FieldDescriptor.of((String)creator.getClassName(), (String)this.interceptorMethodsField(interceptionType), List.class), trueBranch.getThis());
            ResultHandle params = interceptionType == InterceptionType.AROUND_INVOKE ? trueBranch.invokeInterfaceMethod(MethodDescriptors.INVOCATION_CONTEXT_GET_PARAMETERS, trueBranch.getMethodParam(2), new ResultHandle[0]) : trueBranch.loadNull();
            ret = trueBranch.invokeStaticMethod(MethodDescriptors.INVOCATION_CONTEXTS_PERFORM_SUPERCLASS, new ResultHandle[]{trueBranch.getMethodParam(2), methodList, trueBranch.getMethodParam(1), params});
        }
        trueBranch.returnValue(InterceptionType.AROUND_INVOKE.equals((Object)interceptionType) ? ret : trueBranch.loadNull());
    }

    private String interceptorMethodsField(InterceptionType interceptionType) {
        switch (interceptionType) {
            case AROUND_INVOKE: {
                return "aroundInvokes";
            }
            case AROUND_CONSTRUCT: {
                return "aroundConstructs";
            }
            case POST_CONSTRUCT: {
                return "postConstructs";
            }
            case PRE_DESTROY: {
                return "preDestroys";
            }
        }
        throw new IllegalArgumentException("Unsupported interception type: " + interceptionType);
    }

    private ResultHandle invokeInterceptorMethod(BytecodeCreator creator, String interceptorClass, MethodInfo interceptorMethod, InterceptionType interceptionType, boolean isApplicationClass, ResultHandle invocationContext, ResultHandle interceptorInstance) {
        ResultHandle ret;
        Class<Object> retType = null;
        retType = InterceptionType.AROUND_INVOKE.equals((Object)interceptionType) ? Object.class : (interceptorMethod.returnType().kind().equals((Object)Type.Kind.VOID) ? Void.TYPE : Object.class);
        Class invocationContextClass = interceptorMethod.parameterType(0).name().equals((Object)DotNames.INVOCATION_CONTEXT) ? InvocationContext.class : ArcInvocationContext.class;
        if (Modifier.isPrivate(interceptorMethod.flags())) {
            this.privateMembers.add(isApplicationClass, String.format("Interceptor method %s#%s()", interceptorMethod.declaringClass().name(), interceptorMethod.name()));
            ResultHandle paramTypesArray = creator.newArray(Class.class, creator.load(1));
            creator.writeArrayValue(paramTypesArray, 0, creator.loadClass(invocationContextClass));
            ResultHandle argsArray = creator.newArray(Object.class, creator.load(1));
            creator.writeArrayValue(argsArray, 0, invocationContext);
            this.reflectionRegistration.registerMethod(interceptorMethod);
            ret = creator.invokeStaticMethod(MethodDescriptors.REFLECTIONS_INVOKE_METHOD, new ResultHandle[]{creator.loadClass(interceptorMethod.declaringClass().name().toString()), creator.load(interceptorMethod.name()), paramTypesArray, interceptorInstance, argsArray});
        } else {
            ret = creator.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)interceptorClass, (String)interceptorMethod.name(), retType, (Object[])new Object[]{invocationContextClass}), interceptorInstance, new ResultHandle[]{invocationContext});
        }
        return ret;
    }
}

