/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.util.Objects;
import org.jboss.jandex.DotName;

public class ScopeInfo {
    private final DotName dotName;
    private final boolean isNormal;
    private boolean declaresInherited;

    public ScopeInfo(Class<? extends Annotation> clazz, boolean isNormal) {
        this.dotName = DotName.createSimple((String)clazz.getName());
        this.isNormal = isNormal;
        this.declaresInherited = clazz.getAnnotation(Inherited.class) != null;
    }

    public ScopeInfo(DotName clazz, boolean isNormal) {
        this.dotName = clazz;
        this.isNormal = isNormal;
        this.declaresInherited = true;
    }

    public ScopeInfo(DotName clazz, boolean isNormal, boolean declaresInherited) {
        this.dotName = clazz;
        this.isNormal = isNormal;
        this.declaresInherited = declaresInherited;
    }

    public DotName getDotName() {
        return this.dotName;
    }

    public boolean isNormal() {
        return this.isNormal;
    }

    public boolean declaresInherited() {
        return this.declaresInherited;
    }

    public int hashCode() {
        return Objects.hash(this.dotName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScopeInfo other = (ScopeInfo)obj;
        return Objects.equals(this.dotName, other.dotName);
    }
}

