/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.processor.bcextensions.AllAnnotationOverlays;
import io.quarkus.arc.processor.bcextensions.AllAnnotationTransformations;
import io.quarkus.arc.processor.bcextensions.ClassConfigImpl;
import io.quarkus.arc.processor.bcextensions.ClassInfoImpl;
import io.quarkus.arc.processor.bcextensions.DotNames;
import io.quarkus.arc.processor.bcextensions.ExtensionInvoker;
import io.quarkus.arc.processor.bcextensions.ExtensionMethod;
import io.quarkus.arc.processor.bcextensions.ExtensionMethodParameter;
import io.quarkus.arc.processor.bcextensions.ExtensionPhase;
import io.quarkus.arc.processor.bcextensions.ExtensionPhaseBase;
import io.quarkus.arc.processor.bcextensions.SharedErrors;
import io.quarkus.arc.processor.bcextensions.TypesImpl;
import jakarta.enterprise.inject.spi.DefinitionException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

class ExtensionPhaseEnhancement
extends ExtensionPhaseBase {
    private final AllAnnotationOverlays annotationOverlays;
    private final AllAnnotationTransformations annotationTransformations;

    ExtensionPhaseEnhancement(ExtensionInvoker invoker, IndexView beanArchiveIndex, SharedErrors errors, AllAnnotationTransformations annotationTransformations) {
        super(ExtensionPhase.ENHANCEMENT, invoker, beanArchiveIndex, errors);
        this.annotationOverlays = annotationTransformations.annotationOverlays;
        this.annotationTransformations = annotationTransformations;
    }

    @Override
    void runExtensionMethod(ExtensionMethod method) throws ReflectiveOperationException {
        List allValuesForQueryParameter;
        int numQueryParameters = 0;
        ArrayList<ExtensionMethodParameter> parameters = new ArrayList<ExtensionMethodParameter>(method.parametersCount());
        for (Type parameterType : method.parameterTypes()) {
            ExtensionMethodParameter parameter = ExtensionMethodParameter.of(parameterType);
            parameters.add(parameter);
            if (parameter.isQuery()) {
                ++numQueryParameters;
            }
            parameter.verifyAvailable(ExtensionPhase.ENHANCEMENT, method);
        }
        if (numQueryParameters == 0) {
            throw new DefinitionException("No parameter of type ClassInfo, MethodInfo, FieldInfo, ClassConfig, MethodConfig, or FieldConfig for method " + method);
        }
        if (numQueryParameters > 1) {
            throw new DefinitionException("More than 1 parameter of type ClassInfo, MethodInfo, FieldInfo, ClassConfig, MethodConfig, or FieldConfig for method " + method);
        }
        ExtensionMethodParameter query = parameters.stream().filter(ExtensionMethodParameter::isQuery).findAny().get();
        List<ClassInfo> matchingClasses = this.matchingClasses(method.jandex);
        if (query == ExtensionMethodParameter.CLASS_INFO) {
            allValuesForQueryParameter = matchingClasses.stream().map(it -> new ClassInfoImpl(this.index, this.annotationOverlays, (ClassInfo)it)).collect(Collectors.toUnmodifiableList());
        } else if (query == ExtensionMethodParameter.METHOD_INFO) {
            allValuesForQueryParameter = matchingClasses.stream().map(it -> new ClassInfoImpl(this.index, this.annotationOverlays, (ClassInfo)it)).flatMap(it -> Stream.concat(it.constructors().stream(), it.methods().stream())).collect(Collectors.toUnmodifiableList());
        } else if (query == ExtensionMethodParameter.FIELD_INFO) {
            allValuesForQueryParameter = matchingClasses.stream().map(it -> new ClassInfoImpl(this.index, this.annotationOverlays, (ClassInfo)it)).flatMap(it -> it.fields().stream()).collect(Collectors.toUnmodifiableList());
        } else if (query == ExtensionMethodParameter.CLASS_CONFIG) {
            allValuesForQueryParameter = matchingClasses.stream().map(it -> new ClassConfigImpl(this.index, this.annotationTransformations, (ClassInfo)it)).collect(Collectors.toUnmodifiableList());
        } else if (query == ExtensionMethodParameter.METHOD_CONFIG) {
            allValuesForQueryParameter = matchingClasses.stream().map(it -> new ClassConfigImpl(this.index, this.annotationTransformations, (ClassInfo)it)).flatMap(it -> Stream.concat(it.constructors().stream(), it.methods().stream())).collect(Collectors.toUnmodifiableList());
        } else if (query == ExtensionMethodParameter.FIELD_CONFIG) {
            allValuesForQueryParameter = matchingClasses.stream().map(it -> new ClassConfigImpl(this.index, this.annotationTransformations, (ClassInfo)it)).flatMap(it -> it.fields().stream()).collect(Collectors.toUnmodifiableList());
        } else {
            throw new IllegalArgumentException("Unknown query parameter " + query);
        }
        for (Object queryParameterValue : allValuesForQueryParameter) {
            ArrayList<Object> arguments = new ArrayList<Object>();
            for (ExtensionMethodParameter parameter : parameters) {
                Object argument = parameter.isQuery() ? queryParameterValue : this.argumentForExtensionMethod(parameter, method);
                arguments.add(argument);
            }
            this.util.callExtensionMethod(method, arguments);
        }
    }

    private List<ClassInfo> matchingClasses(MethodInfo method) {
        AnnotationInstance enhancement = method.annotation(DotNames.ENHANCEMENT);
        Type[] jandexTypes = enhancement.value("types").asClassArray();
        boolean withSubtypes = enhancement.valueWithDefault(this.index, "withSubtypes").asBoolean();
        ArrayList<ClassInfo> result = new ArrayList<ClassInfo>();
        for (Type jandexType : jandexTypes) {
            ClassInfo clazz = this.index.getClassByName(jandexType.name());
            if (clazz.isAnnotation()) continue;
            result.add(clazz);
            if (!withSubtypes) continue;
            Collection subtypes = Modifier.isInterface(clazz.flags()) ? this.index.getAllKnownImplementors(jandexType.name()) : this.index.getAllKnownSubclasses(jandexType.name());
            result.addAll(subtypes);
        }
        HashSet<DotName> withAnnotations = new HashSet<DotName>();
        for (Type annotationType : enhancement.valueWithDefault(this.index, "withAnnotations").asClassArray()) {
            withAnnotations.add(annotationType.asClassType().name());
        }
        if (withAnnotations.isEmpty() || withAnnotations.contains(DotNames.ANNOTATION)) {
            return Collections.unmodifiableList(result);
        }
        ArrayList<ClassInfo> filteredResult = new ArrayList<ClassInfo>();
        for (ClassInfo clazz : result) {
            if (!this.isAnyAnnotationPresent(withAnnotations, clazz, new HashSet<DotName>())) continue;
            filteredResult.add(clazz);
        }
        return Collections.unmodifiableList(filteredResult);
    }

    private boolean isAnyAnnotationPresent(Set<DotName> annotationNames, ClassInfo clazz, Set<DotName> alreadyProcessed) {
        Set annotationsOnClass = clazz.annotationsMap().keySet();
        for (DotName annotationOnClass : annotationsOnClass) {
            if (alreadyProcessed.contains(annotationOnClass)) continue;
            alreadyProcessed.add(annotationOnClass);
            if (annotationNames.contains(annotationOnClass)) {
                return true;
            }
            ClassInfo annotationDeclaration = this.index.getClassByName(annotationOnClass);
            if (annotationDeclaration == null || !this.isAnyAnnotationPresent(annotationNames, annotationDeclaration, alreadyProcessed)) continue;
            return true;
        }
        return false;
    }

    @Override
    Object argumentForExtensionMethod(ExtensionMethodParameter type, ExtensionMethod method) {
        if (type == ExtensionMethodParameter.TYPES) {
            return new TypesImpl(this.index, this.annotationOverlays);
        }
        return super.argumentForExtensionMethod(type, method);
    }
}

