/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets;

import io.undertow.websockets.Encoding;
import io.undertow.websockets.JsrWebSocketMessages;
import io.undertow.websockets.util.ObjectFactory;
import io.undertow.websockets.util.ObjectHandle;
import io.undertow.websockets.util.ObjectIntrospecter;
import jakarta.websocket.Decoder;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Encoder;
import jakarta.websocket.EndpointConfig;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EncodingFactory {
    public static final EncodingFactory DEFAULT = new EncodingFactory(Collections.EMPTY_MAP, Collections.EMPTY_MAP, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
    private final Map<Class<?>, List<ObjectFactory<? extends Encoder>>> binaryEncoders;
    private final Map<Class<?>, List<ObjectFactory<? extends Decoder>>> binaryDecoders;
    private final Map<Class<?>, List<ObjectFactory<? extends Encoder>>> textEncoders;
    private final Map<Class<?>, List<ObjectFactory<? extends Decoder>>> textDecoders;

    public EncodingFactory(Map<Class<?>, List<ObjectFactory<? extends Encoder>>> binaryEncoders, Map<Class<?>, List<ObjectFactory<? extends Decoder>>> binaryDecoders, Map<Class<?>, List<ObjectFactory<? extends Encoder>>> textEncoders, Map<Class<?>, List<ObjectFactory<? extends Decoder>>> textDecoders) {
        this.binaryEncoders = binaryEncoders;
        this.binaryDecoders = binaryDecoders;
        this.textEncoders = textEncoders;
        this.textDecoders = textDecoders;
    }

    public boolean canEncodeText(Class<?> type) {
        if (EncodingFactory.isPrimitiveOrBoxed(type)) {
            return true;
        }
        return this.textEncoders.containsKey(type);
    }

    public boolean canDecodeText(Class<?> type) {
        if (EncodingFactory.isPrimitiveOrBoxed(type)) {
            return true;
        }
        return this.textDecoders.containsKey(type);
    }

    public boolean canEncodeBinary(Class<?> type) {
        return this.binaryEncoders.containsKey(type);
    }

    public boolean canDecodeBinary(Class<?> type) {
        return this.binaryDecoders.containsKey(type);
    }

    public Encoding createEncoding(EndpointConfig endpointConfig) {
        ObjectHandle<? extends Encoder> instance;
        ArrayList<ObjectHandle<? extends Encoder>> val;
        HashMap binaryEncoders = this.binaryEncoders.isEmpty() ? Collections.emptyMap() : new HashMap();
        HashMap binaryDecoders = this.binaryDecoders.isEmpty() ? Collections.emptyMap() : new HashMap();
        HashMap textEncoders = this.textEncoders.isEmpty() ? Collections.emptyMap() : new HashMap();
        HashMap textDecoders = this.textDecoders.isEmpty() ? Collections.emptyMap() : new HashMap();
        for (Map.Entry<Class<?>, List<ObjectFactory<Encoder>>> entry : this.binaryEncoders.entrySet()) {
            val = new ArrayList<ObjectHandle<? extends Encoder>>(entry.getValue().size());
            binaryEncoders.put(entry.getKey(), val);
            for (ObjectFactory<? extends Encoder> factory : entry.getValue()) {
                instance = factory.createInstance();
                instance.getInstance().init(endpointConfig);
                val.add(instance);
            }
        }
        for (Map.Entry<Class<?>, List<ObjectFactory<Encoder>>> entry : this.binaryDecoders.entrySet()) {
            val = new ArrayList(entry.getValue().size());
            binaryDecoders.put(entry.getKey(), val);
            for (ObjectFactory<? extends Encoder> factory : entry.getValue()) {
                instance = factory.createInstance();
                ((Decoder)instance.getInstance()).init(endpointConfig);
                val.add(instance);
            }
        }
        for (Map.Entry<Class<?>, List<ObjectFactory<Encoder>>> entry : this.textEncoders.entrySet()) {
            val = new ArrayList(entry.getValue().size());
            textEncoders.put(entry.getKey(), val);
            for (ObjectFactory<? extends Encoder> factory : entry.getValue()) {
                instance = factory.createInstance();
                instance.getInstance().init(endpointConfig);
                val.add(instance);
            }
        }
        for (Map.Entry<Class<?>, List<ObjectFactory<Encoder>>> entry : this.textDecoders.entrySet()) {
            val = new ArrayList(entry.getValue().size());
            textDecoders.put(entry.getKey(), val);
            for (ObjectFactory<? extends Encoder> factory : entry.getValue()) {
                instance = factory.createInstance();
                ((Decoder)instance.getInstance()).init(endpointConfig);
                val.add(instance);
            }
        }
        return new Encoding(binaryEncoders, binaryDecoders, textEncoders, textDecoders);
    }

    public static EncodingFactory createFactory(ObjectIntrospecter objectIntrospecter, Class<? extends Decoder>[] decoders, Class<? extends Encoder>[] encoders) throws DeploymentException {
        return EncodingFactory.createFactory(objectIntrospecter, Arrays.asList(decoders), Arrays.asList(encoders));
    }

    public static EncodingFactory createFactory(ObjectIntrospecter objectIntrospecter, List<Class<? extends Decoder>> decoders, List<Class<? extends Encoder>> encoders) throws DeploymentException {
        HashMap binaryEncoders = new HashMap();
        HashMap binaryDecoders = new HashMap();
        HashMap textEncoders = new HashMap();
        HashMap textDecoders = new HashMap();
        for (Class<? extends Decoder> clazz : decoders) {
            List<ObjectFactory<? extends Decoder>> list;
            Class<?> type;
            Method method;
            if (Decoder.Binary.class.isAssignableFrom(clazz)) {
                try {
                    method = clazz.getMethod("decode", ByteBuffer.class);
                    type = EncodingFactory.resolveReturnType(method, clazz);
                    list = (ArrayList<ObjectFactory<? extends Decoder>>)binaryDecoders.get(type);
                    if (list == null) {
                        list = new ArrayList<ObjectFactory<? extends Decoder>>();
                        binaryDecoders.put(type, list);
                    }
                    list.add(objectIntrospecter.createInstanceFactory(clazz));
                    continue;
                }
                catch (NoSuchMethodException e) {
                    throw JsrWebSocketMessages.MESSAGES.couldNotDetermineTypeOfDecodeMethodForClass(clazz, e);
                }
            }
            if (Decoder.BinaryStream.class.isAssignableFrom(clazz)) {
                try {
                    method = clazz.getMethod("decode", InputStream.class);
                    type = EncodingFactory.resolveReturnType(method, clazz);
                    list = (List)binaryDecoders.get(type);
                    if (list == null) {
                        list = new ArrayList();
                        binaryDecoders.put(type, list);
                    }
                    list.add(objectIntrospecter.createInstanceFactory(clazz));
                    continue;
                }
                catch (NoSuchMethodException e) {
                    throw JsrWebSocketMessages.MESSAGES.couldNotDetermineTypeOfDecodeMethodForClass(clazz, e);
                }
            }
            if (Decoder.Text.class.isAssignableFrom(clazz)) {
                try {
                    method = clazz.getMethod("decode", String.class);
                    type = EncodingFactory.resolveReturnType(method, clazz);
                    list = (List)textDecoders.get(type);
                    if (list == null) {
                        list = new ArrayList();
                        textDecoders.put(type, list);
                    }
                    list.add(objectIntrospecter.createInstanceFactory(clazz));
                    continue;
                }
                catch (NoSuchMethodException e) {
                    throw JsrWebSocketMessages.MESSAGES.couldNotDetermineTypeOfDecodeMethodForClass(clazz, e);
                }
            }
            if (Decoder.TextStream.class.isAssignableFrom(clazz)) {
                try {
                    method = clazz.getMethod("decode", Reader.class);
                    type = EncodingFactory.resolveReturnType(method, clazz);
                    list = (List)textDecoders.get(type);
                    if (list == null) {
                        list = new ArrayList();
                        textDecoders.put(type, list);
                    }
                    list.add(EncodingFactory.createObjectFactory(objectIntrospecter, clazz));
                    continue;
                }
                catch (NoSuchMethodException e) {
                    throw JsrWebSocketMessages.MESSAGES.couldNotDetermineTypeOfDecodeMethodForClass(clazz, e);
                }
            }
            throw JsrWebSocketMessages.MESSAGES.didNotImplementKnownDecoderSubclass(clazz);
        }
        for (Class<? extends Decoder> clazz : encoders) {
            List<ObjectFactory<? extends Decoder>> list;
            Class<?> type;
            if (Encoder.Binary.class.isAssignableFrom(clazz)) {
                type = EncodingFactory.findEncodeMethod(clazz, ByteBuffer.class, new Class[0]);
                list = (ArrayList<ObjectFactory<? extends Decoder>>)binaryEncoders.get(type);
                if (list == null) {
                    list = new ArrayList<ObjectFactory<? extends Decoder>>();
                    binaryEncoders.put(type, list);
                }
                list.add(EncodingFactory.createObjectFactory(objectIntrospecter, clazz));
                continue;
            }
            if (Encoder.BinaryStream.class.isAssignableFrom(clazz)) {
                type = EncodingFactory.findEncodeMethod(clazz, Void.TYPE, OutputStream.class);
                list = (List)binaryEncoders.get(type);
                if (list == null) {
                    list = new ArrayList();
                    binaryEncoders.put(type, list);
                }
                list.add(EncodingFactory.createObjectFactory(objectIntrospecter, clazz));
                continue;
            }
            if (Encoder.Text.class.isAssignableFrom(clazz)) {
                type = EncodingFactory.findEncodeMethod(clazz, String.class, new Class[0]);
                list = (List)textEncoders.get(type);
                if (list == null) {
                    list = new ArrayList();
                    textEncoders.put(type, list);
                }
                list.add(EncodingFactory.createObjectFactory(objectIntrospecter, clazz));
                continue;
            }
            if (!Encoder.TextStream.class.isAssignableFrom(clazz)) continue;
            type = EncodingFactory.findEncodeMethod(clazz, Void.TYPE, Writer.class);
            list = (List)textEncoders.get(type);
            if (list == null) {
                list = new ArrayList();
                textEncoders.put(type, list);
            }
            list.add(EncodingFactory.createObjectFactory(objectIntrospecter, clazz));
        }
        return new EncodingFactory(binaryEncoders, binaryDecoders, textEncoders, textDecoders);
    }

    private static Class<?> resolveReturnType(Method method, Class<? extends Decoder> decoder) {
        Type genericReturnType = method.getGenericReturnType();
        if (genericReturnType instanceof Class) {
            return (Class)genericReturnType;
        }
        if (genericReturnType instanceof TypeVariable) {
            TypeVariable type = (TypeVariable)genericReturnType;
            ArrayList<Class<? extends Decoder>> classes = new ArrayList<Class<? extends Decoder>>();
            for (Class<? extends Decoder> c = decoder; c != method.getDeclaringClass() && c != null; c = c.getSuperclass()) {
                classes.add(c);
            }
            Collections.reverse(classes);
            String currentName = type.getName();
            int currentPos = -1;
            for (Class clazz : classes) {
                Type gs;
                for (int i = 0; i < clazz.getSuperclass().getTypeParameters().length; ++i) {
                    TypeVariable param = clazz.getSuperclass().getTypeParameters()[i];
                    if (!param.getName().equals(currentName)) continue;
                    currentPos = i;
                    break;
                }
                if (!((gs = clazz.getGenericSuperclass()) instanceof ParameterizedType)) continue;
                ParameterizedType pt = (ParameterizedType)gs;
                Type at = pt.getActualTypeArguments()[currentPos];
                if (at instanceof Class) {
                    return (Class)at;
                }
                if (!(at instanceof TypeVariable)) continue;
                TypeVariable tv = (TypeVariable)at;
                currentName = tv.getName();
            }
            return method.getReturnType();
        }
        return method.getReturnType();
    }

    private static <T> ObjectFactory<? extends T> createObjectFactory(ObjectIntrospecter objectIntrospecter, Class<? extends T> decoder) throws DeploymentException {
        return objectIntrospecter.createInstanceFactory(decoder);
    }

    private static Class<?> findEncodeMethod(Class<? extends Encoder> encoder, Class<?> returnType, Class<?> ... otherParameters) throws DeploymentException {
        for (Method method : encoder.getMethods()) {
            if (!method.getName().equals("encode") || method.isBridge() || method.getParameterCount() != 1 + otherParameters.length || method.getReturnType() != returnType) continue;
            boolean ok = true;
            for (int i = 1; i < method.getParameterCount(); ++i) {
                if (method.getParameterTypes()[i] == otherParameters[i - 1]) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            return method.getParameterTypes()[0];
        }
        throw JsrWebSocketMessages.MESSAGES.couldNotDetermineTypeOfEncodeMethodForClass(encoder);
    }

    static boolean isPrimitiveOrBoxed(Class<?> clazz) {
        return clazz.isPrimitive() || clazz == Boolean.class || clazz == Byte.class || clazz == Character.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class;
    }
}

