/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.AugmentResult;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.maven.MojoLogger;
import io.quarkus.maven.QuarkusBootstrapMojo;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="build", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class BuildMojo
extends QuarkusBootstrapMojo {
    private static final String PACKAGE_TYPE_PROP = "quarkus.package.type";
    private static final String NATIVE_PROFILE_NAME = "native";
    private static final String NATIVE_PACKAGE_TYPE = "native";
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${project.remotePluginRepositories}", readonly=true, required=true)
    private List<RemoteRepository> pluginRepos;
    @Parameter(defaultValue="${project.build.directory}/generated-sources")
    private File generatedSourcesDirectory;
    @Parameter(defaultValue="false", property="quarkus.build.skip")
    private boolean skip = false;
    @Deprecated
    @Parameter(property="skipOriginalJarRename")
    boolean skipOriginalJarRename;
    @Parameter
    private Map<String, String> systemProperties = Collections.emptyMap();

    @Override
    protected boolean beforeExecute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping Quarkus build");
            return false;
        }
        if (this.mavenProject().getPackaging().equals("pom")) {
            this.getLog().info((CharSequence)"Type of the artifact is POM, skipping build goal");
            return false;
        }
        if (!this.mavenProject().getArtifact().getArtifactHandler().getExtension().equals("jar")) {
            throw new MojoExecutionException("The project artifact's extension is '" + this.mavenProject().getArtifact().getArtifactHandler().getExtension() + "' while this goal expects it be 'jar'");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute() throws MojoExecutionException {
        block19: {
            try {
                HashSet<String> propertiesToClear = new HashSet<String>();
                for (Map.Entry<String, String> entry : this.systemProperties.entrySet()) {
                    String key = entry.getKey();
                    if (System.getProperty(key) != null) continue;
                    System.setProperty(key, entry.getValue());
                    propertiesToClear.add(key);
                }
                if (!System.getProperties().containsKey(PACKAGE_TYPE_PROP) && this.isNativeProfileEnabled(this.mavenProject())) {
                    Object packageTypeProp = this.mavenProject().getProperties().get(PACKAGE_TYPE_PROP);
                    String packageType = "native";
                    if (packageTypeProp != null) {
                        packageType = packageTypeProp.toString();
                    }
                    System.setProperty(PACKAGE_TYPE_PROP, packageType);
                    propertiesToClear.add(PACKAGE_TYPE_PROP);
                }
                if (!propertiesToClear.isEmpty() && this.mavenSession().getRequest().getDegreeOfConcurrency() > 1) {
                    this.getLog().warn((CharSequence)"*****************************************************************");
                    this.getLog().warn((CharSequence)"* Your build is requesting parallel execution, but the project  *");
                    this.getLog().warn((CharSequence)"* relies on System properties at build time which could cause   *");
                    this.getLog().warn((CharSequence)"* race condition issues thus unpredictable build results.       *");
                    this.getLog().warn((CharSequence)"* Please avoid using System properties or avoid enabling        *");
                    this.getLog().warn((CharSequence)"* parallel execution                                            *");
                    this.getLog().warn((CharSequence)"*****************************************************************");
                }
                try (CuratedApplication curatedApplication = this.bootstrapApplication();){
                    Path standardJar;
                    AugmentAction action = curatedApplication.createAugmentor();
                    AugmentResult result = action.createProductionApplication();
                    Artifact original = this.mavenProject().getArtifact();
                    if (result.getJar() == null) break block19;
                    if (!this.skipOriginalJarRename && result.getJar().isUberJar() && result.getJar().getOriginalArtifact() != null && Files.exists(standardJar = result.getJar().getOriginalArtifact(), new LinkOption[0])) {
                        Path renamedOriginal = standardJar.getParent().toAbsolutePath().resolve(standardJar.getFileName() + ".original");
                        try {
                            IoUtils.recursiveDelete((Path)renamedOriginal);
                            Files.move(standardJar, renamedOriginal, new CopyOption[0]);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                        original.setFile(result.getJar().getOriginalArtifact().toFile());
                    }
                    if (result.getJar().isUberJar()) {
                        this.projectHelper.attachArtifact(this.mavenProject(), result.getJar().getPath().toFile(), result.getJar().getClassifier());
                    }
                }
                finally {
                    propertiesToClear.forEach(System::clearProperty);
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to build quarkus application", e);
            }
        }
    }

    private boolean isNativeProfileEnabled(MavenProject mavenProject) {
        Stream activeProfileIds = mavenProject.getInjectedProfileIds().values().stream().flatMap(Collection::stream);
        if (activeProfileIds.anyMatch("native"::equalsIgnoreCase)) {
            return true;
        }
        return Optional.ofNullable(mavenProject.getParent()).map(this::isNativeProfileEnabled).orElse(false);
    }

    @Override
    public void setLog(Log log) {
        super.setLog(log);
        MojoLogger.delegate = log;
    }
}

