/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.bootstrap.model.ApplicationModelBuilder;
import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.DefaultArtifactSources;
import io.quarkus.bootstrap.workspace.DefaultSourceDir;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.bootstrap.workspace.WorkspaceModuleId;
import io.quarkus.maven.dependency.GAV;
import java.nio.file.Path;
import java.util.ArrayList;
import org.apache.maven.model.Build;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;

class QuarkusMavenWorkspaceBuilder {
    QuarkusMavenWorkspaceBuilder() {
    }

    static void loadModules(MavenProject project, ApplicationModelBuilder modelBuilder) {
    }

    static WorkspaceModule toProjectModule(MavenProject project) {
        Build build = project.getBuild();
        WorkspaceModule.Mutable moduleBuilder = WorkspaceModule.builder().setModuleId(QuarkusMavenWorkspaceBuilder.getId(project)).setModuleDir(project.getBasedir().toPath()).setBuildDir(Path.of(build.getDirectory(), new String[0]));
        Path classesDir = Path.of(build.getOutputDirectory(), new String[0]);
        Path generatedSourcesDir = Path.of(build.getDirectory(), "generated-sources/annotations");
        ArrayList sources = new ArrayList(project.getCompileSourceRoots().size());
        project.getCompileSourceRoots().forEach(s -> sources.add(new DefaultSourceDir(Path.of(s, new String[0]), classesDir, generatedSourcesDir)));
        ArrayList<DefaultSourceDir> resources = new ArrayList<DefaultSourceDir>(build.getResources().size());
        for (Resource r : build.getResources()) {
            resources.add(new DefaultSourceDir(Path.of(r.getDirectory(), new String[0]), r.getTargetPath() == null ? classesDir : Path.of(r.getTargetPath(), new String[0]), null));
        }
        moduleBuilder.addArtifactSources((ArtifactSources)new DefaultArtifactSources("", sources, resources));
        Path testClassesDir = Path.of(build.getTestOutputDirectory(), new String[0]);
        ArrayList testSources = new ArrayList(project.getCompileSourceRoots().size());
        project.getTestCompileSourceRoots().forEach(s -> testSources.add(new DefaultSourceDir(Path.of(s, new String[0]), testClassesDir, null)));
        ArrayList<DefaultSourceDir> testResources = new ArrayList<DefaultSourceDir>(build.getTestResources().size());
        for (Resource r : build.getTestResources()) {
            testResources.add(new DefaultSourceDir(Path.of(r.getDirectory(), new String[0]), r.getTargetPath() == null ? testClassesDir : Path.of(r.getTargetPath(), new String[0]), null));
        }
        moduleBuilder.addArtifactSources((ArtifactSources)new DefaultArtifactSources("tests", testSources, testResources));
        moduleBuilder.setBuildFile(project.getFile().toPath());
        return moduleBuilder.build();
    }

    private static WorkspaceModuleId getId(MavenProject project) {
        return new GAV(project.getGroupId(), project.getArtifactId(), project.getVersion());
    }
}

