/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.devtools.commands.CreateExtension;
import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.project.QuarkusProjectHelper;
import io.quarkus.maven.CreateUtils;
import io.quarkus.maven.components.Prompter;
import io.quarkus.maven.utilities.MojoUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.fusesource.jansi.Ansi;
import org.jboss.logging.Logger;

@Mojo(name="create-extension", requiresProject=false)
public class CreateExtensionMojo
extends AbstractMojo {
    private static final Logger log = Logger.getLogger(CreateExtensionMojo.class);
    @Parameter(property="basedir")
    File basedir;
    @Parameter(property="extensionId")
    String extensionId;
    @Parameter(property="groupId")
    String groupId;
    @Parameter(property="quarkusVersion")
    String quarkusVersion;
    @Parameter(property="namespaceId")
    String namespaceId;
    @Parameter(property="version")
    String version;
    @Parameter(property="extensionName")
    String extensionName;
    @Parameter(property="extensionDescription")
    String extensionDescription;
    @Parameter(property="namespaceName")
    String namespaceName;
    @Parameter(property="packageName")
    String packageName;
    @Parameter(property="quarkusBomGroupId")
    String quarkusBomGroupId;
    @Parameter(property="quarkusBomArtifactId")
    String quarkusBomArtifactId;
    @Parameter(property="quarkusBomVersion")
    String quarkusBomVersion;
    @Parameter(property="withCodestart")
    boolean withCodestart;
    @Parameter(property="withoutUnitTest")
    boolean withoutUnitTest;
    @Parameter(property="withoutIntegrationTests")
    boolean withoutIntegrationTests;
    @Parameter(property="withoutDevModeTest")
    boolean withoutDevModeTest;
    @Parameter(property="withoutTests")
    boolean withoutTests;
    @Parameter(property="artifactId")
    String artifactId;
    @Parameter(defaultValue="${project}")
    protected MavenProject project;
    @Parameter(defaultValue="${session}")
    private MavenSession session;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    List<RemoteRepository> repos;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    RepositorySystemSession repoSession;
    @Component
    RepositorySystem repoSystem;
    @Component
    RemoteRepositoryManager remoteRepoManager;

    public void execute() throws MojoExecutionException {
        boolean success;
        if (!StringUtils.isBlank((CharSequence)this.artifactId) && StringUtils.isBlank((CharSequence)this.extensionId)) {
            this.getLog().warn((CharSequence)Ansi.ansi().a("the given 'artifactId' has been automatically converted to 'extensionId' for backward compatibility.").toString());
            if (this.artifactId.startsWith("quarkus-")) {
                this.namespaceId = "quarkus-";
                this.extensionId = this.artifactId.replace("quarkus-", "");
            } else {
                this.extensionId = this.artifactId;
            }
        }
        this.promptValues();
        this.autoComputeQuarkiverseExtensionId();
        try {
            MavenArtifactResolver resolver = ((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setRepositorySystem(this.repoSystem)).setRepositorySystemSession(this.getLog().isDebugEnabled() ? this.repoSession : MojoUtils.muteTransferListener((RepositorySystemSession)this.repoSession))).setRemoteRepositories(this.repos)).setRemoteRepositoryManager(this.remoteRepoManager)).build();
            QuarkusProjectHelper.setArtifactResolver((MavenArtifactResolver)resolver);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to initialize Maven artifact resolver", e);
        }
        CreateExtension createExtension = new CreateExtension(this.basedir.toPath()).extensionId(this.extensionId).extensionName(this.extensionName).extensionDescription(this.extensionDescription).groupId(this.groupId).version(this.version).packageName(this.packageName).namespaceId(this.namespaceId).namespaceName(this.namespaceName).quarkusVersion(this.quarkusVersion).quarkusBomGroupId(this.quarkusBomGroupId).quarkusBomArtifactId(this.quarkusBomArtifactId).quarkusBomGroupId(this.quarkusBomVersion).withCodestart(this.withCodestart).withoutUnitTest(this.withoutTests || this.withoutUnitTest).withoutDevModeTest(this.withoutTests || this.withoutDevModeTest).withoutIntegrationTests(this.withoutTests || this.withoutIntegrationTests);
        try {
            success = createExtension.execute().isSuccess();
        }
        catch (QuarkusCommandException e) {
            throw new MojoExecutionException("Failed to generate Extension", (Exception)((Object)e));
        }
        if (!success) {
            throw new MojoExecutionException("Failed to generate Extension");
        }
    }

    private void autoComputeQuarkiverseExtensionId() {
        if (CreateExtension.isQuarkiverseGroupId((String)this.groupId) && StringUtils.isEmpty((CharSequence)this.extensionId)) {
            this.extensionId = CreateExtension.extractQuarkiverseExtensionId((String)this.groupId);
        }
    }

    private String getPluginVersion() throws MojoExecutionException {
        return CreateUtils.resolvePluginInfo(CreateExtensionMojo.class).getVersion();
    }

    private void promptValues() throws MojoExecutionException {
        if (!this.session.getRequest().isInteractiveMode()) {
            return;
        }
        try {
            Prompter prompter = new Prompter();
            if (this.project == null || !this.project.getArtifactId().endsWith("quarkus-parent")) {
                if (StringUtils.isBlank((CharSequence)this.quarkusVersion)) {
                    this.quarkusVersion = this.getPluginVersion();
                }
                if (StringUtils.isBlank((CharSequence)this.groupId)) {
                    prompter.addPrompt("Set the extension groupId: ", "org.acme", input -> {
                        this.groupId = input;
                    });
                }
            }
            this.autoComputeQuarkiverseExtensionId();
            if (StringUtils.isBlank((CharSequence)this.extensionId)) {
                prompter.addPrompt("Set the extension id: ", input -> {
                    this.extensionId = input;
                });
            }
            prompter.collectInput();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to get user input", (Exception)e);
        }
    }
}

