/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.sns.runtime;

import io.quarkus.amazon.common.runtime.AwsConfig;
import io.quarkus.amazon.common.runtime.NettyHttpClientConfig;
import io.quarkus.amazon.common.runtime.SdkConfig;
import io.quarkus.amazon.common.runtime.SyncHttpClientConfig;
import io.quarkus.amazon.sns.runtime.SnsClientProducer;
import io.quarkus.amazon.sns.runtime.SnsConfig;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.services.sns.SnsAsyncClient;
import software.amazon.awssdk.services.sns.SnsAsyncClientBuilder;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.SnsClientBuilder;

@Recorder
public class SnsRecorder {
    public RuntimeValue<SyncHttpClientConfig> getSyncConfig(SnsConfig config) {
        return new RuntimeValue((Object)config.syncClient);
    }

    public RuntimeValue<NettyHttpClientConfig> getAsyncConfig(SnsConfig config) {
        return new RuntimeValue((Object)config.asyncClient);
    }

    public RuntimeValue<AwsConfig> getAwsConfig(SnsConfig config) {
        return new RuntimeValue((Object)config.aws);
    }

    public RuntimeValue<SdkConfig> getSdkConfig(SnsConfig config) {
        return new RuntimeValue((Object)config.sdk);
    }

    public RuntimeValue<AwsClientBuilder> createSyncBuilder(SnsConfig config, RuntimeValue<SdkHttpClient.Builder> transport) {
        SnsClientBuilder builder = SnsClient.builder();
        if (transport != null) {
            builder.httpClientBuilder((SdkHttpClient.Builder)transport.getValue());
        }
        return new RuntimeValue((Object)builder);
    }

    public RuntimeValue<AwsClientBuilder> createAsyncBuilder(SnsConfig config, RuntimeValue<SdkAsyncHttpClient.Builder> transport) {
        SnsAsyncClientBuilder builder = SnsAsyncClient.builder();
        if (transport != null) {
            builder.httpClientBuilder((SdkAsyncHttpClient.Builder)transport.getValue());
        }
        return new RuntimeValue((Object)builder);
    }

    public RuntimeValue<SnsClient> buildClient(RuntimeValue<? extends AwsClientBuilder> builder, BeanContainer beanContainer, ShutdownContext shutdown) {
        SnsClientProducer producer = (SnsClientProducer)beanContainer.instance(SnsClientProducer.class, new Annotation[0]);
        producer.setSyncConfiguredBuilder((SnsClientBuilder)builder.getValue());
        shutdown.addShutdownTask(producer::destroy);
        return new RuntimeValue((Object)producer.client());
    }

    public RuntimeValue<SnsAsyncClient> buildAsyncClient(RuntimeValue<? extends AwsClientBuilder> builder, BeanContainer beanContainer, ShutdownContext shutdown) {
        SnsClientProducer producer = (SnsClientProducer)beanContainer.instance(SnsClientProducer.class, new Annotation[0]);
        producer.setAsyncConfiguredBuilder((SnsAsyncClientBuilder)builder.getValue());
        shutdown.addShutdownTask(producer::destroy);
        return new RuntimeValue((Object)producer.asyncClient());
    }
}

