/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.awt.runtime;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

@TargetClass(className="sun.awt.FontConfiguration")
final class Target_sun_awt_FontConfiguration {
    @Alias
    protected static String osVersion;
    @Alias
    protected static String osName;

    Target_sun_awt_FontConfiguration() {
    }

    @Substitute
    protected void setOsNameAndVersion() {
        Path javaHome = Path.of(System.getProperty("java.io.tmpdir"), "quarkus-awt-tmp-fonts");
        try {
            Files.createDirectories(Path.of(javaHome.toString(), "conf", "fonts"), new FileAttribute[0]);
            Files.createDirectories(Path.of(javaHome.toString(), "lib"), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to set tmp java.home for FontConfig Quarkus AWT usage in " + javaHome, e);
        }
        System.setProperty("java.home", javaHome.toString());
        osName = System.getProperty("os.name");
        osVersion = System.getProperty("os.version");
    }
}

