/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.paths;

import io.quarkus.paths.OpenPathTree;
import io.quarkus.paths.PathFilter;
import io.quarkus.paths.PathTreeVisit;
import io.quarkus.paths.PathTreeWithManifest;
import io.quarkus.paths.PathVisit;
import io.quarkus.paths.PathVisitor;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;

public abstract class OpenContainerPathTree
extends PathTreeWithManifest
implements OpenPathTree {
    private static final boolean USE_WINDOWS_ABSOLUTE_PATH_PATTERN = !FileSystems.getDefault().getSeparator().equals("/");
    private static volatile Pattern windowsAbsolutePathPattern;
    protected PathFilter pathFilter;

    private static Pattern windowsAbsolutePathPattern() {
        return windowsAbsolutePathPattern == null ? (windowsAbsolutePathPattern = Pattern.compile("[a-zA-Z]:\\\\.*")) : windowsAbsolutePathPattern;
    }

    static boolean isAbsolutePath(String path) {
        return path != null && !path.isEmpty() && (path.charAt(0) == '/' || USE_WINDOWS_ABSOLUTE_PATH_PATTERN && OpenContainerPathTree.windowsAbsolutePathPattern().matcher(path).matches() || path.startsWith(FileSystems.getDefault().getSeparator()));
    }

    static void ensureResourcePath(FileSystem fs, String path) {
        if (OpenContainerPathTree.isAbsolutePath(path)) {
            throw new IllegalArgumentException("Expected a path relative to the root of the path tree but got " + path);
        }
        if (path != null && path.contains("..")) {
            for (Path pathElement : fs.getPath(path, new String[0])) {
                if (!pathElement.toString().equals("..")) continue;
                throw new IllegalArgumentException("'..' cannot be used in resource paths, but got " + path);
            }
        }
    }

    public OpenContainerPathTree() {
    }

    protected OpenContainerPathTree(PathFilter pathFilter) {
        this(pathFilter, false);
    }

    protected OpenContainerPathTree(PathFilter pathFilter, boolean manifestEnabled) {
        super(manifestEnabled);
        this.pathFilter = pathFilter;
    }

    protected OpenContainerPathTree(PathFilter pathFilter, PathTreeWithManifest pathTreeWithManifest) {
        super(pathTreeWithManifest);
        this.pathFilter = pathFilter;
    }

    protected abstract Path getContainerPath();

    protected abstract Path getRootPath();

    @Override
    public OpenPathTree open() {
        return this;
    }

    @Override
    public Collection<Path> getRoots() {
        return List.of(this.getRootPath());
    }

    @Override
    public void walk(PathVisitor visitor) {
        PathTreeVisit.walk(this.getRootPath(), this.getRootPath(), this.pathFilter, this.getMultiReleaseMapping(), visitor);
    }

    private void ensureResourcePath(String path) {
        OpenContainerPathTree.ensureResourcePath(this.getRootPath().getFileSystem(), path);
    }

    @Override
    protected <T> T apply(String relativePath, Function<PathVisit, T> func, boolean manifestEnabled) {
        this.ensureResourcePath(relativePath);
        if (!PathFilter.isVisible(this.pathFilter, relativePath)) {
            return func.apply(null);
        }
        Path path = this.getRootPath().resolve(manifestEnabled ? this.toMultiReleaseRelativePath(relativePath) : relativePath);
        if (!Files.exists(path, new LinkOption[0])) {
            return func.apply(null);
        }
        return PathTreeVisit.process(this.getRootPath(), this.getRootPath(), path, this.pathFilter, func);
    }

    @Override
    public void accept(String relativePath, Consumer<PathVisit> consumer) {
        this.ensureResourcePath(relativePath);
        if (!PathFilter.isVisible(this.pathFilter, relativePath)) {
            consumer.accept(null);
            return;
        }
        Path path = this.getRootPath().resolve(this.manifestEnabled ? this.toMultiReleaseRelativePath(relativePath) : relativePath);
        if (!Files.exists(path, new LinkOption[0])) {
            consumer.accept(null);
            return;
        }
        PathTreeVisit.consume(this.getRootPath(), this.getRootPath(), path, this.pathFilter, consumer);
    }

    @Override
    public boolean contains(String relativePath) {
        this.ensureResourcePath(relativePath);
        if (!PathFilter.isVisible(this.pathFilter, relativePath)) {
            return false;
        }
        Path path = this.getRootPath().resolve(this.manifestEnabled ? this.toMultiReleaseRelativePath(relativePath) : relativePath);
        return Files.exists(path, new LinkOption[0]);
    }

    @Override
    public Path getPath(String relativePath) {
        this.ensureResourcePath(relativePath);
        if (!PathFilter.isVisible(this.pathFilter, relativePath)) {
            return null;
        }
        Path path = this.getRootPath().resolve(this.manifestEnabled ? this.toMultiReleaseRelativePath(relativePath) : relativePath);
        return Files.exists(path, new LinkOption[0]) ? path : null;
    }

    public int hashCode() {
        return Objects.hash(this.getContainerPath(), this.pathFilter, this.manifestEnabled);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OpenContainerPathTree other = (OpenContainerPathTree)obj;
        return Objects.equals(this.getContainerPath(), other.getContainerPath()) && Objects.equals(this.pathFilter, other.pathFilter) && this.manifestEnabled == other.manifestEnabled;
    }
}

