/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import io.quarkus.bootstrap.model.MutableBaseJvmOption;
import java.util.List;

public class MutableXxJvmOption
extends MutableBaseJvmOption<MutableXxJvmOption> {
    public static final String PROPERTY_GROUP_PREFIX = "xx.";
    private static final String COMPLETE_PROPERTY_PREFIX = "dev-mode.jvm-option.xx.";
    private static final String DASH_XX_COLLON = "-XX:";

    public static MutableXxJvmOption fromQuarkusExtensionProperty(String propertyName, String value) {
        String optionName = propertyName.substring(COMPLETE_PROPERTY_PREFIX.length());
        return value.isBlank() ? MutableXxJvmOption.newInstance(optionName) : MutableXxJvmOption.newInstance(optionName, value);
    }

    public static MutableXxJvmOption newInstance(String name) {
        return MutableXxJvmOption.newInstance(name, null);
    }

    public static MutableXxJvmOption newInstance(String name, String value) {
        MutableXxJvmOption result = new MutableXxJvmOption();
        result.setName(name);
        if (value != null) {
            result.addValue(value);
        }
        return result;
    }

    @Override
    protected String getQuarkusExtensionPropertyPrefix() {
        return COMPLETE_PROPERTY_PREFIX;
    }

    @Override
    public List<String> toCliOptions() {
        if (!this.hasValue()) {
            return this.toBooleanOption(true);
        }
        if (this.getValues().size() == 1) {
            String value = this.getValues().iterator().next();
            if ("true".equalsIgnoreCase(value) || "+".equals(value)) {
                return this.toBooleanOption(true);
            }
            if ("false".equalsIgnoreCase(value) || "-".equals(value)) {
                return this.toBooleanOption(false);
            }
            return List.of(DASH_XX_COLLON + this.getName() + "=" + value);
        }
        throw new IllegalArgumentException("Failed to format option -XX:" + this.getName() + " with values " + this.getValues());
    }

    private List<String> toBooleanOption(boolean enabled) {
        return List.of(DASH_XX_COLLON + (enabled ? "+" : "-") + this.getName());
    }
}

