/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver;

import io.quarkus.bootstrap.BootstrapDependencyProcessingException;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.model.ApplicationModelBuilder;
import io.quarkus.bootstrap.model.PlatformImports;
import io.quarkus.bootstrap.model.PlatformImportsImpl;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.BuildDependencyGraphVisitor;
import io.quarkus.bootstrap.resolver.maven.DeploymentInjectingDependencyVisitor;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.SimpleDependencyGraphTransformationContext;
import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.ResolvableDependency;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.maven.dependency.ResolvedDependencyBuilder;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyGraphTransformationContext;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.util.graph.transformer.ConflictIdSorter;
import org.eclipse.aether.util.graph.transformer.ConflictMarker;
import org.eclipse.aether.util.graph.visitor.TreeDependencyVisitor;
import org.eclipse.aether.version.Version;

public class BootstrapAppModelResolver
implements AppModelResolver {
    protected final MavenArtifactResolver mvn;
    protected Consumer<String> buildTreeConsumer;
    protected boolean devmode;
    protected boolean test;
    private boolean collectReloadableDeps = true;

    public BootstrapAppModelResolver(MavenArtifactResolver mvn) {
        this.mvn = mvn;
    }

    public void setBuildTreeLogger(Consumer<String> buildTreeConsumer) {
        this.buildTreeConsumer = buildTreeConsumer;
    }

    public BootstrapAppModelResolver setDevMode(boolean devmode) {
        this.devmode = devmode;
        return this;
    }

    public BootstrapAppModelResolver setTest(boolean test) {
        this.test = test;
        return this;
    }

    public BootstrapAppModelResolver setCollectReloadableDependencies(boolean collectReloadableDeps) {
        this.collectReloadableDeps = collectReloadableDeps;
        return this;
    }

    public void addRemoteRepositories(List<RemoteRepository> repos) {
        this.mvn.addRemoteRepositories(repos);
    }

    public void relink(ArtifactCoords artifact, Path path) throws AppModelResolverException {
        if (this.mvn.getLocalRepositoryManager() == null) {
            return;
        }
        this.mvn.getLocalRepositoryManager().relink(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getType(), artifact.getVersion(), path);
        if (artifact instanceof ResolvableDependency) {
            ((ResolvableDependency)artifact).setResolvedPaths((PathCollection)PathList.of((Path[])new Path[]{path}));
        }
    }

    public ResolvedDependency resolve(ArtifactCoords artifact) throws AppModelResolverException {
        return this.resolve(artifact, BootstrapAppModelResolver.toAetherArtifact(artifact), Collections.emptyList());
    }

    public Collection<ResolvedDependency> resolveUserDependencies(ArtifactCoords appArtifact, Collection<io.quarkus.maven.dependency.Dependency> deps) throws AppModelResolverException {
        List<Dependency> mvnDeps;
        if (deps.isEmpty()) {
            mvnDeps = Collections.emptyList();
        } else {
            mvnDeps = new ArrayList(deps.size());
            for (io.quarkus.maven.dependency.Dependency dep : deps) {
                mvnDeps.add(new Dependency(BootstrapAppModelResolver.toAetherArtifact((ArtifactCoords)dep), dep.getScope()));
            }
        }
        final ArrayList<ResolvedDependency> result = new ArrayList<ResolvedDependency>();
        TreeDependencyVisitor visitor = new TreeDependencyVisitor(new DependencyVisitor(){

            public boolean visitEnter(DependencyNode node) {
                return true;
            }

            public boolean visitLeave(DependencyNode node) {
                Dependency dep = node.getDependency();
                if (dep != null) {
                    result.add(((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)BootstrapAppModelResolver.this.toAppArtifact(dep.getArtifact()).setScope(dep.getScope())).setOptional(dep.isOptional())).build());
                }
                return true;
            }
        });
        this.mvn.resolveDependencies(BootstrapAppModelResolver.toAetherArtifact(appArtifact), mvnDeps).getRoot().accept((DependencyVisitor)visitor);
        return result;
    }

    public ApplicationModel resolveModel(ArtifactCoords appArtifact) throws AppModelResolverException {
        return this.resolveManagedModel(appArtifact, Collections.emptyList(), null, Collections.emptySet());
    }

    public ApplicationModel resolveModel(ArtifactCoords appArtifact, Collection<io.quarkus.maven.dependency.Dependency> directDeps) throws AppModelResolverException {
        return this.resolveManagedModel(appArtifact, directDeps, null, Collections.emptySet());
    }

    public ApplicationModel resolveManagedModel(ArtifactCoords appArtifact, Collection<io.quarkus.maven.dependency.Dependency> directDeps, ArtifactCoords managingProject, Set<ArtifactKey> reloadableModules) throws AppModelResolverException {
        return this.doResolveModel(appArtifact, BootstrapAppModelResolver.toAetherDeps(directDeps), managingProject, reloadableModules);
    }

    public ApplicationModel resolveModel(WorkspaceModule module) throws AppModelResolverException {
        DependencyNode rootNode;
        PathList.Builder resolvedPaths = PathList.builder();
        if (module.hasMainSources()) {
            if (!module.getMainSources().isOutputAvailable()) {
                throw new AppModelResolverException("The application module hasn't been built yet");
            }
            module.getMainSources().getSourceDirs().forEach(s -> {
                if (!resolvedPaths.contains(s.getOutputDir())) {
                    resolvedPaths.add(s.getOutputDir());
                }
            });
            module.getMainSources().getResourceDirs().forEach(s -> {
                if (!resolvedPaths.contains(s.getOutputDir())) {
                    resolvedPaths.add(s.getOutputDir());
                }
            });
        }
        DefaultArtifact mainArtifact = new DefaultArtifact(module.getId().getGroupId(), module.getId().getArtifactId(), null, "jar", module.getId().getVersion());
        ResolvedDependency mainDep = ((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)ResolvedDependencyBuilder.newInstance().setGroupId(mainArtifact.getGroupId())).setArtifactId(mainArtifact.getArtifactId())).setClassifier(mainArtifact.getClassifier())).setType(mainArtifact.getExtension())).setVersion(mainArtifact.getVersion())).setResolvedPaths((PathCollection)resolvedPaths.build()).setWorkspaceModule(module).build();
        HashMap<ArtifactKey, Dependency> managedMap = new HashMap<ArtifactKey, Dependency>();
        for (Object d : module.getDirectDependencyConstraints()) {
            if (d.getScope().equals("import")) {
                this.mvn.resolveDescriptor(BootstrapAppModelResolver.toAetherArtifact((ArtifactCoords)d)).getManagedDependencies().forEach(dep -> managedMap.putIfAbsent(BootstrapAppModelResolver.getKey(dep.getArtifact()), (Dependency)dep));
                continue;
            }
            managedMap.put(d.getKey(), new Dependency(BootstrapAppModelResolver.toAetherArtifact((ArtifactCoords)d), d.getScope(), Boolean.valueOf(d.isOptional())));
        }
        ArrayList<Dependency> directDeps = new ArrayList<Dependency>(module.getDirectDependencies().size());
        for (io.quarkus.maven.dependency.Dependency d : module.getDirectDependencies()) {
            String version = d.getVersion();
            if (version == null) {
                Dependency constraint = (Dependency)managedMap.get(d.getKey());
                if (constraint == null) {
                    throw new AppModelResolverException(d.toCompactCoords() + " is missing version and is not found among the dependency constraints");
                }
                version = constraint.getArtifact().getVersion();
            }
            directDeps.add(new Dependency((Artifact)new DefaultArtifact(d.getGroupId(), d.getArtifactId(), d.getClassifier(), d.getType(), version), d.getScope(), Boolean.valueOf(d.isOptional())));
        }
        ArrayList<Dependency> constraints = managedMap.isEmpty() ? Collections.emptyList() : new ArrayList<Dependency>(managedMap.values());
        CollectRequest request = new CollectRequest().setDependencies(directDeps).setManagedDependencies(constraints).setRepositories(this.mvn.getRepositories()).setRootArtifact((Artifact)mainArtifact);
        try {
            rootNode = this.mvn.getSystem().resolveDependencies(this.mvn.getSession(), new DependencyRequest().setCollectRequest(request)).getRoot();
        }
        catch (DependencyResolutionException e) {
            throw new AppModelResolverException("Failed to resolve application dependencies", (Throwable)e);
        }
        return this.buildAppModel(mainDep, rootNode, Collections.emptySet(), constraints, this.mvn.getRepositories());
    }

    private ApplicationModel doResolveModel(ArtifactCoords coords, List<Dependency> directMvnDeps, ArtifactCoords managingProject, Set<ArtifactKey> reloadableModules) throws AppModelResolverException {
        if (coords == null) {
            throw new IllegalArgumentException("Application artifact is null");
        }
        Artifact mvnArtifact = BootstrapAppModelResolver.toAetherArtifact(coords);
        ArrayList<Dependency> managedDeps = Collections.emptyList();
        List<RemoteRepository> managedRepos = Collections.emptyList();
        if (managingProject != null) {
            ArtifactDescriptorResult managingDescr = this.mvn.resolveDescriptor(BootstrapAppModelResolver.toAetherArtifact(managingProject));
            managedDeps = managingDescr.getManagedDependencies();
            managedRepos = this.mvn.newResolutionRepositories(managingDescr.getRepositories());
        }
        ResolvedDependency appArtifact = this.resolve(coords, mvnArtifact, managedRepos);
        List<Object> excludedScopes = this.test ? Collections.emptyList() : (this.devmode ? Collections.singletonList("test") : List.of("provided", "test"));
        DependencyNode resolvedDeps = this.mvn.resolveManagedDependencies(mvnArtifact, directMvnDeps, (List<Dependency>)managedDeps, managedRepos, excludedScopes.toArray(new String[0])).getRoot();
        ArtifactDescriptorResult appArtifactDescr = this.mvn.resolveDescriptor(BootstrapAppModelResolver.toAetherArtifact((ArtifactCoords)appArtifact));
        if (managingProject == null) {
            managedDeps = appArtifactDescr.getManagedDependencies();
        } else {
            ArrayList<Dependency> mergedManagedDeps = new ArrayList<Dependency>(managedDeps.size());
            HashSet<ArtifactKey> mergedKeys = new HashSet<ArtifactKey>(managedDeps.size());
            for (Dependency dep : managedDeps) {
                mergedKeys.add(BootstrapAppModelResolver.getKey(dep.getArtifact()));
                mergedManagedDeps.add(dep);
            }
            for (Dependency dep : appArtifactDescr.getManagedDependencies()) {
                Artifact artifact = dep.getArtifact();
                if (mergedKeys.contains(BootstrapAppModelResolver.getKey(artifact))) continue;
                mergedManagedDeps.add(dep);
            }
            managedDeps = mergedManagedDeps;
        }
        List<RemoteRepository> repos = this.mvn.aggregateRepositories(managedRepos, this.mvn.newResolutionRepositories(appArtifactDescr.getRepositories()));
        return this.buildAppModel(appArtifact, resolvedDeps, reloadableModules, (List<Dependency>)managedDeps, repos);
    }

    private ApplicationModel buildAppModel(ResolvedDependency appArtifact, DependencyNode resolvedDeps, Set<ArtifactKey> reloadableModules, List<Dependency> managedDeps, List<RemoteRepository> repos) throws AppModelResolverException, BootstrapMavenException {
        DeploymentInjectingDependencyVisitor deploymentInjector;
        ApplicationModelBuilder appBuilder = new ApplicationModelBuilder().setAppArtifact(appArtifact);
        if (appArtifact.getWorkspaceModule() != null) {
            appBuilder.addReloadableWorkspaceModule(appArtifact.getKey());
        }
        if (!reloadableModules.isEmpty()) {
            appBuilder.addReloadableWorkspaceModules(reloadableModules);
        }
        try {
            deploymentInjector = new DeploymentInjectingDependencyVisitor(this.mvn, managedDeps, repos, appBuilder, this.collectReloadableDeps && reloadableModules.isEmpty());
            deploymentInjector.injectDeploymentDependencies(resolvedDeps);
        }
        catch (BootstrapDependencyProcessingException e) {
            throw new AppModelResolverException("Failed to inject extension deployment dependencies for " + resolvedDeps.getArtifact(), (Throwable)((Object)e));
        }
        if (deploymentInjector.isInjectedDeps()) {
            SimpleDependencyGraphTransformationContext context = new SimpleDependencyGraphTransformationContext(this.mvn.getSession());
            try {
                resolvedDeps = new ConflictMarker().transformGraph(resolvedDeps, (DependencyGraphTransformationContext)context);
                resolvedDeps = new ConflictIdSorter().transformGraph(resolvedDeps, (DependencyGraphTransformationContext)context);
                resolvedDeps = this.mvn.getSession().getDependencyGraphTransformer().transformGraph(resolvedDeps, (DependencyGraphTransformationContext)context);
            }
            catch (RepositoryException e) {
                throw new AppModelResolverException("Failed to normalize the dependency graph", (Throwable)e);
            }
            BuildDependencyGraphVisitor buildDepsVisitor = new BuildDependencyGraphVisitor(deploymentInjector.allRuntimeDeps, this.buildTreeConsumer);
            buildDepsVisitor.visit(resolvedDeps);
            List<ArtifactRequest> requests = buildDepsVisitor.getArtifactRequests();
            if (!requests.isEmpty()) {
                List<ArtifactResult> results = this.mvn.resolve(requests);
                for (ArtifactResult result : results) {
                    Artifact artifact = result.getArtifact();
                    if (artifact == null) continue;
                    result.getRequest().getDependencyNode().setArtifact(artifact);
                }
                List<DependencyNode> deploymentDepNodes = buildDepsVisitor.getDeploymentNodes();
                for (DependencyNode dep : deploymentDepNodes) {
                    int flags = 8;
                    if (dep.getDependency().isOptional()) {
                        flags |= 1;
                    }
                    WorkspaceModule module = null;
                    if (this.mvn.getProjectModuleResolver() != null && (module = this.mvn.getProjectModuleResolver().getProjectModule(dep.getArtifact().getGroupId(), dep.getArtifact().getArtifactId())) != null) {
                        flags |= 0x20;
                    }
                    appBuilder.addDependency(((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)this.toAppArtifact(dep.getArtifact(), module).setScope(dep.getDependency().getScope())).setFlags(flags)).build());
                }
            }
        }
        this.collectPlatformProperties(appBuilder, managedDeps);
        return appBuilder.build();
    }

    private ResolvedDependency resolve(ArtifactCoords appArtifact, Artifact mvnArtifact, List<RemoteRepository> managedRepos) throws BootstrapMavenException {
        ArtifactSources artifactSources;
        WorkspaceModule resolvedModule;
        ResolvedDependency resolvedArtifact;
        ResolvedDependency resolvedDependency = resolvedArtifact = ResolvedDependency.class.isAssignableFrom(appArtifact.getClass()) ? (ResolvedDependency)appArtifact : null;
        if (resolvedArtifact != null && (resolvedArtifact.getWorkspaceModule() != null || this.mvn.getProjectModuleResolver() == null)) {
            return resolvedArtifact;
        }
        WorkspaceModule workspaceModule = resolvedModule = this.mvn.getProjectModuleResolver() == null ? null : this.mvn.getProjectModuleResolver().getProjectModule(appArtifact.getGroupId(), appArtifact.getArtifactId());
        if (resolvedArtifact != null && resolvedModule == null) {
            return resolvedArtifact;
        }
        Object resolvedPaths = null;
        if ((this.devmode || this.test) && resolvedModule != null && (artifactSources = resolvedModule.getSources(appArtifact.getClassifier())) != null) {
            PathList.Builder pathBuilder = PathList.builder();
            BootstrapAppModelResolver.collectSourceDirs(pathBuilder, artifactSources.getSourceDirs());
            BootstrapAppModelResolver.collectSourceDirs(pathBuilder, artifactSources.getResourceDirs());
            if (!pathBuilder.isEmpty()) {
                resolvedPaths = pathBuilder.build();
            }
        }
        if (resolvedPaths == null) {
            resolvedPaths = resolvedArtifact == null || resolvedArtifact.getResolvedPaths() == null ? PathList.of((Path[])new Path[]{this.mvn.resolve(mvnArtifact, managedRepos).getArtifact().getFile().toPath()}) : resolvedArtifact.getResolvedPaths();
        }
        return ((ResolvedDependencyBuilder)ResolvedDependencyBuilder.newInstance().setCoords(appArtifact)).setWorkspaceModule(resolvedModule).setResolvedPaths(resolvedPaths).build();
    }

    private static void collectSourceDirs(PathList.Builder pathBuilder, Collection<SourceDir> resources) {
        for (SourceDir src : resources) {
            Path p;
            if (!Files.exists(src.getOutputDir(), new LinkOption[0]) || pathBuilder.contains(p = src.getOutputDir())) continue;
            pathBuilder.add(p);
        }
    }

    private void collectPlatformProperties(ApplicationModelBuilder appBuilder, List<Dependency> managedDeps) throws AppModelResolverException {
        PlatformImportsImpl platformReleases = new PlatformImportsImpl();
        for (Dependency d : managedDeps) {
            Artifact artifact = d.getArtifact();
            String extension = artifact.getExtension();
            String artifactId = artifact.getArtifactId();
            if ("json".equals(extension) && artifactId.endsWith("-quarkus-platform-descriptor")) {
                platformReleases.addPlatformDescriptor(artifact.getGroupId(), artifactId, artifact.getClassifier(), extension, artifact.getVersion());
                continue;
            }
            if (!"properties".equals(artifact.getExtension()) || !artifactId.endsWith("-quarkus-platform-properties")) continue;
            platformReleases.addPlatformProperties(artifact.getGroupId(), artifactId, artifact.getClassifier(), extension, artifact.getVersion(), this.mvn.resolve(artifact).getArtifact().getFile().toPath());
        }
        appBuilder.setPlatformImports((PlatformImports)platformReleases);
    }

    public List<String> listLaterVersions(ArtifactCoords appArtifact, String upToVersion, boolean inclusive) throws AppModelResolverException {
        VersionRangeResult rangeResult = this.resolveVersionRangeResult(appArtifact, appArtifact.getVersion(), false, upToVersion, inclusive);
        List resolvedVersions = rangeResult.getVersions();
        ArrayList<String> versions = new ArrayList<String>(resolvedVersions.size());
        for (Version v : resolvedVersions) {
            versions.add(v.toString());
        }
        return versions;
    }

    public String getNextVersion(ArtifactCoords appArtifact, String fromVersion, boolean fromVersionIncluded, String upToVersion, boolean upToVersionInclusive) throws AppModelResolverException {
        VersionRangeResult rangeResult = this.resolveVersionRangeResult(appArtifact, fromVersion, fromVersionIncluded, upToVersion, upToVersionInclusive);
        return this.getEarliest(rangeResult);
    }

    public String getLatestVersion(ArtifactCoords appArtifact, String upToVersion, boolean inclusive) throws AppModelResolverException {
        VersionRangeResult rangeResult = this.resolveVersionRangeResult(appArtifact, appArtifact.getVersion(), false, upToVersion, inclusive);
        String latest = this.getLatest(rangeResult);
        return latest == null ? appArtifact.getVersion() : latest;
    }

    public String getLatestVersionFromRange(ArtifactCoords appArtifact, String range) throws AppModelResolverException {
        VersionRangeResult rangeResult = this.resolveVersionRangeResult(appArtifact, range);
        return this.getLatest(rangeResult);
    }

    public List<RemoteRepository> resolveArtifactRepos(ArtifactCoords appArtifact) throws AppModelResolverException {
        return this.mvn.resolveDescriptor(BootstrapAppModelResolver.toAetherArtifact(appArtifact)).getRepositories();
    }

    public void install(ArtifactCoords artifact, Path localPath) throws AppModelResolverException {
        this.mvn.install((Artifact)new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getType(), artifact.getVersion(), Collections.emptyMap(), localPath.toFile()));
    }

    private static ArtifactKey getKey(Artifact artifact) {
        return DeploymentInjectingDependencyVisitor.getKey(artifact);
    }

    private String getEarliest(VersionRangeResult rangeResult) {
        List versions = rangeResult.getVersions();
        if (versions.isEmpty()) {
            return null;
        }
        Version next = (Version)versions.get(0);
        for (int i = 1; i < versions.size(); ++i) {
            Version candidate = (Version)versions.get(i);
            if (next.compareTo((Object)candidate) <= 0) continue;
            next = candidate;
        }
        return next.toString();
    }

    private String getLatest(VersionRangeResult rangeResult) {
        List versions = rangeResult.getVersions();
        if (versions.isEmpty()) {
            return null;
        }
        Version next = (Version)versions.get(0);
        for (int i = 1; i < versions.size(); ++i) {
            Version candidate = (Version)versions.get(i);
            if (candidate.compareTo((Object)next) <= 0) continue;
            next = candidate;
        }
        return next.toString();
    }

    private VersionRangeResult resolveVersionRangeResult(ArtifactCoords appArtifact, String fromVersion, boolean fromVersionIncluded, String upToVersion, boolean upToVersionIncluded) throws AppModelResolverException {
        return this.resolveVersionRangeResult(appArtifact, (fromVersionIncluded ? (char)'[' : '(') + (String)(fromVersion == null ? "" : fromVersion + ",") + (Serializable)(upToVersion == null ? Character.valueOf(')') : upToVersion + (upToVersionIncluded ? (char)']' : ')')));
    }

    private VersionRangeResult resolveVersionRangeResult(ArtifactCoords appArtifact, String range) throws AppModelResolverException {
        return this.mvn.resolveVersionRange((Artifact)new DefaultArtifact(appArtifact.getGroupId(), appArtifact.getArtifactId(), appArtifact.getType(), range));
    }

    private static Artifact toAetherArtifact(ArtifactCoords artifact) {
        return new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getType(), artifact.getVersion());
    }

    private ResolvedDependencyBuilder toAppArtifact(Artifact artifact) {
        return this.toAppArtifact(artifact, null);
    }

    private ResolvedDependencyBuilder toAppArtifact(Artifact artifact, WorkspaceModule module) {
        return DeploymentInjectingDependencyVisitor.toAppArtifact(artifact, module);
    }

    private static List<Dependency> toAetherDeps(Collection<io.quarkus.maven.dependency.Dependency> directDeps) {
        if (directDeps.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Dependency> directMvnDeps = new ArrayList<Dependency>(directDeps.size());
        for (io.quarkus.maven.dependency.Dependency dep : directDeps) {
            directMvnDeps.add(new Dependency(BootstrapAppModelResolver.toAetherArtifact((ArtifactCoords)dep), dep.getScope()));
        }
        return directMvnDeps;
    }
}

