/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import io.quarkus.bootstrap.BootstrapDependencyProcessingException;
import io.quarkus.bootstrap.model.ApplicationModelBuilder;
import io.quarkus.bootstrap.model.CapabilityContract;
import io.quarkus.bootstrap.model.ExtensionCapabilities;
import io.quarkus.bootstrap.util.BootstrapUtils;
import io.quarkus.bootstrap.util.DependencyUtils;
import io.quarkus.maven.dependency.ArtifactKey;
import java.util.Arrays;
import java.util.Properties;
import org.eclipse.aether.artifact.Artifact;

class ExtensionInfo {
    final Artifact runtimeArtifact;
    final Properties props;
    final Artifact deploymentArtifact;
    final Artifact[] conditionalDeps;
    final ArtifactKey[] dependencyCondition;
    boolean activated;

    ExtensionInfo() {
        this.runtimeArtifact = null;
        this.props = null;
        this.deploymentArtifact = null;
        this.conditionalDeps = null;
        this.dependencyCondition = null;
    }

    ExtensionInfo(Artifact runtimeArtifact, Properties props, boolean devMode) throws BootstrapDependencyProcessingException {
        this.runtimeArtifact = runtimeArtifact;
        this.props = props;
        this.deploymentArtifact = ExtensionInfo.initDeploymentArtifact(props.getProperty("deployment-artifact"), runtimeArtifact);
        this.conditionalDeps = this.initConditionalDeps(devMode);
        this.dependencyCondition = BootstrapUtils.parseDependencyCondition((String)props.getProperty("dependency-condition"));
    }

    void ensureActivated(ApplicationModelBuilder appBuilder) {
        if (this.activated) {
            return;
        }
        this.activated = true;
        appBuilder.handleExtensionProperties(this.props, DependencyUtils.getKey(this.runtimeArtifact));
        String providesCapabilities = this.props.getProperty("provides-capabilities");
        String requiresCapabilities = this.props.getProperty("requires-capabilities");
        if (providesCapabilities != null || requiresCapabilities != null) {
            appBuilder.addExtensionCapabilities((ExtensionCapabilities)CapabilityContract.of((String)ExtensionInfo.toCompactCoords(this.runtimeArtifact), (String)providesCapabilities, (String)requiresCapabilities));
        }
    }

    private static Artifact initDeploymentArtifact(String deploymentArtifactStr, Artifact runtimeArtifact) throws BootstrapDependencyProcessingException {
        if (deploymentArtifactStr == null) {
            throw new BootstrapDependencyProcessingException("Extension descriptor from " + runtimeArtifact + " does not include deployment-artifact");
        }
        Artifact deploymentArtifact = DependencyUtils.toArtifact(deploymentArtifactStr);
        return deploymentArtifact.getVersion() == null || deploymentArtifact.getVersion().isEmpty() ? deploymentArtifact.setVersion(runtimeArtifact.getVersion()) : deploymentArtifact;
    }

    private Artifact[] initConditionalDeps(boolean devMode) throws BootstrapDependencyProcessingException {
        return devMode ? ExtensionInfo.toArtifactArray(ExtensionInfo.joinAndDedupe(ExtensionInfo.splitConditionalDeps(this.props.getProperty("conditional-dependencies")), ExtensionInfo.splitConditionalDeps(this.props.getProperty("conditional-dev-dependencies"))), this.runtimeArtifact) : ExtensionInfo.toArtifactArray(ExtensionInfo.splitConditionalDeps(this.props.getProperty("conditional-dependencies")), this.runtimeArtifact);
    }

    private static Artifact[] toArtifactArray(String[] strArr, Artifact runtimeArtifact) throws BootstrapDependencyProcessingException {
        Artifact[] artifactArr = new Artifact[strArr.length];
        for (int i = 0; i < strArr.length; ++i) {
            try {
                artifactArr[i] = DependencyUtils.toArtifact(strArr[i]);
                continue;
            }
            catch (Exception e) {
                throw new BootstrapDependencyProcessingException("Failed to parse conditional dependencies configuration of " + runtimeArtifact, e);
            }
        }
        return artifactArr;
    }

    private static String[] splitConditionalDeps(String conditionalDepsStr) {
        return conditionalDepsStr == null ? new String[]{} : BootstrapUtils.splitByWhitespace((String)conditionalDepsStr);
    }

    private static String[] joinAndDedupe(String[] arr1, String[] arr2) {
        if (arr1.length == 0) {
            return arr2;
        }
        if (arr2.length == 0) {
            return arr1;
        }
        if (arr1.length == 1) {
            String[] result = new String[arr2.length + 1];
            result[0] = arr1[0];
            for (int i = 0; i < arr2.length; ++i) {
                result[1 + i] = arr2[i];
            }
            return result;
        }
        String[] result = new String[arr1.length + arr2.length];
        System.arraycopy(arr1, 0, result, 0, arr1.length);
        int resultSize = arr1.length;
        for (int i = 0; i < arr2.length; ++i) {
            String e = arr2[i];
            if (ExtensionInfo.contains(arr1, e)) continue;
            result[resultSize++] = e;
        }
        return result.length == resultSize ? result : Arrays.copyOf(result, resultSize);
    }

    private static <T> boolean contains(T[] arr, T item) {
        for (int i = 0; i < arr.length; ++i) {
            if (!item.equals(arr[i])) continue;
            return true;
        }
        return false;
    }

    private static String toCompactCoords(Artifact a) {
        StringBuilder b = new StringBuilder();
        b.append(a.getGroupId()).append(':').append(a.getArtifactId()).append(':');
        if (!a.getClassifier().isEmpty()) {
            b.append(a.getClassifier()).append(':');
        }
        if (!"jar".equals(a.getExtension())) {
            b.append(a.getExtension()).append(':');
        }
        b.append(a.getVersion());
        return b.toString();
    }
}

