/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.runner;

import io.quarkus.bootstrap.runner.ClassLoadingResource;
import io.quarkus.bootstrap.runner.ManifestInfo;
import io.smallrye.common.io.jar.JarEntries;
import io.smallrye.common.io.jar.JarFiles;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarResource
implements ClassLoadingResource {
    private final ManifestInfo manifestInfo;
    private final Path jarPath;
    private final Lock readLock;
    private final Lock writeLock;
    private volatile JarFile zipFile;

    public JarResource(ManifestInfo manifestInfo, Path jarPath) {
        this.manifestInfo = manifestInfo;
        this.jarPath = jarPath;
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] getResourceData(String resource) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public URL getResourceURL(String resource) {
        JarFile jarFile = this.readLockAcquireAndGetJarReference();
        try {
            JarEntry entry = jarFile.getJarEntry(resource);
            if (entry == null) {
                URL uRL = null;
                return uRL;
            }
            String realName = JarEntries.getRealName((JarEntry)entry);
            if (realName.endsWith("/")) {
                realName = realName.substring(0, realName.length() - 1);
            }
            URI jarUri = this.jarPath.toUri();
            URL uRL = new URL("jar", null, jarUri.getScheme() + ':' + jarUri.getPath() + "!/" + resource);
            return uRL;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public ManifestInfo getManifestInfo() {
        return this.manifestInfo;
    }

    @Override
    public ProtectionDomain getProtectionDomain(ClassLoader classLoader) {
        URL url;
        try {
            String path = this.jarPath.toAbsolutePath().toString();
            if (!path.startsWith("/")) {
                path = '/' + path;
            }
            URI uri = new URI("file", null, path, null);
            url = uri.toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException("Unable to create protection domain for " + this.jarPath, e);
        }
        CodeSource codesource = new CodeSource(url, (Certificate[])null);
        return new ProtectionDomain(codesource, null, classLoader, null);
    }

    private JarFile readLockAcquireAndGetJarReference() {
        while (true) {
            this.readLock.lock();
            JarFile zipFileLocal = this.zipFile;
            if (zipFileLocal != null) {
                return zipFileLocal;
            }
            this.readLock.unlock();
            this.ensureJarFileIsOpen();
        }
    }

    private void ensureJarFileIsOpen() {
        block5: {
            this.writeLock.lock();
            try {
                if (this.zipFile != null) break block5;
                try {
                    this.zipFile = JarFiles.create((File)this.jarPath.toFile());
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to open " + this.jarPath, e);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    @Override
    public void close() {
        block5: {
            this.writeLock.lock();
            try {
                JarFile zipFileLocal = this.zipFile;
                if (zipFileLocal == null) break block5;
                try {
                    zipFileLocal.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.zipFile = null;
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    @Override
    public void resetInternalCaches() {
        this.close();
    }
}

