/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.spi;

import io.quarkus.builder.item.SimpleBuildItem;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class ContainerImageInfoBuildItem
extends SimpleBuildItem {
    private static final String SLASH = "/";
    private static final String COLN = ":";
    public final Optional<String> registry;
    private final String imagePrefix;
    private final String tag;
    private final Set<String> additionalTags;

    public ContainerImageInfoBuildItem(Optional<String> registry, Optional<String> group, String name, String tag, List<String> additionalTags) {
        this.registry = registry;
        StringBuilder sb = new StringBuilder();
        registry.ifPresent(r -> sb.append((String)r).append(SLASH));
        group.ifPresent(s -> sb.append((String)s).append(SLASH));
        this.imagePrefix = sb.append(name).toString();
        this.tag = tag;
        this.additionalTags = new HashSet<String>(additionalTags);
    }

    public Optional<String> getRegistry() {
        return this.registry;
    }

    public String getImage() {
        return this.imagePrefix + COLN + this.tag;
    }

    public String getTag() {
        return this.tag;
    }

    public List<String> getAdditionalImageTags() {
        return this.getAdditionalTags().stream().map(tag -> this.imagePrefix + COLN + tag).collect(Collectors.toList());
    }

    public Set<String> getAdditionalTags() {
        return this.additionalTags;
    }
}

