/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.runtime.annotations.RegisterForReflection;
import javax.inject.Inject;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class RegisterForReflectionBuildStep {
    private static final Logger log = Logger.getLogger(RegisterForReflectionBuildStep.class);
    @Inject
    CombinedIndexBuildItem combinedIndexBuildItem;

    @BuildStep
    public void build(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        for (AnnotationInstance i : this.combinedIndexBuildItem.getIndex().getAnnotations(DotName.createSimple((String)RegisterForReflection.class.getName()))) {
            String[] classNames;
            boolean methods = RegisterForReflectionBuildStep.getBooleanValue(i, "methods");
            boolean fields = RegisterForReflectionBuildStep.getBooleanValue(i, "fields");
            boolean ignoreNested = RegisterForReflectionBuildStep.getBooleanValue(i, "ignoreNested");
            AnnotationValue targetsValue = i.value("targets");
            AnnotationValue classNamesValue = i.value("classNames");
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (targetsValue == null && classNamesValue == null) {
                ClassInfo classInfo = i.target().asClass();
                this.registerClass(classLoader, classInfo.name().toString(), methods, fields, ignoreNested, reflectiveClass);
                continue;
            }
            if (targetsValue != null) {
                Type[] targets;
                for (Type type : targets = targetsValue.asClassArray()) {
                    this.registerClass(classLoader, type.name().toString(), methods, fields, ignoreNested, reflectiveClass);
                }
            }
            if (classNamesValue == null) continue;
            for (String string : classNames = classNamesValue.asStringArray()) {
                this.registerClass(classLoader, string, methods, fields, ignoreNested, reflectiveClass);
            }
        }
    }

    private void registerClass(ClassLoader classLoader, String className, boolean methods, boolean fields, boolean ignoreNested, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        reflectiveClass.produce(new ReflectiveClassBuildItem(methods, fields, className));
        if (ignoreNested) {
            return;
        }
        try {
            Class<?>[] declaredClasses;
            for (Class<?> clazz : declaredClasses = classLoader.loadClass(className).getDeclaredClasses()) {
                this.registerClass(classLoader, clazz.getName(), methods, fields, false, reflectiveClass);
            }
        }
        catch (ClassNotFoundException e) {
            log.warnf((Throwable)e, "Failed to load Class %s", (Object)className);
        }
    }

    private static boolean getBooleanValue(AnnotationInstance i, String name) {
        return i.value(name) == null || i.value(name).asBoolean();
    }
}

