/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.EnableAllSecurityServicesBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.JavaLibraryPathAdditionalPathBuildItem;
import io.quarkus.deployment.builditem.JniBuildItem;
import io.quarkus.deployment.builditem.NativeImageEnableAllCharsetsBuildItem;
import io.quarkus.deployment.builditem.SslNativeConfigBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageSystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeReinitializedClassBuildItem;
import io.quarkus.runtime.ssl.SslContextConfigurationRecorder;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

class NativeImageConfigBuildStep {
    private static final Logger log = Logger.getLogger(NativeImageConfigBuildStep.class);

    NativeImageConfigBuildStep() {
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void build(SslContextConfigurationRecorder sslContextConfigurationRecorder, List<NativeImageConfigBuildItem> nativeImageConfigBuildItems, SslNativeConfigBuildItem sslNativeConfig, List<JniBuildItem> jniBuildItems, List<NativeImageEnableAllCharsetsBuildItem> nativeImageEnableAllCharsetsBuildItems, List<ExtensionSslNativeSupportBuildItem> extensionSslNativeSupport, List<EnableAllSecurityServicesBuildItem> enableAllSecurityServicesBuildItems, BuildProducer<NativeImageProxyDefinitionBuildItem> proxy, BuildProducer<NativeImageResourceBundleBuildItem> resourceBundle, BuildProducer<RuntimeInitializedClassBuildItem> runtimeInit, BuildProducer<RuntimeReinitializedClassBuildItem> runtimeReinit, BuildProducer<NativeImageSystemPropertyBuildItem> nativeImage, BuildProducer<SystemPropertyBuildItem> systemProperty, BuildProducer<JavaLibraryPathAdditionalPathBuildItem> javaLibraryPathAdditionalPath) {
        for (NativeImageConfigBuildItem nativeImageConfigBuildItem : nativeImageConfigBuildItems) {
            for (String string : nativeImageConfigBuildItem.getRuntimeInitializedClasses()) {
                runtimeInit.produce(new RuntimeInitializedClassBuildItem(string));
            }
            for (String string : nativeImageConfigBuildItem.getRuntimeReinitializedClasses()) {
                runtimeReinit.produce(new RuntimeReinitializedClassBuildItem(string));
            }
            for (Map.Entry entry : nativeImageConfigBuildItem.getNativeImageSystemProperties().entrySet()) {
                nativeImage.produce(new NativeImageSystemPropertyBuildItem((String)entry.getKey(), (String)entry.getValue()));
            }
            for (String string : nativeImageConfigBuildItem.getResourceBundles()) {
                resourceBundle.produce(new NativeImageResourceBundleBuildItem(string));
            }
            for (List list : nativeImageConfigBuildItem.getProxyDefinitions()) {
                proxy.produce(new NativeImageProxyDefinitionBuildItem(list));
            }
        }
        sslContextConfigurationRecorder.setSslNativeEnabled(!sslNativeConfig.isExplicitlyDisabled());
        Boolean sslNativeEnabled = this.isSslNativeEnabled(sslNativeConfig, extensionSslNativeSupport);
        nativeImage.produce(new NativeImageSystemPropertyBuildItem("quarkus.ssl.native", sslNativeEnabled.toString()));
        if (!enableAllSecurityServicesBuildItems.isEmpty()) {
            nativeImage.produce(new NativeImageSystemPropertyBuildItem("quarkus.native.enable-all-security-services", "true"));
        }
        for (JniBuildItem jniBuildItem : jniBuildItems) {
            if (jniBuildItem.getLibraryPaths() == null || jniBuildItem.getLibraryPaths().isEmpty()) continue;
            for (String path : jniBuildItem.getLibraryPaths()) {
                javaLibraryPathAdditionalPath.produce(new JavaLibraryPathAdditionalPathBuildItem(path));
            }
        }
        if (!nativeImageEnableAllCharsetsBuildItems.isEmpty()) {
            nativeImage.produce(new NativeImageSystemPropertyBuildItem("quarkus.native.enable-all-charsets", "true"));
        }
    }

    private Boolean isSslNativeEnabled(SslNativeConfigBuildItem sslNativeConfig, List<ExtensionSslNativeSupportBuildItem> extensionSslNativeSupport) {
        if (sslNativeConfig.isEnabled()) {
            return Boolean.TRUE;
        }
        if (!sslNativeConfig.isExplicitlyDisabled() && !extensionSslNativeSupport.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debugf("Native SSL support enabled due to extensions [%s] requiring it", (Object)extensionSslNativeSupport.stream().map(s -> s.getExtension()).collect(Collectors.joining(", ")));
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

