/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.util;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.model.PathsCollection;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.deployment.util.IoUtil;
import io.quarkus.runtime.LaunchMode;
import io.smallrye.common.io.jar.JarFiles;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jboss.logging.Logger;

public class WebJarUtil {
    private static final Logger LOG = Logger.getLogger(WebJarUtil.class);
    private static final String TMP_DIR = System.getProperty("java.io.tmpdir");
    private static final String CUSTOM_MEDIA_FOLDER = "META-INF/branding/";
    private static final List<String> IGNORE_LIST = Arrays.asList("logo.png", "favicon.ico", "style.css");
    private static final String SNAPSHOT_VERSION = "-SNAPSHOT";

    private WebJarUtil() {
    }

    public static Path copyResourcesForDevOrTest(CurateOutcomeBuildItem curateOutcomeBuildItem, LaunchModeBuildItem launchMode, final AppArtifact resourcesArtifact, String rootFolderInJar) throws IOException {
        rootFolderInJar = WebJarUtil.normalizeRootFolderInJar(rootFolderInJar);
        final AppArtifact userApplication = curateOutcomeBuildItem.getEffectiveModel().getAppArtifact();
        final Path deploymentPath = WebJarUtil.createResourcesDirectory(userApplication, resourcesArtifact);
        if (!launchMode.getLaunchMode().equals((Object)LaunchMode.DEVELOPMENT) || resourcesArtifact.getVersion().contains(SNAPSHOT_VERSION)) {
            IoUtils.createOrEmptyDir((Path)deploymentPath);
        }
        if (WebJarUtil.isEmpty(deploymentPath)) {
            final ClassLoader classLoader = WebJarUtil.class.getClassLoader();
            for (Path p : resourcesArtifact.getPaths()) {
                File artifactFile = p.toFile();
                if (artifactFile.isFile()) {
                    JarFile jarFile = JarFiles.create((File)artifactFile);
                    Throwable throwable = null;
                    try {
                        Enumeration<JarEntry> entries = jarFile.entries();
                        while (entries.hasMoreElements()) {
                            JarEntry entry = entries.nextElement();
                            if (!entry.getName().startsWith(rootFolderInJar)) continue;
                            String fileName = entry.getName().replace(rootFolderInJar, "");
                            Path filePath = deploymentPath.resolve(fileName);
                            if (entry.isDirectory()) {
                                Files.createDirectories(filePath, new FileAttribute[0]);
                                continue;
                            }
                            InputStream inputStream = jarFile.getInputStream(entry);
                            Throwable throwable2 = null;
                            try {
                                String modulename = WebJarUtil.getModuleOverrideName(resourcesArtifact, fileName);
                                if (IGNORE_LIST.contains(fileName) && WebJarUtil.isOverride(userApplication.getPaths(), classLoader, fileName, modulename)) {
                                    InputStream override = WebJarUtil.getOverride(userApplication.getPaths(), classLoader, fileName, modulename);
                                    Throwable throwable3 = null;
                                    try {
                                        WebJarUtil.createFile(override, filePath);
                                        continue;
                                    }
                                    catch (Throwable throwable4) {
                                        throwable3 = throwable4;
                                        throw throwable4;
                                    }
                                    finally {
                                        if (override == null) continue;
                                        if (throwable3 != null) {
                                            try {
                                                override.close();
                                            }
                                            catch (Throwable throwable5) {
                                                throwable3.addSuppressed(throwable5);
                                            }
                                            continue;
                                        }
                                        override.close();
                                        continue;
                                    }
                                }
                                WebJarUtil.createFile(inputStream, filePath);
                            }
                            catch (Throwable throwable6) {
                                throwable2 = throwable6;
                                throw throwable6;
                            }
                            finally {
                                if (inputStream == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable7) {
                                        throwable2.addSuppressed(throwable7);
                                    }
                                    continue;
                                }
                                inputStream.close();
                            }
                        }
                        continue;
                    }
                    catch (Throwable throwable8) {
                        throwable = throwable8;
                        throw throwable8;
                    }
                    finally {
                        if (jarFile == null) continue;
                        if (throwable != null) {
                            try {
                                jarFile.close();
                            }
                            catch (Throwable throwable9) {
                                throwable.addSuppressed(throwable9);
                            }
                            continue;
                        }
                        jarFile.close();
                        continue;
                    }
                }
                final Path rootFolderToCopy = p.resolve(rootFolderInJar);
                if (!Files.isDirectory(rootFolderToCopy, new LinkOption[0])) continue;
                Files.walkFileTree(rootFolderToCopy, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        Files.createDirectories(deploymentPath.resolve(rootFolderToCopy.relativize(dir)), new FileAttribute[0]);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        String fileName = rootFolderToCopy.relativize(file).toString();
                        Path targetFilePath = deploymentPath.resolve(rootFolderToCopy.relativize(file));
                        String modulename = WebJarUtil.getModuleOverrideName(resourcesArtifact, fileName);
                        if (IGNORE_LIST.contains(fileName) && WebJarUtil.isOverride(userApplication.getPaths(), classLoader, fileName, modulename)) {
                            try (InputStream override = WebJarUtil.getOverride(userApplication.getPaths(), classLoader, fileName, modulename);){
                                WebJarUtil.createFile(override, targetFilePath);
                            }
                        } else {
                            Files.copy(file, targetFilePath, new CopyOption[0]);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        return deploymentPath;
    }

    public static void updateFile(Path original, byte[] newContent) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(newContent);){
            WebJarUtil.createFile(bais, original);
        }
    }

    public static void updateUrl(Path original, String path, String lineStartsWith, String format) throws IOException {
        String content = new String(Files.readAllBytes(original), StandardCharsets.UTF_8);
        String result = WebJarUtil.updateUrl(content, path, lineStartsWith, format);
        if (result != null && !result.equals(content)) {
            Files.write(original, result.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }

    public static String updateUrl(String original, String path, String lineStartsWith, String format) {
        try (Scanner scanner = new Scanner(original);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (!line.trim().startsWith(lineStartsWith)) continue;
                String newLine = String.format(format, path);
                String string = original.replace(line.trim(), newLine);
                return string;
            }
        }
        return original;
    }

    public static Map<String, byte[]> copyResourcesForProduction(CurateOutcomeBuildItem curateOutcomeBuildItem, AppArtifact artifact, String rootFolderInJar) throws IOException {
        rootFolderInJar = WebJarUtil.normalizeRootFolderInJar(rootFolderInJar);
        AppArtifact userApplication = curateOutcomeBuildItem.getEffectiveModel().getAppArtifact();
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        ClassLoader classLoader = WebJarUtil.class.getClassLoader();
        for (Path p : artifact.getPaths()) {
            File artifactFile = p.toFile();
            JarFile jarFile = JarFiles.create((File)artifactFile);
            Throwable throwable = null;
            try {
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (!entry.getName().startsWith(rootFolderInJar) || entry.isDirectory()) continue;
                    InputStream inputStream = jarFile.getInputStream(entry);
                    Throwable throwable2 = null;
                    try {
                        byte[] content;
                        String filename = entry.getName().replace(rootFolderInJar, "");
                        String modulename = WebJarUtil.getModuleOverrideName(artifact, filename);
                        if (IGNORE_LIST.contains(filename) && WebJarUtil.isOverride(userApplication.getPaths(), classLoader, filename, modulename)) {
                            try (InputStream resourceAsStream = WebJarUtil.getOverride(userApplication.getPaths(), classLoader, filename, modulename);){
                                content = IoUtil.readBytes(resourceAsStream);
                            }
                        } else {
                            content = FileUtil.readFileContents(inputStream);
                        }
                        map.put(filename, content);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable2 != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (jarFile == null) continue;
                if (throwable != null) {
                    try {
                        jarFile.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                jarFile.close();
            }
        }
        return map;
    }

    public static AppArtifact getAppArtifact(CurateOutcomeBuildItem curateOutcomeBuildItem, String groupId, String artifactId) {
        for (AppDependency dep : curateOutcomeBuildItem.getEffectiveModel().getFullDeploymentDeps()) {
            if (!dep.getArtifact().getArtifactId().equals(artifactId) || !dep.getArtifact().getGroupId().equals(groupId)) continue;
            return dep.getArtifact();
        }
        throw new RuntimeException("Could not find artifact " + groupId + ":" + artifactId + " among the application dependencies");
    }

    private static String getModuleOverrideName(AppArtifact artifact, String filename) {
        String type = filename.substring(filename.lastIndexOf("."));
        return artifact.getArtifactId() + type;
    }

    private static InputStream getOverride(PathsCollection paths, ClassLoader classLoader, String filename, String modulename) {
        InputStream customStream = WebJarUtil.getCustomOverride(paths, filename, modulename);
        if (customStream != null) {
            return customStream;
        }
        return WebJarUtil.getQuarkusOverride(classLoader, filename);
    }

    private static InputStream getCustomOverride(PathsCollection paths, String filename, String modulename) {
        Path customOverridePath = WebJarUtil.getCustomOverridePath(paths, filename, modulename);
        if (customOverridePath != null) {
            return WebJarUtil.pathToStream(customOverridePath).orElse(null);
        }
        return null;
    }

    private static Path getCustomOverridePath(PathsCollection paths, String filename, String modulename) {
        for (Path root : paths) {
            Path customModuleOverride = root.resolve(CUSTOM_MEDIA_FOLDER + modulename);
            if (Files.exists(customModuleOverride, new LinkOption[0])) {
                return customModuleOverride;
            }
            Path customOverride = root.resolve(CUSTOM_MEDIA_FOLDER + filename);
            if (!Files.exists(customOverride, new LinkOption[0])) continue;
            return customOverride;
        }
        return null;
    }

    private static InputStream getQuarkusOverride(ClassLoader classLoader, String filename) {
        boolean quarkusOverride = WebJarUtil.fileExistInClasspath(classLoader, CUSTOM_MEDIA_FOLDER + filename);
        if (quarkusOverride) {
            return classLoader.getResourceAsStream(CUSTOM_MEDIA_FOLDER + filename);
        }
        return null;
    }

    private static boolean isOverride(PathsCollection paths, ClassLoader classLoader, String filename, String modulename) {
        if (WebJarUtil.isQuarkusOverride(classLoader, filename)) {
            return true;
        }
        return WebJarUtil.isCustomOverride(paths, filename, modulename);
    }

    private static boolean isQuarkusOverride(ClassLoader classLoader, String filename) {
        return WebJarUtil.fileExistInClasspath(classLoader, CUSTOM_MEDIA_FOLDER + filename);
    }

    private static boolean isCustomOverride(PathsCollection paths, String filename, String modulename) {
        Iterator iterator = paths.iterator();
        if (iterator.hasNext()) {
            Path root = (Path)iterator.next();
            Path customModuleOverride = root.resolve(CUSTOM_MEDIA_FOLDER + modulename);
            if (Files.exists(customModuleOverride, new LinkOption[0])) {
                return true;
            }
            Path customOverride = root.resolve(CUSTOM_MEDIA_FOLDER + filename);
            return Files.exists(customOverride, new LinkOption[0]);
        }
        return false;
    }

    private static final boolean fileExistInClasspath(ClassLoader classLoader, String filename) {
        URL u = classLoader.getResource(filename);
        return u != null;
    }

    private static final Optional<InputStream> pathToStream(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            try {
                return Optional.of(Files.newInputStream(path, new OpenOption[0]));
            }
            catch (IOException ex) {
                LOG.warn((Object)("Could not read override file [" + path + "] - " + ex.getMessage()));
            }
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createFile(InputStream source, Path targetFile) throws IOException {
        FileLock lock = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(targetFile.toString());
            FileChannel channel = fos.getChannel();
            lock = channel.tryLock();
            if (lock != null) {
                IoUtils.copy((OutputStream)fos, (InputStream)source);
            }
        }
        finally {
            if (lock != null) {
                lock.release();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    private static Path createResourcesDirectory(AppArtifact userApplication, AppArtifact resourcesArtifact) {
        try {
            Path path = Paths.get(TMP_DIR, "quarkus", userApplication.getGroupId(), userApplication.getArtifactId(), resourcesArtifact.getGroupId(), resourcesArtifact.getArtifactId(), resourcesArtifact.getVersion());
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            return path;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static boolean isEmpty(Path directory) throws IOException {
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(directory);){
            boolean bl = !dirStream.iterator().hasNext();
            return bl;
        }
    }

    private static String normalizeRootFolderInJar(String rootFolderInJar) {
        if (rootFolderInJar.endsWith("/")) {
            return rootFolderInJar;
        }
        return rootFolderInJar + "/";
    }
}

