/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class ClassComparisonUtil {
    static boolean isSameStructure(ClassInfo clazz, ClassInfo old) {
        if (clazz.flags() != old.flags()) {
            return false;
        }
        if (!clazz.typeParameters().equals(old.typeParameters())) {
            return false;
        }
        if (!clazz.interfaceNames().equals(old.interfaceNames())) {
            return false;
        }
        if (!ClassComparisonUtil.compareAnnotations(clazz.classAnnotations(), old.classAnnotations())) {
            return false;
        }
        if (old.fields().size() != clazz.fields().size()) {
            return false;
        }
        Map oldFields = old.fields().stream().collect(Collectors.toMap(FieldInfo::name, Function.identity()));
        for (FieldInfo field : clazz.fields()) {
            FieldInfo of = (FieldInfo)oldFields.get(field.name());
            if (of == null) {
                return false;
            }
            if (of.flags() != field.flags()) {
                return false;
            }
            if (!of.type().equals((Object)field.type())) {
                return false;
            }
            if (ClassComparisonUtil.compareAnnotations(of.annotations(), field.annotations())) continue;
            return false;
        }
        for (MethodInfo method : clazz.methods()) {
            MethodInfo om = null;
            for (MethodInfo i : old.methods()) {
                if (!i.name().equals(method.name()) || !i.returnType().equals((Object)method.returnType()) || i.parameters().size() != method.parameters().size() || i.flags() != method.flags() || !Objects.equals(i.defaultValue(), method.defaultValue())) continue;
                boolean paramEqual = true;
                for (int j = 0; j < method.parameters().size(); ++j) {
                    Type b;
                    Type a = (Type)method.parameters().get(j);
                    if (a.equals((Object)(b = (Type)i.parameters().get(j)))) continue;
                    paramEqual = false;
                    break;
                }
                if (!paramEqual || !ClassComparisonUtil.compareMethodAnnotations(i.annotations(), method.annotations())) continue;
                om = i;
            }
            if (om != null) continue;
            return false;
        }
        return true;
    }

    static boolean compareAnnotations(Collection<AnnotationInstance> a, Collection<AnnotationInstance> b) {
        if (a.size() != b.size()) {
            return false;
        }
        Map lookup = b.stream().collect(Collectors.toMap(AnnotationInstance::name, Function.identity()));
        for (AnnotationInstance i1 : a) {
            AnnotationInstance i2 = (AnnotationInstance)lookup.get(i1.name());
            if (i2 == null) {
                return false;
            }
            if (ClassComparisonUtil.compareAnnotation(i1, i2)) continue;
            return false;
        }
        return true;
    }

    static boolean compareMethodAnnotations(Collection<AnnotationInstance> a, Collection<AnnotationInstance> b) {
        if (a.size() != b.size()) {
            return false;
        }
        ArrayList<AnnotationInstance> method1 = new ArrayList<AnnotationInstance>();
        HashMap<Integer, List<AnnotationInstance>> params1 = new HashMap<Integer, List<AnnotationInstance>>();
        ClassComparisonUtil.methodMap(a, method1, params1);
        ArrayList<AnnotationInstance> method2 = new ArrayList<AnnotationInstance>();
        HashMap<Integer, List<AnnotationInstance>> params2 = new HashMap<Integer, List<AnnotationInstance>>();
        ClassComparisonUtil.methodMap(b, method2, params2);
        if (!ClassComparisonUtil.compareAnnotations(method1, method2)) {
            return false;
        }
        if (!params1.keySet().equals(params2.keySet())) {
            return false;
        }
        for (Map.Entry entry : params1.entrySet()) {
            List other = (List)params2.get(entry.getKey());
            if (ClassComparisonUtil.compareAnnotations(other, (Collection)entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private static void methodMap(Collection<AnnotationInstance> b, List<AnnotationInstance> method2, Map<Integer, List<AnnotationInstance>> params2) {
        for (AnnotationInstance i : b) {
            if (i.target().kind() == AnnotationTarget.Kind.METHOD) {
                method2.add(i);
                continue;
            }
            short index = i.target().asMethodParameter().position();
            List<AnnotationInstance> instances = params2.get(index);
            if (instances == null) {
                instances = new ArrayList<AnnotationInstance>();
                params2.put(Integer.valueOf(index), instances);
            }
            instances.add(i);
        }
    }

    private static boolean compareAnnotation(AnnotationInstance a, AnnotationInstance b) {
        List valuesA = a.values();
        List valuesB = b.values();
        if (valuesA.size() != valuesB.size()) {
            return false;
        }
        for (AnnotationValue valueA : valuesA) {
            AnnotationValue valueB;
            if (valueA.equals((Object)(valueB = b.value(valueA.name())))) continue;
            return false;
        }
        return true;
    }
}

