/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.index;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.model.PathsCollection;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.ApplicationArchiveImpl;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveBuildItem;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.QuarkusBuildCloseablesBuildItem;
import io.quarkus.deployment.index.IndexDependencyConfig;
import io.quarkus.deployment.index.IndexingUtil;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;

public class ApplicationArchiveBuildStep {
    private static final Logger LOGGER = Logger.getLogger(ApplicationArchiveBuildStep.class);
    IndexDependencyConfiguration config;

    @BuildStep
    void addConfiguredIndexedDependencies(BuildProducer<IndexDependencyBuildItem> indexDependencyBuildItemBuildProducer) {
        for (IndexDependencyConfig indexDependencyConfig : this.config.indexDependency.values()) {
            indexDependencyBuildItemBuildProducer.produce(new IndexDependencyBuildItem(indexDependencyConfig.groupId, indexDependencyConfig.artifactId, indexDependencyConfig.classifier.orElse(null)));
        }
    }

    @BuildStep
    ApplicationArchivesBuildItem build(QuarkusBuildCloseablesBuildItem buildCloseables, ArchiveRootBuildItem root, ApplicationIndexBuildItem appindex, List<AdditionalApplicationArchiveMarkerBuildItem> appMarkers, List<AdditionalApplicationArchiveBuildItem> additionalApplicationArchiveBuildItem, List<IndexDependencyBuildItem> indexDependencyBuildItems, LiveReloadBuildItem liveReloadContext, CurateOutcomeBuildItem curateOutcomeBuildItem) throws IOException {
        HashSet<String> markerFiles = new HashSet<String>();
        for (AdditionalApplicationArchiveMarkerBuildItem i : appMarkers) {
            markerFiles.add(i.getFile());
        }
        IndexCache indexCache = liveReloadContext.getContextObject(IndexCache.class);
        if (indexCache == null) {
            indexCache = new IndexCache();
            liveReloadContext.setContextObject(IndexCache.class, indexCache);
        }
        List<ApplicationArchive> applicationArchives = this.scanForOtherIndexes(buildCloseables, Thread.currentThread().getContextClassLoader(), markerFiles, root, additionalApplicationArchiveBuildItem, indexDependencyBuildItems, indexCache, curateOutcomeBuildItem);
        return new ApplicationArchivesBuildItem(new ApplicationArchiveImpl((IndexView)appindex.getIndex(), root.getRootDirs(), root.getPaths(), null), applicationArchives);
    }

    private List<ApplicationArchive> scanForOtherIndexes(QuarkusBuildCloseablesBuildItem buildCloseables, ClassLoader classLoader, Set<String> applicationArchiveFiles, ArchiveRootBuildItem root, List<AdditionalApplicationArchiveBuildItem> additionalApplicationArchives, List<IndexDependencyBuildItem> indexDependencyBuildItem, IndexCache indexCache, CurateOutcomeBuildItem curateOutcomeBuildItem) throws IOException {
        ArrayList<ApplicationArchive> appArchives = new ArrayList<ApplicationArchive>();
        HashSet<Path> indexedPaths = new HashSet<Path>();
        HashSet<String> markers = new HashSet<String>(applicationArchiveFiles);
        markers.add("META-INF/jandex.idx");
        ApplicationArchiveBuildStep.addMarkerFilePaths(markers, root, curateOutcomeBuildItem, indexedPaths, appArchives, buildCloseables, classLoader, indexCache);
        this.addIndexDependencyPaths(indexDependencyBuildItem, classLoader, root, indexedPaths, appArchives, buildCloseables, indexCache, curateOutcomeBuildItem);
        for (AdditionalApplicationArchiveBuildItem i : additionalApplicationArchives) {
            for (Path apPath : i.getPaths()) {
                if (root.getPaths().contains(apPath) || !indexedPaths.add(apPath)) continue;
                appArchives.add(ApplicationArchiveBuildStep.createApplicationArchive(buildCloseables, classLoader, indexCache, apPath, null));
            }
        }
        return appArchives;
    }

    public void addIndexDependencyPaths(List<IndexDependencyBuildItem> indexDependencyBuildItems, ClassLoader classLoader, ArchiveRootBuildItem root, Set<Path> indexedDeps, List<ApplicationArchive> appArchives, QuarkusBuildCloseablesBuildItem buildCloseables, IndexCache indexCache, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        if (indexDependencyBuildItems.isEmpty()) {
            return;
        }
        List userDeps = curateOutcomeBuildItem.getEffectiveModel().getUserDependencies();
        HashMap<AppArtifactKey, AppArtifact> userMap = new HashMap<AppArtifactKey, AppArtifact>(userDeps.size());
        for (AppDependency dep : userDeps) {
            userMap.put(dep.getArtifact().getKey(), dep.getArtifact());
        }
        try {
            for (IndexDependencyBuildItem indexDependencyBuildItem : indexDependencyBuildItems) {
                AppArtifactKey key = new AppArtifactKey(indexDependencyBuildItem.getGroupId(), indexDependencyBuildItem.getArtifactId(), indexDependencyBuildItem.getClassifier(), "jar");
                AppArtifact artifact = (AppArtifact)userMap.get(key);
                if (artifact == null) {
                    throw new RuntimeException("Could not resolve artifact " + key + " among the runtime dependencies of the application");
                }
                for (Path path : artifact.getPaths()) {
                    if (root.isExcludedFromIndexing(path) || root.getPaths().contains(path) || !indexedDeps.add(path)) continue;
                    appArchives.add(ApplicationArchiveBuildStep.createApplicationArchive(buildCloseables, classLoader, indexCache, path, key));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static ApplicationArchive createApplicationArchive(QuarkusBuildCloseablesBuildItem buildCloseables, ClassLoader classLoader, IndexCache indexCache, Path dep, AppArtifactKey artifactKey) throws IOException {
        FileSystem fs = Files.isDirectory(dep, new LinkOption[0]) ? null : buildCloseables.add(FileSystems.newFileSystem(dep, classLoader));
        return new ApplicationArchiveImpl(ApplicationArchiveBuildStep.indexPath(indexCache, dep), fs == null ? dep : fs.getRootDirectories().iterator().next(), fs, fs != null, dep, artifactKey);
    }

    private static IndexView indexPath(IndexCache indexCache, Path dep) throws IOException {
        LOGGER.debugf("Indexing dependency: %s", (Object)dep);
        return Files.isDirectory(dep, new LinkOption[0]) ? ApplicationArchiveBuildStep.handleFilePath(dep) : ApplicationArchiveBuildStep.handleJarPath(dep, indexCache);
    }

    private static void addMarkerFilePaths(Set<String> applicationArchiveFiles, ArchiveRootBuildItem root, CurateOutcomeBuildItem curateOutcomeBuildItem, Set<Path> indexedPaths, List<ApplicationArchive> appArchives, QuarkusBuildCloseablesBuildItem buildCloseables, ClassLoader classLoader, IndexCache indexCache) throws IOException {
        for (AppDependency dep : curateOutcomeBuildItem.getEffectiveModel().getUserDependencies()) {
            PathsCollection artifactPaths = dep.getArtifact().getPaths();
            boolean containsMarker = false;
            for (Path p : artifactPaths) {
                if (root.isExcludedFromIndexing(p)) continue;
                if (Files.isDirectory(p, new LinkOption[0])) {
                    containsMarker = ApplicationArchiveBuildStep.containsMarker(p, applicationArchiveFiles);
                    if (!containsMarker) continue;
                    break;
                }
                try {
                    FileSystem fs = FileSystems.newFileSystem(p, classLoader);
                    Throwable throwable = null;
                    try {
                        containsMarker = ApplicationArchiveBuildStep.containsMarker(fs.getPath("/", new String[0]), applicationArchiveFiles);
                        if (!containsMarker) continue;
                        break;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fs == null) continue;
                        if (throwable != null) {
                            try {
                                fs.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        fs.close();
                    }
                }
                catch (ProviderNotFoundException providerNotFoundException) {}
            }
            if (!containsMarker) continue;
            PathsCollection.Builder rootDirs = PathsCollection.builder();
            ArrayList<IndexView> indexes = new ArrayList<IndexView>(artifactPaths.size());
            for (Path p : artifactPaths) {
                if (Files.isDirectory(p, new LinkOption[0])) {
                    rootDirs.add(p);
                } else {
                    FileSystem fs = buildCloseables.add(FileSystems.newFileSystem(p, classLoader));
                    fs.getRootDirectories().forEach(arg_0 -> ((PathsCollection.Builder)rootDirs).add(arg_0));
                }
                indexes.add(ApplicationArchiveBuildStep.indexPath(indexCache, p));
                indexedPaths.add(p);
            }
            appArchives.add(new ApplicationArchiveImpl((IndexView)(indexes.size() == 1 ? (IndexView)indexes.get(0) : CompositeIndex.create(indexes)), rootDirs.build(), artifactPaths, dep.getArtifact().getKey()));
        }
    }

    private static boolean containsMarker(Path dir, Set<String> applicationArchiveFiles) throws IOException {
        for (String file : applicationArchiveFiles) {
            if (!Files.exists(dir.resolve(file), new LinkOption[0])) continue;
            return true;
        }
        return false;
    }

    private static Index handleFilePath(Path path) throws IOException {
        return ApplicationArchiveBuildStep.indexFilePath(path);
    }

    private static Index indexFilePath(Path path) throws IOException {
        Indexer indexer = new Indexer();
        try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
            stream.forEach(path1 -> {
                if (path1.toString().endsWith(".class")) {
                    try (FileInputStream in = new FileInputStream(path1.toFile());){
                        indexer.index((InputStream)in);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        return indexer.complete();
    }

    private static Index handleJarPath(Path path, IndexCache indexCache) {
        return indexCache.cache.computeIfAbsent(path, new Function<Path, Index>(){

            @Override
            public Index apply(Path path) {
                try {
                    return IndexingUtil.indexJar(path);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to process " + path, e);
                }
            }
        });
    }

    private static final class IndexCache {
        final Map<Path, Index> cache = new HashMap<Path, Index>();

        private IndexCache() {
        }
    }

    @ConfigRoot(phase=ConfigPhase.BUILD_TIME)
    static final class IndexDependencyConfiguration {
        @ConfigItem(name="<<parent>>")
        Map<String, IndexDependencyConfig> indexDependency;

        IndexDependencyConfiguration() {
        }
    }
}

