/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ConfigDescriptionBuildItem;
import io.quarkus.deployment.builditem.ConfigurationBuildItem;
import io.quarkus.deployment.configuration.matching.ConfigPatternMap;
import io.quarkus.deployment.configuration.matching.Container;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.util.ClassPathUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class ConfigDescriptionBuildStep {
    @BuildStep
    List<ConfigDescriptionBuildItem> createConfigDescriptions(ConfigurationBuildItem config) throws Exception {
        Properties javadoc = new Properties();
        ClassPathUtils.consumeAsStreams((String)"META-INF/quarkus-javadoc.properties", in -> {
            try {
                javadoc.load((InputStream)in);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        ArrayList<ConfigDescriptionBuildItem> ret = new ArrayList<ConfigDescriptionBuildItem>();
        this.processConfig(config.getReadResult().getBuildTimePatternMap(), ret, javadoc);
        this.processConfig(config.getReadResult().getBuildTimeRunTimePatternMap(), ret, javadoc);
        this.processConfig(config.getReadResult().getBootstrapPatternMap(), ret, javadoc);
        this.processConfig(config.getReadResult().getRunTimePatternMap(), ret, javadoc);
        return ret;
    }

    private void processConfig(ConfigPatternMap<Container> patterns, final List<ConfigDescriptionBuildItem> ret, final Properties javadoc) {
        patterns.forEach(new Consumer<Container>(){

            @Override
            public void accept(Container node) {
                String propDefVal;
                Field field = node.findField();
                ConfigItem configItem = field.getAnnotation(ConfigItem.class);
                ConfigProperty configProperty = field.getAnnotation(ConfigProperty.class);
                Class<?> valueClass = field.getType();
                String defaultDefault = valueClass == Boolean.TYPE ? "false" : (valueClass.isPrimitive() && valueClass != Character.TYPE ? "0" : null);
                String defVal = defaultDefault;
                if (configItem != null) {
                    String itemDefVal = configItem.defaultValue();
                    if (!itemDefVal.equals("<<no default>>")) {
                        defVal = itemDefVal;
                    }
                } else if (configProperty != null && !(propDefVal = configProperty.defaultValue()).equals("org.eclipse.microprofile.config.configproperty.unconfigureddvalue")) {
                    defVal = propDefVal;
                }
                String javadocKey = field.getDeclaringClass().getName().replace("$", ".") + "." + field.getName();
                ret.add(new ConfigDescriptionBuildItem("quarkus." + node.getPropertyName(), node.findEnclosingClass().getConfigurationClass(), defVal, javadoc.getProperty(javadocKey)));
            }
        });
    }
}

