/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration;

import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.KeyMap;
import io.smallrye.config.NameIterator;
import jakarta.annotation.Priority;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiFunction;
import org.jboss.logging.Logger;

public final class ConfigCompatibility {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.deployment.configuration");
    private static final KeyMap<BiFunction<ConfigSourceInterceptorContext, NameIterator, List<String>>> oldNames = ConfigCompatibility.keyMap(Map.entry(List.of("quarkus", "package", "type"), ConfigCompatibility::quarkusPackageType), Map.entry(List.of("quarkus", "package", "create-appcds"), ConfigCompatibility::quarkusPackageCreateAppcds), Map.entry(List.of("quarkus", "package", "appcds-builder-image"), ConfigCompatibility::quarkusPackageAppcdsBuilderImage), Map.entry(List.of("quarkus", "package", "appcds-use-container"), ConfigCompatibility::quarkusPackageAppcdsUseContainer), Map.entry(List.of("quarkus", "package", "compress-jar"), ConfigCompatibility::quarkusPackageCompressJar), Map.entry(List.of("quarkus", "package", "filter-optional-dependencies"), ConfigCompatibility::quarkusFilterOptionalDependencies), Map.entry(List.of("quarkus", "package", "add-runner-suffix"), ConfigCompatibility::quarkusPackageAddRunnerSuffix), Map.entry(List.of("quarkus", "package", "user-configured-ignored-entries"), ConfigCompatibility::quarkusPackageUserConfiguredIgnoredEntries), Map.entry(List.of("quarkus", "package", "user-providers-directory"), ConfigCompatibility::quarkusPackageUserProvidersDirectory), Map.entry(List.of("quarkus", "package", "included-optional-dependencies"), ConfigCompatibility::quarkusPackageIncludedOptionalDependencies), Map.entry(List.of("quarkus", "package", "include-dependency-list"), ConfigCompatibility::quarkusPackageIncludeDependencyList), Map.entry(List.of("quarkus", "package", "vineflower", "version"), ConfigCompatibility::quarkusPackageVineflowerVersion), Map.entry(List.of("quarkus", "package", "vineflower", "enabled"), ConfigCompatibility::quarkusPackageVineflowerEnabled), Map.entry(List.of("quarkus", "package", "vineflower", "jar-directory"), ConfigCompatibility::quarkusPackageVineflowerJarDirectory), Map.entry(List.of("quarkus", "package", "manifest", "attributes", "*"), ConfigCompatibility::quarkusPackageManifestAttributes), Map.entry(List.of("quarkus", "package", "manifest", "sections", "*", "*"), ConfigCompatibility::quarkusPackageManifestSections), Map.entry(List.of("quarkus", "package", "manifest", "add-implementation-entries"), ConfigCompatibility::quarkusPackageManifestAddImplementationEntries));
    public static final KeyMap<BiFunction<ConfigSourceInterceptorContext, NameIterator, ConfigValue>> newNames = ConfigCompatibility.keyMap(Map.entry(List.of("quarkus", "native", "enabled"), ConfigCompatibility::quarkusNativeEnabled), Map.entry(List.of("quarkus", "native", "sources-only"), ConfigCompatibility::quarkusNativeSourcesOnly), Map.entry(List.of("quarkus", "package", "jar", "enabled"), ConfigCompatibility::quarkusPackageJarEnabled), Map.entry(List.of("quarkus", "package", "jar", "appcds", "enabled"), ConfigCompatibility::quarkusPackageJarAppcdsEnabled), Map.entry(List.of("quarkus", "package", "jar", "appcds", "builder-image"), ConfigCompatibility::quarkusPackageJarAppcdsBuilderImage), Map.entry(List.of("quarkus", "package", "jar", "appcds", "use-container"), ConfigCompatibility::quarkusPackageJarAppcdsUseContainer), Map.entry(List.of("quarkus", "package", "jar", "type"), ConfigCompatibility::quarkusPackageJarType), Map.entry(List.of("quarkus", "package", "jar", "compress"), ConfigCompatibility::quarkusPackageJarCompress), Map.entry(List.of("quarkus", "package", "jar", "filter-optional-dependencies"), ConfigCompatibility::quarkusPackageJarFilterOptionalDependencies), Map.entry(List.of("quarkus", "package", "jar", "add-runner-suffix"), ConfigCompatibility::quarkusPackageJarAddRunnerSuffix), Map.entry(List.of("quarkus", "package", "jar", "user-configured-ignored-entries"), ConfigCompatibility::quarkusPackageJarUserConfiguredIgnoredEntries), Map.entry(List.of("quarkus", "package", "jar", "user-providers-directory"), ConfigCompatibility::quarkusPackageJarUserProvidersDirectory), Map.entry(List.of("quarkus", "package", "jar", "included-optional-dependencies"), ConfigCompatibility::quarkusPackageJarIncludedOptionalDependencies), Map.entry(List.of("quarkus", "package", "jar", "include-dependency-list"), ConfigCompatibility::quarkusPackageJarIncludeDependencyList), Map.entry(List.of("quarkus", "package", "jar", "manifest", "attributes", "*"), ConfigCompatibility::quarkusPackageJarManifestAttributes), Map.entry(List.of("quarkus", "package", "jar", "manifest", "sections", "*", "*"), ConfigCompatibility::quarkusPackageJarManifestSections), Map.entry(List.of("quarkus", "package", "jar", "manifest", "add-implementation-entries"), ConfigCompatibility::quarkusPackageJarManifestAddImplementationEntries), Map.entry(List.of("quarkus", "package", "decompiler", "enabled"), ConfigCompatibility::quarkusPackageDecompilerEnabled), Map.entry(List.of("quarkus", "package", "decompiler", "jar-directory"), ConfigCompatibility::quarkusPackageDecompilerJarDirectory));
    private static final Set<String> ANY_NATIVE = Set.of("native", "native-sources");

    private static List<String> quarkusPackageType(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        ConfigValue legacyPackageType = ctxt.proceed(ni.getName());
        if (legacyPackageType == null) {
            return List.of();
        }
        return List.of("quarkus.package.jar.enabled", "quarkus.package.jar.type", "quarkus.native.enabled", "quarkus.native.sources-only");
    }

    private static List<String> quarkusPackageCreateAppcds(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        return List.of("quarkus.package.jar.appcds.enabled");
    }

    private static List<String> quarkusPackageAppcdsBuilderImage(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        return List.of("quarkus.package.jar.appcds.builder-image");
    }

    private static List<String> quarkusPackageAppcdsUseContainer(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        return List.of("quarkus.package.jar.appcds.use-container");
    }

    private static List<String> quarkusPackageCompressJar(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        return List.of("quarkus.package.jar.compress");
    }

    private static List<String> quarkusFilterOptionalDependencies(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        return List.of("quarkus.package.jar.filter-optional-dependencies");
    }

    private static List<String> quarkusPackageAddRunnerSuffix(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        return List.of("quarkus.package.jar.add-runner-suffix");
    }

    private static List<String> quarkusPackageUserConfiguredIgnoredEntries(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        return List.of("quarkus.package.jar.user-configured-ignored-entries");
    }

    private static List<String> quarkusPackageIncludeDependencyList(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        return List.of("quarkus.package.jar.include-dependency-list");
    }

    private static List<String> quarkusPackageUserProvidersDirectory(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        return List.of("quarkus.package.jar.user-providers-directory");
    }

    private static List<String> quarkusPackageIncludedOptionalDependencies(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        return List.of("quarkus.package.jar.included-optional-dependencies");
    }

    private static List<String> quarkusPackageVineflowerVersion(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        return List.of();
    }

    private static List<String> quarkusPackageVineflowerEnabled(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        return List.of("quarkus.package.decompiler.enabled");
    }

    private static List<String> quarkusPackageVineflowerJarDirectory(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        return List.of("quarkus.package.decompiler.jar-directory");
    }

    private static List<String> quarkusPackageManifestAttributes(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        ni.goToEnd();
        ni.previous();
        return List.of("quarkus.package.jar.manifest.attributes." + ni.getName().substring(ni.getPosition() + 1));
    }

    private static List<String> quarkusPackageManifestSections(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        ni.goToEnd();
        ni.previous();
        ni.previous();
        return List.of("quarkus.package.jar.manifest.sections." + ni.getName().substring(ni.getPosition() + 1));
    }

    private static List<String> quarkusPackageManifestAddImplementationEntries(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        return List.of("quarkus.package.jar.manifest.add-implementation-entries");
    }

    private static ConfigValue quarkusNativeEnabled(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        ConfigValue ptVal = ctxt.restart("quarkus.package.type");
        if (ptVal == null) {
            return ctxt.proceed(ni.getName());
        }
        return ptVal.withName(ni.getName()).withValue(Boolean.toString(ANY_NATIVE.contains(ptVal.getValue())));
    }

    private static ConfigValue quarkusPackageJarEnabled(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        ConfigValue ptVal = ctxt.restart("quarkus.package.type");
        if (ptVal == null) {
            return ctxt.proceed(ni.getName());
        }
        return ptVal.withName(ni.getName()).withValue(Boolean.toString(!ANY_NATIVE.contains(ptVal.getValue())));
    }

    private static ConfigValue quarkusPackageJarAppcdsEnabled(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        ConfigValue oldVal = ctxt.restart("quarkus.package.create-appcds");
        if (oldVal == null) {
            return ctxt.proceed(ni.getName());
        }
        return oldVal.withName(ni.getName());
    }

    private static ConfigValue quarkusPackageJarAppcdsBuilderImage(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        ConfigValue oldVal = ctxt.restart("quarkus.package.appcds-builder-image");
        if (oldVal == null) {
            return ctxt.proceed(ni.getName());
        }
        return oldVal.withName(ni.getName());
    }

    private static ConfigValue quarkusPackageJarAppcdsUseContainer(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        ConfigValue oldVal = ctxt.restart("quarkus.package.appcds-use-container");
        if (oldVal == null) {
            return ctxt.proceed(ni.getName());
        }
        return oldVal.withName(ni.getName());
    }

    private static ConfigValue quarkusPackageJarType(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        ConfigValue ptVal = ctxt.restart("quarkus.package.type");
        if (ptVal == null) {
            return ctxt.proceed(ni.getName());
        }
        return ANY_NATIVE.contains(ptVal.getValue()) ? ctxt.proceed(ni.getName()) : ptVal.withName(ni.getName());
    }

    private static ConfigValue quarkusPackageJarCompress(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        ConfigValue oldVal = ctxt.restart("quarkus.package.compress-jar");
        if (oldVal == null) {
            return ctxt.proceed(ni.getName());
        }
        return oldVal.withName(ni.getName());
    }

    private static ConfigValue quarkusPackageJarFilterOptionalDependencies(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        ConfigValue oldVal = ctxt.restart("quarkus.package.filter-optional-dependencies");
        if (oldVal == null) {
            return ctxt.proceed(ni.getName());
        }
        return oldVal.withName(ni.getName());
    }

    private static ConfigValue quarkusPackageJarAddRunnerSuffix(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        ConfigValue oldVal = ctxt.restart("quarkus.package.add-runner-suffix");
        if (oldVal == null) {
            return ctxt.proceed(ni.getName());
        }
        return oldVal.withName(ni.getName());
    }

    private static ConfigValue quarkusPackageJarUserConfiguredIgnoredEntries(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        ConfigValue oldVal = ctxt.restart("quarkus.package.user-configured-ignored-entries");
        if (oldVal == null) {
            return ctxt.proceed(ni.getName());
        }
        return oldVal.withName(ni.getName());
    }

    private static ConfigValue quarkusPackageJarUserProvidersDirectory(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        ConfigValue oldVal = ctxt.restart("quarkus.package.user-providers-directory");
        if (oldVal == null) {
            return ctxt.proceed(ni.getName());
        }
        return oldVal.withName(ni.getName());
    }

    private static ConfigValue quarkusPackageJarIncludedOptionalDependencies(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        ConfigValue oldVal = ctxt.restart("quarkus.package.included-optional-dependencies");
        if (oldVal == null) {
            return ctxt.proceed(ni.getName());
        }
        return oldVal.withName(ni.getName());
    }

    private static ConfigValue quarkusPackageJarIncludeDependencyList(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        ConfigValue oldVal = ctxt.restart("quarkus.package.include-dependency-list");
        if (oldVal == null) {
            return ctxt.proceed(ni.getName());
        }
        return oldVal.withName(ni.getName());
    }

    private static ConfigValue quarkusNativeSourcesOnly(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        ConfigValue ptVal = ctxt.restart("quarkus.package.type");
        if (ptVal == null) {
            return ctxt.proceed(ni.getName());
        }
        return ptVal.withName(ni.getName()).withValue(Boolean.toString(ptVal.getValue().equals("native-sources")));
    }

    private static ConfigValue quarkusPackageJarManifestAttributes(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        ni.goToEnd();
        ni.previous();
        String oldName = "quarkus.package.manifest.attributes." + ni.getName().substring(ni.getPosition() + 1);
        ConfigValue oldVal = ctxt.restart(oldName);
        if (oldVal == null) {
            return ctxt.proceed(ni.getName());
        }
        return oldVal.withName(ni.getName());
    }

    private static ConfigValue quarkusPackageJarManifestSections(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        ni.goToEnd();
        ni.previous();
        ni.previous();
        String oldName = "quarkus.package.manifest.sections." + ni.getName().substring(ni.getPosition() + 1);
        ConfigValue oldVal = ctxt.restart(oldName);
        if (oldVal == null) {
            return ctxt.proceed(ni.getName());
        }
        return oldVal.withName(ni.getName());
    }

    private static ConfigValue quarkusPackageJarManifestAddImplementationEntries(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        ConfigValue oldVal = ctxt.restart("quarkus.package.manifest.add-implementation-entries");
        if (oldVal == null) {
            return ctxt.proceed(ni.getName());
        }
        return oldVal.withName(ni.getName());
    }

    private static ConfigValue quarkusPackageDecompilerEnabled(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        ConfigValue oldVal = ctxt.restart("quarkus.package.vineflower.enabled");
        if (oldVal == null) {
            return ctxt.proceed(ni.getName());
        }
        return oldVal.withName(ni.getName());
    }

    private static ConfigValue quarkusPackageDecompilerJarDirectory(ConfigSourceInterceptorContext ctxt, NameIterator ni) {
        ConfigValue oldVal = ctxt.restart("quarkus.package.vineflower.jar-directory");
        if (oldVal == null) {
            return ctxt.proceed(ni.getName());
        }
        return oldVal.withName(ni.getName());
    }

    @SafeVarargs
    private static <T> KeyMap<T> keyMap(Map.Entry<List<String>, T> ... entries) {
        KeyMap keyMap = new KeyMap();
        for (Map.Entry<List<String>, T> entry : entries) {
            KeyMap subMap = keyMap;
            for (String part : entry.getKey()) {
                if (part.equals("*")) {
                    subMap = subMap.getOrCreateAny();
                    continue;
                }
                KeyMap tryMap = (KeyMap)subMap.get((Object)part);
                if (tryMap == null) {
                    tryMap = new KeyMap();
                    subMap.put((Object)part, (Object)tryMap);
                }
                subMap = tryMap;
            }
            subMap.putRootValue(entry.getValue());
        }
        return keyMap;
    }

    @Priority(value=-2147483647)
    public static final class BackEnd
    implements ConfigSourceInterceptor {
        private static final long serialVersionUID = 6840768821115677665L;
        private static final BackEnd instance = new BackEnd();

        private BackEnd() {
        }

        public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
            NameIterator ni = new NameIterator(name);
            BiFunction function = (BiFunction)newNames.findRootValue(ni);
            return function != null ? (ConfigValue)function.apply(context, ni) : context.proceed(name);
        }

        public static BackEnd instance() {
            return instance;
        }
    }

    @Priority(value=0x7FFFFFFF)
    public static final class FrontEnd
    implements ConfigSourceInterceptor {
        private static final long serialVersionUID = -3438497970389074611L;
        private static final FrontEnd instance = new FrontEnd(true);
        private static final FrontEnd nonLoggingInstance = new FrontEnd(false);
        private final boolean logging;

        private FrontEnd(boolean logging) {
            this.logging = logging;
        }

        public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
            return context.proceed(name);
        }

        public Iterator<String> iterateNames(final ConfigSourceInterceptorContext context) {
            final Iterator nextIter = context.iterateNames();
            return new Iterator<String>(){
                Iterator<String> subIter = Collections.emptyIterator();
                String next;

                @Override
                public boolean hasNext() {
                    while (this.next == null) {
                        if (this.subIter.hasNext()) {
                            this.next = this.subIter.next();
                            return true;
                        }
                        if (!nextIter.hasNext()) {
                            return false;
                        }
                        String next = (String)nextIter.next();
                        BiFunction fn = (BiFunction)oldNames.findRootValue(next);
                        if (fn == null) {
                            this.next = next;
                            return true;
                        }
                        List list = (List)fn.apply(context, new NameIterator(next));
                        this.subIter = list.iterator();
                        if (!logging) continue;
                        if (list.isEmpty()) {
                            log.warnf("Configuration property '%s' has been deprecated and will be ignored", (Object)next);
                            continue;
                        }
                        log.warnf("Configuration property '%s' has been deprecated and replaced by: %s", (Object)next, (Object)list);
                    }
                    return true;
                }

                @Override
                public String next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    String next = this.next;
                    this.next = null;
                    return next;
                }
            };
        }

        public static FrontEnd instance() {
            return instance;
        }

        public static FrontEnd nonLoggingInstance() {
            return nonLoggingInstance;
        }
    }
}

