/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.dev.console;

import io.quarkus.dev.console.InputHandler;
import io.quarkus.dev.console.QuarkusConsole;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BasicConsole
extends QuarkusConsole {
    private static final Logger log = Logger.getLogger(BasicConsole.class.getName());
    private static final Logger statusLogger = Logger.getLogger("quarkus");
    final PrintStream printStream;
    final boolean inputSupport;
    final boolean noColor;

    public BasicConsole(boolean noColor, boolean inputSupport, PrintStream printStream) {
        this.noColor = noColor;
        this.inputSupport = inputSupport;
        this.printStream = printStream;
        if (inputSupport) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (true) {
                            int val;
                            if ((val = System.in.read()) == -1) {
                                return;
                            }
                            QuarkusConsole.InputHolder handler = (QuarkusConsole.InputHolder)BasicConsole.this.inputHandlers.peek();
                            if (handler == null) continue;
                            handler.handler.handleInput(new int[]{val});
                        }
                    }
                    catch (IOException e) {
                        log.log(Level.SEVERE, "Failed to read user input", e);
                        return;
                    }
                }
            }, "Quarkus Terminal Reader");
            t.setDaemon(true);
            t.start();
        }
    }

    @Override
    public QuarkusConsole.InputHolder createHolder(InputHandler inputHandler) {
        return new QuarkusConsole.InputHolder(inputHandler){

            @Override
            protected void setPromptMessage(String prompt) {
                if (!BasicConsole.this.inputSupport) {
                    return;
                }
                if (prompt == null) {
                    return;
                }
                statusLogger.info(prompt);
            }

            @Override
            protected void setStatusMessage(String status) {
                if (status == null) {
                    return;
                }
                statusLogger.info(status);
            }
        };
    }

    @Override
    public void write(String s) {
        if (this.outputFilter != null && !this.outputFilter.test(s)) {
            return;
        }
        if (this.noColor || !BasicConsole.hasColorSupport()) {
            this.printStream.print(this.stripAnsiCodes(s));
        } else {
            this.printStream.print(s);
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.write(new String(buf, off, len, Charset.defaultCharset()));
    }
}

