/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts;

import io.quarkus.devtools.codestarts.Codestart;
import io.quarkus.devtools.codestarts.CodestartData;
import io.quarkus.devtools.codestarts.CodestartDefinitionException;
import io.quarkus.devtools.codestarts.CodestartPathProcessor;
import io.quarkus.devtools.codestarts.CodestartResourceLoader;
import io.quarkus.devtools.codestarts.reader.CodestartFile;
import io.quarkus.devtools.codestarts.reader.CodestartFileReader;
import io.quarkus.devtools.codestarts.strategy.CodestartFileStrategy;
import io.quarkus.devtools.codestarts.strategy.CodestartFileStrategyHandler;
import io.quarkus.devtools.codestarts.strategy.DefaultCodestartFileStrategyHandler;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class CodestartProcessor {
    private final CodestartResourceLoader resourceLoader;
    private final String languageName;
    private final Path targetDirectory;
    private final List<CodestartFileStrategy> strategies;
    private final Map<String, Object> data;
    private final Map<String, List<CodestartFile>> files = new LinkedHashMap<String, List<CodestartFile>>();

    CodestartProcessor(CodestartResourceLoader resourceLoader, String languageName, Path targetDirectory, List<CodestartFileStrategy> strategies, Map<String, Object> data) {
        this.resourceLoader = resourceLoader;
        this.languageName = languageName;
        this.targetDirectory = targetDirectory;
        this.strategies = strategies;
        this.data = data;
    }

    void process(Codestart codestart) throws IOException {
        this.addBuiltinData();
        this.resourceLoader.loadResourceAsPath(codestart.getResourceDir(), p -> {
            Path baseDir = p.resolve("base");
            Path languageDir = p.resolve(this.languageName);
            Stream.of(baseDir, languageDir).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(dirPath -> this.processCodestartDir((Path)dirPath, CodestartData.buildCodestartData(codestart, this.languageName, this.data)));
            return null;
        });
    }

    void addBuiltinData() {
        this.data.put("gen-info", Collections.singletonMap("time", System.currentTimeMillis()));
    }

    void processCodestartDir(Path sourceDirectory, Map<String, Object> finalData) {
        List<Path> sources = this.findSources(sourceDirectory);
        for (Path sourcePath : sources) {
            Path relativeSourcePath = sourceDirectory.relativize(sourcePath);
            if (Files.isDirectory(sourcePath, new LinkOption[0])) continue;
            String sourceFileName = sourcePath.getFileName().toString();
            Optional<CodestartFileReader> possibleReader = CodestartFileReader.ALL.stream().filter(r -> r.matches(sourceFileName)).findFirst();
            CodestartFileReader reader = possibleReader.orElse(CodestartFileReader.DEFAULT);
            String targetFileName = reader.cleanFileName(sourceFileName);
            Path relativeTargetPath = relativeSourcePath.getNameCount() > 1 ? relativeSourcePath.getParent().resolve(targetFileName) : Paths.get(targetFileName, new String[0]);
            boolean hasFileStrategyHandler = this.getStrategy(relativeTargetPath.toString()).isPresent();
            try {
                String processedRelativeTargetPath = CodestartPathProcessor.process(relativeTargetPath.toString(), finalData);
                if (!possibleReader.isPresent() && !hasFileStrategyHandler) {
                    Path targetPath = this.targetDirectory.resolve(processedRelativeTargetPath);
                    this.getSelectedDefaultStrategy().copyStaticFile(sourcePath, targetPath);
                    continue;
                }
                Optional<String> content = reader.read(sourceDirectory, relativeSourcePath, this.languageName, finalData);
                if (!content.isPresent()) continue;
                this.files.putIfAbsent(processedRelativeTargetPath, new ArrayList());
                this.files.get(processedRelativeTargetPath).add(new CodestartFile(processedRelativeTargetPath, content.get()));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Path> findSources(Path sourceDirectory) {
        try (Stream<Path> pathStream = Files.walk(sourceDirectory, new FileVisitOption[0]);){
            List<Path> list = pathStream.filter(path -> !path.equals(sourceDirectory)).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    void checkTargetDir() throws IOException {
        if (!Files.exists(this.targetDirectory, new LinkOption[0])) {
            boolean mkdirStatus = this.targetDirectory.toFile().mkdirs();
            if (!mkdirStatus) {
                throw new IOException("Failed to create the project directory: " + this.targetDirectory);
            }
            return;
        }
        if (!Files.isDirectory(this.targetDirectory, new LinkOption[0])) {
            throw new IOException("Project path needs to point to a directory: " + this.targetDirectory);
        }
        String[] files = this.targetDirectory.toFile().list();
        if (files != null && files.length > 0) {
            throw new IOException("You can't create a project when the directory is not empty: " + this.targetDirectory);
        }
    }

    public void writeFiles() throws IOException {
        for (Map.Entry<String, List<CodestartFile>> e : this.files.entrySet()) {
            String relativePath = e.getKey();
            this.getStrategy(relativePath).orElse(this.getSelectedDefaultStrategy()).process(this.targetDirectory, relativePath, e.getValue(), this.data);
        }
    }

    DefaultCodestartFileStrategyHandler getSelectedDefaultStrategy() {
        for (CodestartFileStrategy codestartFileStrategy : this.strategies) {
            if (!Objects.equals(codestartFileStrategy.getFilter(), "*")) continue;
            if (codestartFileStrategy.getHandler() instanceof DefaultCodestartFileStrategyHandler) {
                return (DefaultCodestartFileStrategyHandler)codestartFileStrategy.getHandler();
            }
            throw new CodestartDefinitionException(codestartFileStrategy.getHandler().name() + " can't be used as '*' file strategy");
        }
        return CodestartFileStrategyHandler.DEFAULT_STRATEGY;
    }

    Optional<CodestartFileStrategyHandler> getStrategy(String key) {
        for (CodestartFileStrategy codestartFileStrategy : this.strategies) {
            if (!codestartFileStrategy.test(key)) continue;
            return Optional.of(codestartFileStrategy.getHandler());
        }
        return Optional.empty();
    }

    static List<CodestartFileStrategy> buildStrategies(Map<String, String> spec) {
        ArrayList<CodestartFileStrategy> codestartFileStrategyHandlers = new ArrayList<CodestartFileStrategy>(spec.size());
        for (Map.Entry<String, String> entry : spec.entrySet()) {
            CodestartFileStrategyHandler handler = CodestartFileStrategyHandler.BY_NAME.get(entry.getValue());
            if (handler == null) {
                throw new CodestartDefinitionException("ConflictStrategyHandler named '" + entry.getValue() + "' not found. Used with filter '" + entry.getKey() + "'");
            }
            codestartFileStrategyHandlers.add(new CodestartFileStrategy(entry.getKey(), handler));
        }
        return codestartFileStrategyHandlers;
    }
}

