/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import io.quarkus.registry.model.ArtifactKey;
import io.quarkus.registry.model.Extension;
import io.quarkus.registry.model.ImmutableExtension;
import io.quarkus.registry.model.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;

public final class ModifiableExtension
implements Extension {
    private static final long INIT_BIT_ID = 1L;
    private static final long INIT_BIT_NAME = 2L;
    private long initBits = 3L;
    private ArtifactKey id;
    private String name;
    @Nullable
    private String description;
    private final Map<String, Object> metadata = new LinkedHashMap<String, Object>();
    private final TreeSet<Extension.ExtensionRelease> releases = new TreeSet(Collections.reverseOrder());

    private ModifiableExtension() {
    }

    public static ModifiableExtension create() {
        return new ModifiableExtension();
    }

    @Override
    @JsonProperty(value="id")
    @JsonUnwrapped
    public final ArtifactKey getId() {
        if (!this.idIsSet()) {
            this.checkRequiredAttributes();
        }
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    public final String getName() {
        if (!this.nameIsSet()) {
            this.checkRequiredAttributes();
        }
        return this.name;
    }

    @Override
    @JsonProperty(value="description")
    @Nullable
    public final String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="metadata")
    public final Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="releases")
    public final SortedSet<Extension.ExtensionRelease> getReleases() {
        return this.releases;
    }

    public ModifiableExtension clear() {
        this.initBits = 3L;
        this.id = null;
        this.name = null;
        this.description = null;
        this.metadata.clear();
        this.releases.clear();
        return this;
    }

    public ModifiableExtension from(Extension instance) {
        Objects.requireNonNull(instance, "instance");
        if (instance instanceof ModifiableExtension) {
            this.from((ModifiableExtension)instance);
            return this;
        }
        this.setId(instance.getId());
        this.setName(instance.getName());
        String descriptionValue = instance.getDescription();
        if (descriptionValue != null) {
            this.setDescription(descriptionValue);
        }
        this.putAllMetadata(instance.getMetadata());
        this.addAllReleases(instance.getReleases());
        return this;
    }

    public ModifiableExtension from(ModifiableExtension instance) {
        String descriptionValue;
        Objects.requireNonNull(instance, "instance");
        if (instance.idIsSet()) {
            this.setId(instance.getId());
        }
        if (instance.nameIsSet()) {
            this.setName(instance.getName());
        }
        if ((descriptionValue = instance.getDescription()) != null) {
            this.setDescription(descriptionValue);
        }
        this.putAllMetadata(instance.getMetadata());
        this.addAllReleases(instance.getReleases());
        return this;
    }

    public ModifiableExtension setId(ArtifactKey id) {
        this.id = Objects.requireNonNull(id, "id");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    public ModifiableExtension setName(String name) {
        this.name = Objects.requireNonNull(name, "name");
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return this;
    }

    public ModifiableExtension setDescription(@Nullable String description) {
        this.description = description;
        return this;
    }

    public ModifiableExtension putMetadata(String key, Object value) {
        this.metadata.put(Objects.requireNonNull(key, "metadata key"), Objects.requireNonNull(value, "metadata value"));
        return this;
    }

    public ModifiableExtension setMetadata(Map<String, ? extends Object> entries) {
        this.metadata.clear();
        for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
            String k = e.getKey();
            Object v = e.getValue();
            this.metadata.put(Objects.requireNonNull(k, "metadata key"), Objects.requireNonNull(v, "metadata value"));
        }
        return this;
    }

    public ModifiableExtension putAllMetadata(Map<String, ? extends Object> entries) {
        for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
            String k = e.getKey();
            Object v = e.getValue();
            this.metadata.put(Objects.requireNonNull(k, "metadata key"), Objects.requireNonNull(v, "metadata value"));
        }
        return this;
    }

    public ModifiableExtension addReleases(Extension.ExtensionRelease element) {
        Objects.requireNonNull(element, "releases element");
        this.releases.add(element);
        return this;
    }

    public final ModifiableExtension addReleases(Extension.ExtensionRelease ... elements) {
        for (Extension.ExtensionRelease e : elements) {
            this.addReleases(e);
        }
        return this;
    }

    public ModifiableExtension setReleases(Iterable<? extends Extension.ExtensionRelease> elements) {
        this.releases.clear();
        this.addAllReleases(elements);
        return this;
    }

    public ModifiableExtension addAllReleases(Iterable<? extends Extension.ExtensionRelease> elements) {
        for (Extension.ExtensionRelease extensionRelease : elements) {
            this.addReleases(extensionRelease);
        }
        return this;
    }

    public final boolean idIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    public final boolean nameIsSet() {
        return (this.initBits & 2L) == 0L;
    }

    public final ModifiableExtension unsetId() {
        this.initBits |= 1L;
        this.id = null;
        return this;
    }

    public final ModifiableExtension unsetName() {
        this.initBits |= 2L;
        this.name = null;
        return this;
    }

    public final boolean isInitialized() {
        return this.initBits == 0L;
    }

    private void checkRequiredAttributes() {
        if (!this.isInitialized()) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (!this.idIsSet()) {
            attributes.add("id");
        }
        if (!this.nameIsSet()) {
            attributes.add("name");
        }
        return "Extension is not initialized, some of the required attributes are not set " + attributes;
    }

    public final ImmutableExtension toImmutable() {
        this.checkRequiredAttributes();
        return ImmutableExtension.copyOf(this);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof ModifiableExtension)) {
            return false;
        }
        ModifiableExtension other = (ModifiableExtension)another;
        if (!this.isInitialized() || !other.isInitialized()) {
            return false;
        }
        return this.equalTo(other);
    }

    private boolean equalTo(ModifiableExtension another) {
        return this.id.equals(another.id);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        return h;
    }

    public String toString() {
        return "ModifiableExtension{id=" + (this.idIsSet() ? this.getId() : "?") + "}";
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T extends Comparable<T>> NavigableSet<T> createUnmodifiableSortedSet(boolean reverse, List<T> list) {
        TreeSet set = reverse ? new TreeSet(Collections.reverseOrder()) : new TreeSet();
        set.addAll(list);
        return Collections.unmodifiableNavigableSet(set);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }
}

