/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import io.quarkus.registry.model.Extension;
import io.quarkus.registry.model.ImmutableExtensionRelease;
import io.quarkus.registry.model.Release;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class ModifiableExtensionRelease
implements Extension.ExtensionRelease {
    private static final long INIT_BIT_RELEASE = 1L;
    private long initBits = 1L;
    private Release release;
    private final LinkedHashSet<Extension.ExtensionPlatformRelease> platforms = new LinkedHashSet();

    private ModifiableExtensionRelease() {
    }

    public static ModifiableExtensionRelease create() {
        return new ModifiableExtensionRelease();
    }

    @Override
    @JsonProperty(value="release")
    @JsonUnwrapped
    public final Release getRelease() {
        if (!this.releaseIsSet()) {
            this.checkRequiredAttributes();
        }
        return this.release;
    }

    @Override
    @JsonProperty(value="platforms")
    public final Set<Extension.ExtensionPlatformRelease> getPlatforms() {
        return this.platforms;
    }

    public ModifiableExtensionRelease clear() {
        this.initBits = 1L;
        this.release = null;
        this.platforms.clear();
        return this;
    }

    public ModifiableExtensionRelease from(Extension.ExtensionRelease instance) {
        Objects.requireNonNull(instance, "instance");
        if (instance instanceof ModifiableExtensionRelease) {
            this.from((ModifiableExtensionRelease)instance);
            return this;
        }
        this.setRelease(instance.getRelease());
        this.addAllPlatforms(instance.getPlatforms());
        return this;
    }

    public ModifiableExtensionRelease from(ModifiableExtensionRelease instance) {
        Objects.requireNonNull(instance, "instance");
        if (instance.releaseIsSet()) {
            this.setRelease(instance.getRelease());
        }
        this.addAllPlatforms(instance.getPlatforms());
        return this;
    }

    public ModifiableExtensionRelease setRelease(Release release) {
        this.release = Objects.requireNonNull(release, "release");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    public ModifiableExtensionRelease addPlatforms(Extension.ExtensionPlatformRelease element) {
        Objects.requireNonNull(element, "platforms element");
        this.platforms.add(element);
        return this;
    }

    public final ModifiableExtensionRelease addPlatforms(Extension.ExtensionPlatformRelease ... elements) {
        for (Extension.ExtensionPlatformRelease e : elements) {
            this.addPlatforms(e);
        }
        return this;
    }

    public ModifiableExtensionRelease setPlatforms(Iterable<? extends Extension.ExtensionPlatformRelease> elements) {
        this.platforms.clear();
        this.addAllPlatforms(elements);
        return this;
    }

    public ModifiableExtensionRelease addAllPlatforms(Iterable<? extends Extension.ExtensionPlatformRelease> elements) {
        for (Extension.ExtensionPlatformRelease extensionPlatformRelease : elements) {
            this.addPlatforms(extensionPlatformRelease);
        }
        return this;
    }

    public final boolean releaseIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    public final ModifiableExtensionRelease unsetRelease() {
        this.initBits |= 1L;
        this.release = null;
        return this;
    }

    public final boolean isInitialized() {
        return this.initBits == 0L;
    }

    private void checkRequiredAttributes() {
        if (!this.isInitialized()) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (!this.releaseIsSet()) {
            attributes.add("release");
        }
        return "ExtensionRelease is not initialized, some of the required attributes are not set " + attributes;
    }

    public final ImmutableExtensionRelease toImmutable() {
        this.checkRequiredAttributes();
        return ImmutableExtensionRelease.copyOf(this);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof ModifiableExtensionRelease)) {
            return false;
        }
        ModifiableExtensionRelease other = (ModifiableExtensionRelease)another;
        if (!this.isInitialized() || !other.isInitialized()) {
            return false;
        }
        return this.equalTo(other);
    }

    private boolean equalTo(ModifiableExtensionRelease another) {
        return this.release.equals(another.release);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.release.hashCode();
        return h;
    }

    public String toString() {
        return "ModifiableExtensionRelease{release=" + (this.releaseIsSet() ? this.getRelease() : "?") + "}";
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }
}

