/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.CodestartResourceLoadersBuilder;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.extensions.ExtensionManager;
import io.quarkus.platform.tools.ToolsUtils;
import io.quarkus.registry.ExtensionCatalogResolver;
import io.quarkus.registry.RegistryResolutionException;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.config.RegistriesConfig;
import io.quarkus.registry.config.RegistriesConfigLocator;
import java.nio.file.Path;

public class QuarkusProjectHelper {
    private static RegistriesConfig toolsConfig;
    private static MessageWriter log;
    private static MavenArtifactResolver artifactResolver;
    private static ExtensionCatalogResolver catalogResolver;

    public static QuarkusProject getProject(Path projectDir) {
        BuildTool buildTool = QuarkusProject.resolveExistingProjectBuildTool(projectDir);
        if (buildTool == null) {
            buildTool = BuildTool.MAVEN;
        }
        return QuarkusProjectHelper.getProject(projectDir, buildTool);
    }

    @Deprecated
    public static QuarkusProject getProject(Path projectDir, String quarkusVersion) {
        BuildTool buildTool = QuarkusProject.resolveExistingProjectBuildTool(projectDir);
        if (buildTool == null) {
            buildTool = BuildTool.MAVEN;
        }
        return QuarkusProjectHelper.getProject(projectDir, buildTool, quarkusVersion);
    }

    @Deprecated
    public static QuarkusProject getProject(Path projectDir, BuildTool buildTool, String quarkusVersion) {
        return QuarkusProjectHelper.getProject(projectDir, QuarkusProjectHelper.getExtensionCatalog(quarkusVersion), buildTool);
    }

    @Deprecated
    public static ExtensionCatalog getExtensionCatalog(String quarkusVersion) {
        ExtensionCatalogResolver catalogResolver = QuarkusProjectHelper.getCatalogResolver();
        try {
            return catalogResolver.hasRegistries() ? catalogResolver.resolveExtensionCatalog(quarkusVersion) : ToolsUtils.resolvePlatformDescriptorDirectly(null, null, quarkusVersion, QuarkusProjectHelper.artifactResolver(), QuarkusProjectHelper.messageWriter());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to resolve the Quarkus extension catalog", e);
        }
    }

    public static QuarkusProject getProject(Path projectDir, BuildTool buildTool) {
        ExtensionCatalog catalog;
        try {
            catalog = QuarkusProjectHelper.resolveExtensionCatalog();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to resolve the Quarkus extension catalog", e);
        }
        return QuarkusProjectHelper.getProject(projectDir, catalog, buildTool, QuarkusProjectHelper.messageWriter());
    }

    public static QuarkusProject getProject(Path projectDir, ExtensionCatalog catalog, BuildTool buildTool) {
        return QuarkusProjectHelper.getProject(projectDir, catalog, buildTool, QuarkusProjectHelper.messageWriter());
    }

    public static QuarkusProject getProject(Path projectDir, ExtensionCatalog catalog, BuildTool buildTool, MessageWriter log) {
        return QuarkusProject.of(projectDir, catalog, CodestartResourceLoadersBuilder.getCodestartResourceLoaders(catalog), log, buildTool);
    }

    public static QuarkusProject getProject(Path projectDir, ExtensionManager extManager) throws RegistryResolutionException {
        return QuarkusProjectHelper.getProject(projectDir, QuarkusProjectHelper.resolveExtensionCatalog(), extManager, QuarkusProjectHelper.messageWriter());
    }

    public static ExtensionCatalog resolveExtensionCatalog() throws RegistryResolutionException {
        return QuarkusProjectHelper.getCatalogResolver().resolveExtensionCatalog();
    }

    public static QuarkusProject getProject(Path projectDir, ExtensionCatalog catalog, ExtensionManager extManager, MessageWriter log) {
        return QuarkusProject.of(projectDir, catalog, CodestartResourceLoadersBuilder.getCodestartResourceLoaders(catalog), log, extManager);
    }

    public static ExtensionCatalogResolver getCatalogResolver() {
        return catalogResolver == null ? (catalogResolver = QuarkusProjectHelper.getCatalogResolver(QuarkusProjectHelper.artifactResolver(), QuarkusProjectHelper.messageWriter())) : catalogResolver;
    }

    public static ExtensionCatalogResolver getCatalogResolver(MessageWriter log) {
        return catalogResolver == null ? (catalogResolver = QuarkusProjectHelper.getCatalogResolver(QuarkusProjectHelper.artifactResolver(), log)) : catalogResolver;
    }

    public static ExtensionCatalogResolver getCatalogResolver(MavenArtifactResolver resolver, MessageWriter log) {
        return ExtensionCatalogResolver.builder().artifactResolver(resolver).config(QuarkusProjectHelper.toolsConfig()).messageWriter(log).build();
    }

    public static RegistriesConfig toolsConfig() {
        return toolsConfig == null ? (toolsConfig = RegistriesConfigLocator.resolveConfig()) : toolsConfig;
    }

    public static MessageWriter messageWriter() {
        return log == null ? (log = QuarkusProjectHelper.toolsConfig().isDebug() ? MessageWriter.debug() : MessageWriter.info()) : log;
    }

    public static MavenArtifactResolver artifactResolver() {
        if (artifactResolver == null) {
            try {
                artifactResolver = ((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setArtifactTransferLogging(QuarkusProjectHelper.toolsConfig().isDebug())).setWorkspaceDiscovery(false)).build();
            }
            catch (BootstrapMavenException e) {
                throw new IllegalStateException("Failed to initialize the Maven artifact resolver", e);
            }
        }
        return artifactResolver;
    }
}

